/*  Gaby
 *  Copyright (C) 1998-1999 Frederic Peters
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gaby.h>
#include <glade/glade.h>
#include <tables.h>
#include <records.h>
#include <f_config.h>
#include <gtk_config_dlg.h>	/* for gaby_property_box_changed */
#include <gtk_main.h>
#include <gtk_menu.h>	/* for gaby_quit_callback */


mstatic void gladeform_create ( gabywindow *window, gboolean first );
mstatic void gladeform_fill ( gabywindow *window );

static gboolean initialized;

#ifndef FOLLOW_MIGUEL
int init_view_plugin (ViewPluginData *vpd)
{
	vpd->view_create = gladeform_create;
	vpd->view_fill = gladeform_fill;
	vpd->configure = NULL;

	vpd->name = "gladeform";
	vpd->i18n_name = _("Glade form");
	vpd->type = ONE_RECORD;
	vpd->capabilities = EDITABLE;

	initialized = FALSE;

#ifdef DEBUG_GABY
	debug_print(_("Initialization of view plugin '%s' done succesfully.\n"),
			vpd->i18n_name );
#endif

	return 0;
}
#endif

static void glade_get_widgets(GladeXML *xml, subtable *st, GtkWidget **fields);

mstatic void gladeform_create ( gabywindow *window, gboolean first )
{
	GtkWidget *vbox;
	GtkWidget *wid;
	GladeXML *xml;
	char filename[PATH_MAX];
	FILE *f;
	GtkWidget **fields;
	int *id;
	record *r;

	if ( initialized == FALSE ) {
		glade_init();
		initialized = TRUE;
	}

	vbox = gtk_vbox_new(FALSE, 0);
	window->widget = vbox;
	gtk_widget_show(vbox);

	sprintf(filename, "%s/.gaby/%s.glade", g_get_home_dir(), \
				window->view->subtable->name );
	while ( strchr(filename, ' ') )
		strchr(filename, ' ')[0] = '_';
#ifdef DEBUG_GABY
	debug_print("[glade:create] trying %s\n", filename);
#endif
	f = fopen(filename, "r");
	if ( f == NULL ) {
		sprintf(filename, "%s/view/%s.glade", PLUGINS_DIR, \
				window->view->subtable->name );
		while ( strchr(filename, ' ') )
			strchr(filename, ' ')[0] = '_';
#ifdef DEBUG_GABY
		debug_print("[glade:create] trying %s\n", filename);
#endif
		f = fopen(filename, "r");
		if ( f == NULL )
			return;
	}
	fclose(f);
	
#if 0
	xml = glade_xml_new(filename, NULL );
	glade_xml_signal_autoconnect(xml);
	
	wid = glade_xml_get_widget(xml, "form");
	/* 
	 * gtk_container_remove (and gtk_widget_unparent) seems to _destroy_
	 * the widget (GTK_IS_WIDGET(wid) fails after them) and this is not
	 * what I want ... so I simply set parent to NULL which will cause lots
	 * of trouble if the previous container is shown ...
	 */
	wid->parent = NULL;
#else
	/* James Henstridge <james@daa.com.au> mailed me and told me that this
	 * will work - I need to update libglade before trying it */
	      
	xml = glade_xml_new(filename, "form");
	glade_xml_signal_autoconnect(xml);
	wid = glade_xml_get_widget(xml, "form");
#endif
	
	fields = g_malloc(sizeof(GtkWidget *) * window->view->subtable->nb_fields);
	glade_get_widgets(xml, window->view->subtable, fields);
	gtk_object_set_data(GTK_OBJECT(vbox), "fields", fields);
	gtk_box_pack_start(GTK_BOX(vbox), wid, TRUE, TRUE, 0 );
	gtk_widget_show(wid);
	gtk_widget_show(vbox);

	id = &(window->id);
	r = table_first(window->view->subtable->table, -1);
	*id = ( r == NULL ) ? 0 : r->id;
	
	return; 
}

mstatic void glade_fill ( gabywindow *window )
{
	view *v = window->view;
	subtable *st = v->subtable;
	GtkWidget *wid = window->widget;
	GtkWidget **fields = gtk_object_get_data(GTK_OBJECT(wid), "fields");
	GString *str;
	int *id = &(window->id);
	int i;
	
	for ( i=0; i < st->nb_fields; i++ ) {
		str = get_subtable_stringed_field_id(st, *id, i);
		if ( GTK_IS_ENTRY(fields[i]) ) {
			gtk_entry_set_text(GTK_ENTRY(fields[i]), str->str);
		}
		g_string_free(str, 1);
	}
}

static void glade_get_widgets(GladeXML *xml, subtable *st, GtkWidget **fields)
{
	int i;
	char str[50];
	
	for ( i=0; i < st->nb_fields; i++ ) {
		strcpy(str, st->fields[i].name);
/*		while ( strchr(str, ' ') ) strchr(str, ' ')[0] = '_'; */
		fields[i] = glade_xml_get_widget(xml, str);
#ifdef DEBUG_GABY
		debug_print("[glade_get_widgets] %d : %p\n", i, fields[i]);
#endif
	}
}

static void hello_world(GtkWidget *but, gpointer data)
{
	g_print("hello, world !\n");
}

