/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : waveshap.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitWaveShaper
|
| Description : DSPKitWaveShaper
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char waveshap_cc [] = "$Id$";

#include "waveshap.h"

long DSPKitWaveShaper::setInputAndBuffer
  (DSPKitProcessor *ip,DSPKitDPReader *bip)
{
  double bufSample;
  long i;

  DSPKitProcessor::setInput (ip);
  bip->setOutput (this);
  size = bip->getSampleCount ();
  buffer = new double [size];
  if (!buffer) return -1;
  for (i=0; i<size; i++) buffer [i] = 0.0;

  minValue = 0.0;
  maxValue = 0.0;

  for (i=0; bip->getSample (bufSample) && i<size; i++)
  {
    buffer [i] = bufSample;
    if (bufSample < minValue) minValue = bufSample;
    else if (bufSample > maxValue) maxValue = bufSample;
  }
  range = maxValue - minValue;
  return 0;
}

long DSPKitWaveShaper::setInputAndBuffer
  (DSPKitProcessor *ip,DSPKitDistortion *bip)
{
  double bufSample;
  long i;

  DSPKitProcessor::setInput (ip);
  bip->setOutput (this);
  size = bip->getSampleCount ();
  buffer = new double [size];
  if (!buffer) return -1;
  for (i=0; i<size; i++) buffer [i] = 0.0;

  minValue = 0.0;
  maxValue = 0.0;

  for (i=0; bip->getSample (bufSample) && i<size; i++)
  {
    buffer [i] = bufSample;
    if (bufSample < minValue) minValue = bufSample;
    else if (bufSample > maxValue) maxValue = bufSample;
  }
  range = maxValue - minValue;
  return 0;
}
    
long DSPKitWaveShaper::getSample (double &outputSample)
{
  double inputSample;

  if (!input->getSample (inputSample)) return 0;

  if (inputSample <= minValue)
  {
    outputSample = minValue;
    return 1;
  }
  else if (inputSample >= maxValue)
  {
    outputSample = maxValue;
    return 1;
  }

  double scaledSample = (inputSample - minValue) * size / range;
  long index1         = (long) scaledSample;
  double remainder    = scaledSample - index1;
  long index2         = index1 + 1;
  
  if (index1 < 0)
  {
    index1    = 0;
    remainder = 0.0;
    index2    = index1;
  }
  else if (index1 >= size)
  {
    index1    = size - 1;
    remainder = 0.0;
    index2    = index1;
  }

  outputSample =
    buffer [index1] + remainder * (buffer [index2] - buffer [index1]);

  return 1;
}

/***************************************************************************/
