/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : feedback.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitFeedback
|
| Description : DSPKitFeedback
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char feedback_cc [] = "$Id$";

#include "feedback.h"

long DSPKitFeedback::setInput (DSPKitProcessor *ip)
{
  if (DSPKitProcessor::setInput (ip) != 0) return -1;
  feedbackTime        = 0.0;
  feedbackSampleCount = 0;
  feedbackSampleIndex = 0;
  haveInput           = 1;
  feedbackInput       = 0;
  return 0;
}

void DSPKitFeedback::setFeedbackInput (DSPKitProcessor *fip)
{
  feedbackInput = fip;
  feedbackInput->setOutput (this);
  haveFeedback = 1;
}

void DSPKitFeedback::setFeedbackTime (double t)
{
  feedbackTime = t;
  feedbackSampleCount = (long)(feedbackTime * inputSamplingRate);
}

long DSPKitFeedback::getSample (double &outputSample)
{
  double feedbackSample;

  haveInput = input->getSample (outputSample);
  haveFeedback = feedbackInput->getSample (feedbackSample);
  
  if (!haveInput)    outputSample = 0.0;
  if (!haveFeedback) feedbackSample = 0.0;

  if (haveInput || feedbackSampleIndex < feedbackSampleCount)
  {
    outputSample += feedbackSample;
    if (haveFeedback)
    {
      if (!haveInput) feedbackSampleIndex++;
    }
    else
    {
      // Finish as soon as input finishes
      feedbackSampleIndex = feedbackSampleCount;
    }
    return 1;
  }
  else return 0;
}

/***************************************************************************/
