/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : bwbandre.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitBWBandRejectFilter
|
| Description : DSPKitBWBandRejectFilter
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char bwbandre_cc [] = "$Id$";

#include "bwbandre.h"

void DSPKitBWBandRejectFilter::setCenterFreqAndBW (double f,double bw)
{
  centerFreq = f;
  bandwidth  = bw;

  C = tan (M_PI * bandwidth / inputSamplingRate);
  D = 2 * cos (2 * M_PI * centerFreq / inputSamplingRate);

  a [0] = 1.0 / (1.0 + C);
  a [1] = -D * a [0];
  a [2] = a [0];

  b [0] = a [1];
  b [1] = (1.0 - C) * a [0];
}

/***************************************************************************/
