/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : SampleTest.cc
|
| Revision    : 1.0
| Date        : 25/01/96
|
| Object      : None
|
| Description : Main program for testing DPSample object
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char SampleTest_cc [] = "$Id$";

#include "DPSample.h"

/*--------------------------------------------------------------------------
| FUNCTION main
|
| Parameters  : Standard main arguments (argc, argv)
| Description : Main function for testing DPSample object
|
--------------------------------------------------------------------------*/

int main (int argc,char *argv [])
{
  #ifdef LINUX
  initialiseAudio ();
  #endif

  // Check arguments
  if (argc != 2)
  {
    cerr << endl << "Usage : " << argv [0] << " [filename]";
    cerr << endl << endl;
    return 0;
  }
  
  DPSample sample1;
  char *errorString;
  
  if (!(errorString = sample1.loadAIFF (argv [1])))
  {
    long x,y;
    cerr << "Please input sustain loop mode  - ";
    cin >> x;
    sample1.setSusLoopMode (x);
    cerr << "Please input sustain loop start - ";
    cin >> x;
    cerr << "Please input sustain loop end   - ";
    cin >> y;
    sample1.setSusLoop (x,y);
    cerr << "Please input release loop mode  - ";
    cin >> x;
    sample1.setRelLoopMode (x);
    cerr << "Please input release loop start - ";
    cin >> x;
    cerr << "Please input release loop end   - ";
    cin >> y;
    sample1.setRelLoop (x,y);
    if (errorString = sample1.play (2,0))
    {
      cerr << "Unable to play AIFF sample " << errorString << endl;
    }
  }
  else
  {
    cerr << "Unable to load AIFF sample " << errorString << endl;
  }
  
  return NOERROR;
}

/***************************************************************************/
