/*
 *	XMPI
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: xmpi_tr_segment.c,v 1.2 1999/08/17 03:11:13 lamteam Exp $
 *
 *	Function:	- select and view a trace segment
 */

#include <Xm/SelectioB.h>
#include "xmpi.h"

/*
 * global functions
 */
void			xmpi_tr_select_segment();

/*
 * external functions
 */
extern int		xmpi_db_parse_segment();
extern void		xmpi_db_view();

/*
 * private functions
 */
static void		selcancel_cb();
static void		selseg_cb();

/*
 *	xmpi_tr_select_segment
 *
 *	Function:	- select, parse and view a trace segment
 *	Accepts:	- maximum segment number
 */
void
xmpi_tr_select_segment(maxseg)

int			maxseg;

{
	Widget		dialog_w;		/* dialog to select segment */
	XmString	str1, str2;		/* various strings */
	Arg		args[3];
	char		buf[32];		/* formatting buffer */
/*
 * If there is only a single segment then no selection is necessary.
 */
	if (maxseg == 1) {

		if (xmpi_db_parse_segment(0)) {
			xmpi_db_free();
			xmpi_ctl_resetinfo();
		} else {
			xmpi_db_view();
		}

		xmpi_unbusy();
		return;
	}
/*
 * Pop up a dialog to choose a segment number.  The OK callback will
 * parse and view the selected segment.
 */
	sprintf(buf, "Enter segment to display (0-%d)", maxseg - 1);
	str1 = XmStringCreateSimple(buf);
	str2 = XmStringCreateSimple("0");

	XtSetArg(args[0], XmNselectionLabelString, str1);
	XtSetArg(args[1], XmNautoUnmanage, False);
	XtSetArg(args[2], XmNtextString, str2);
	
	dialog_w = XmCreatePromptDialog(xmpi_shell, "prompt_pop", args, 3);
	
	XmStringFree(str1);
	XmStringFree(str2);
	XtAddCallback(dialog_w, XmNokCallback, selseg_cb, NULL);
	XtAddCallback(dialog_w, XmNcancelCallback, selcancel_cb, NULL);
	XtSetSensitive(XmSelectionBoxGetChild(dialog_w, XmDIALOG_HELP_BUTTON),
			False);
	XtManageChild(dialog_w);
	XtPopup(XtParent(dialog_w), XtGrabNone);
}

/*
 *	selseg_cb
 *
 *	Function:	- segment selection callback, parses and views
 *			  the selected segment
 *	Accepts:	- callback parms
 */
static void
selseg_cb(w, cdata, cbs)

Widget			w;
XtPointer		cdata;
XmSelectionBoxCallbackStruct
			*cbs;

{
	char		*s;
	int		segment;		/* segment number */

	XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &s);

	segment = (s && *s) ? stoi((unsigned char *)s) : 0;

	XtFree(s);
	XtDestroyWidget(w);

	if (xmpi_db_parse_segment(segment)) {
		xmpi_db_free();
		xmpi_ctl_resetinfo();
	} else {
		xmpi_db_view();
	}

	xmpi_unbusy();
}

/*
 *	selcancel_cb
 *
 *	Function:	- segment selection cancel callback
 *	Accepts:	- callback parms
 */
static void
selcancel_cb(w, cdata, cbs)

Widget			w;
XtPointer		cdata;
XmSelectionBoxCallbackStruct
			*cbs;

{
	xmpi_ctl_resetinfo();
	XtDestroyWidget(w);
}
