/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: xmpi_aschema.c,v 1.2 1999/11/08 06:20:22 bbarrett Exp $
 *
 *	Function:	- dialog window for browsing application schemata
 */

#define _NO_PROTO

#include <Xm/Xm.h>
#include <Xm/FileSB.h>

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "xmpi.h"

/*
 * global functions
 */
void			xmpi_aschema_dialog();
void			xmpi_aschema_busy();
void			xmpi_aschema_unbusy();

/*
 * local functions
 */
static void		runapp();

/*
 * local variables
 */
static Widget		appdialog = 0;		/* file selection dialog */

/*
 *	xmpi_aschema_dialog
 *
 *	Function:	- pops up application selection dialog
 *	Accepts:	- parent widget
 */
void
xmpi_aschema_dialog(parent)

Widget			parent;

{
	Arg		args[2];
	XmString	oklabel;
	XmString	title;
	Widget		help_btn;

	if (appdialog == 0) {
		title = XmStringCreateSimple("XMPI Application Browser");
		oklabel = XmStringCreateSimple("Run");
		
		XtSetArg(args[0], XmNdialogTitle, title);
		XtSetArg(args[1], XmNokLabelString, oklabel);

		appdialog = XmCreateFileSelectionDialog(parent,
				"app_browser", args, 2);

		XtAddCallback(appdialog, XmNokCallback, runapp, NULL);
		XtAddCallback(appdialog, XmNcancelCallback,
				(XtCallbackProc) XtUnmanageChild, NULL);

		help_btn = XmFileSelectionBoxGetChild(appdialog,
				XmDIALOG_HELP_BUTTON);
		XtUnmanageChild(help_btn);

		XmStringFree(title);
		XmStringFree(oklabel);
	}
	else {
		XtMapWidget(xmpi_wmshell(appdialog));
		XmFileSelectionDoSearch(appdialog, 0);
	}

	XtManageChild(appdialog);
	XtPopup(XtParent(appdialog), XtGrabNone);
}

/*
 *	runapp
 *
 *	Function:	- run selected application (OK callback)
 *	Accepts:	- callback data
 */
static void
runapp(w, data, cbs)

Widget			w;
caddr_t			data;
XmFileSelectionBoxCallbackStruct
			*cbs;

{
	char		*appname;		/* app. file name */
	int		r;

	if (! XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &appname))
		return;

	XtUnmapWidget(xmpi_wmshell(w));

	r = xmpi_run(appname, xmpi_wmshell(w));

	if (r == 0) {
		xmpi_ctl_setapp(appname);
	}

	XtFree(appname);
}

/*
 *	xmpi_aschema_busy
 *
 *	Function:	- set the busy cursor in the schema browsing window
 */
void
xmpi_aschema_busy()

{
	if (appdialog) xmpi_busy_widget(appdialog);
}

/*
 *	xmpi_aschema_unbusy
 *
 *	Function:	- reset the busy cursor in the schema browsing window
 */
void
xmpi_aschema_unbusy()

{
	if (appdialog) xmpi_unbusy_widget(appdialog);
}
