/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: xmpi_about.c,v 1.4 1999/11/11 16:39:37 bbarrett Exp $
 * 
 *	Function:	- about XMPI
 */

#define _NO_PROTO

#include <Xm/MessageB.h>

#include "xmpi.h"

/*
 * public functions
 */
void 			xmpi_about();

/*
 * private functions
 */
static void 		ok_cb();

/*
 * external functions
 */
extern Widget		xmpi_wmshell();

/*
 * private data
 */
static char copyright[] =
    "\nCopyright (C) 1999, University of Notre Dame\n";

static char promotion[] =
    "\nFor more information see <http://www.mpi.nd.edu/lam/software/xmpi/>";

/*
 *	xmpi_about
 *
 *	Function:	- display about XMPI information
 *	Accepts:	- parent widget
 */
void
xmpi_about(parent)

Widget			parent;

{
	Widget		dialog;
	XmString	xstr;
	char		buf[1024];
	char		*version;
	
	strcpy(buf, "Version: XMPI " XMPI_VERSION);

 	version = xmpi_sys_version();
	if (version) {
		strcat(buf, " / ");
		strcat(buf, version);
	}
	strcat(buf, "\n");
	strcat(buf, copyright);
	strcat(buf, promotion);

	dialog = XmCreateInformationDialog(parent, "message", NULL, 0);

	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));

	xstr = XmStringCreateLtoR(buf, XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(dialog, XmNmessageString, xstr, NULL);
	XmStringFree(xstr);

	XtAddCallback(dialog, XmNokCallback, ok_cb, NULL);

	XtManageChild(dialog);
}

/*
 *	ok_cb
 *
 *	Function:	- about dialog OK callback
 *	Accepts:	- dialog widget
 */
static void
ok_cb(dialog)

Widget			dialog;

{
	XtDestroyWidget(dialog);
}
