(**
   Implements toolstips, known from windows.

  TODO
  * Share more code with VOWindow
**)

MODULE VOQuickHelp;

(*
    Implements tooltips.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)


IMPORT D   := VODisplay,
       E   := VOEvent,
       F   := VOFrame,
       O   := VOGUIObject,
       P   := VOPrefs;

TYPE
  Prefs*     = POINTER TO PrefsDesc;

  (**
    In this class all preferences stuff of the button is stored.
  **)

  PrefsDesc* = RECORD (P.PrefsDesc)
                 frame* : LONGINT; (* the frame to use for the button *)
               END;

  Help*         = POINTER TO HelpDesc;
  HelpDesc*     = RECORD (D.WindowDesc)
                    prefs     : Prefs;
                    top,
                    reference : O.Object;
                    refWin    : D.Window;
                    frame     : F.Frame;   (* frames menu *)
                  END;

VAR
  prefs* : Prefs;

  (**
    Initializes a tooltip with help as child which ooccurs
    directly beneth reference.

    You must explizitly assign the tooltip to the object you want to
    give help for. This is not done automatically by this function.
  **)

  PROCEDURE InitHelp*(d : D.Display; help,reference : O.Object):Help;

  VAR
    h : Help;

  BEGIN
    NEW(h);
    h.Init;

    h.Grab(TRUE);
    h.CreateAllways(TRUE);
    h.Borderless(TRUE);

    h.prefs:=prefs;

    h.top:=help;
    h.reference:=reference;

    NEW(h.frame);
    h.frame.Init;
    h.frame.SetFlags({O.horizontalFlex,O.verticalFlex});
    h.SetDisplay(d);

    RETURN h;
  END InitHelp;

  PROCEDURE (h : Help) CalcSize;

  BEGIN
    h.top.CalcSize(h.display);

    h.frame.SetInternalFrame(h.prefs.frame);
    h.frame.CalcSize(h.display);

    h.SetSize(h.frame.leftBorder+h.top.oWidth+h.frame.rightBorder+h.display.spaceWidth,
              h.frame.topBorder+h.top.oHeight+h.frame.bottomBorder+h.display.spaceHeight);

    h.frame.Resize(h.width,h.height);
  END CalcSize;

  PROCEDURE (h : Help) CursorIsIn():BOOLEAN;

  VAR
    rx,ry,
    wx,wy  : LONGINT;

  BEGIN
    h.GetMousePos(rx,ry,wx,wy);
    IF (wx>=0) & (wx<=h.width-1) & (wy>=0) & (wy<=h.height-1) THEN
      RETURN TRUE;
    ELSE
      RETURN FALSE;
    END;
  END CursorIsIn;

  PROCEDURE (h : Help) PreInit*;

  VAR
    rx,ry,
    wx,wy,
    x,y    : LONGINT;

  BEGIN
    h.CalcSize;

    h.display.currentWin.GetMousePos(rx,ry,wx,wy);
    h.refWin:=h.display.currentWin;
    x:=rx+2*h.display.spaceWidth;
    y:=ry+2*h.display.spaceHeight;

    x:=O.RoundRange(x,0,h.display.scrWidth-1-h.width);
    y:=O.RoundRange(y,0,h.display.scrHeight-1-h.height);

    h.SetPos(x,y);

    h.SetBackground(D.helpBackgroundColor);

    h.PreInit^;
  END PreInit;

  PROCEDURE (h : Help) Draw*;

  BEGIN
    h.frame.Draw(0,0,h.draw);
    h.top.SetBackground(D.helpBackgroundColor);
    h.top.Draw(h.frame.leftBorder+h.display.spaceWidth DIV 2,
               h.frame.topBorder+h.display.spaceHeight DIV 2,h.draw);
  END Draw;

  PROCEDURE(h : Help) Hide*;

  BEGIN
    h.top.Hide;
    h.frame.Hide;
  END Hide;

  PROCEDURE (h : Help) Left*;

  BEGIN
    h.Close;
  END Left;

  PROCEDURE (h : Help) Hidden*;

  BEGIN
    h.Close;
  END Hidden;

  PROCEDURE (h : Help) HandleEvent*(event : E.Event):BOOLEAN;

  BEGIN
    IF h.HandleEvent^(event) THEN
      RETURN TRUE;
    END;

    WITH
      event : E.MouseEvent DO
        h.Close;
        h.display.PutBackEvent(event,h.refWin);
    | event : E.MotionEvent DO
        h.Close;
    | event : E.KeyEvent DO
          h.Close;
          h.display.PutBackEvent(event,h.refWin);
    ELSE
    END;
    RETURN TRUE;
  END HandleEvent;

  PROCEDURE (p : Prefs) Init*;

  BEGIN
    p.frame:=F.single;
  END Init;

BEGIN
  NEW(prefs);
  prefs.Init;
END VOQuickHelp.