(*
    Generated parser for VisualOberon preferences.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

MODULE VOPrefsParser;

IMPORT
  VOPrefsScanner, U   := VOUtil,

       I   := IntStr,
       str := Strings,
       T   := TextRider;

CONST
  maxP = 9;
  maxT = 9;
  nrSets = 3    ;

  setSize = MAX(SET) + 1;
  nSets = (maxT DIV setSize) + 1;

TYPE
  SymbolSet = ARRAY nSets OF SET;

VAR
  sym:    INTEGER;   (* current input symbol *)
  symSet: ARRAY nrSets OF SymbolSet;

TYPE
  Item*      = POINTER TO ItemDesc;
  ItemDesc*  = RECORD
                 next*,last* : Item;

                 itemList*,
                 itemLast*   : Item;

                 name*       : U.Text;
               END;

  BlockItem*     = POINTER TO BlockItemDesc;
  BlockItemDesc* = RECORD (ItemDesc);
                   END;

  ValueItem*     = POINTER TO ValueItemDesc;
  ValueItemDesc* = RECORD (ItemDesc)
                     value* : U.Text;
                   END;

VAR
  top* : Item;

  PROCEDURE (i : Item) Init*;

  BEGIN
    i.next:=NIL;
    i.last:=NIL;

    i.itemList:=NIL;
    i.itemLast:=NIL;
  END Init;

  PROCEDURE (i : Item) AddItem*(item : Item);

  BEGIN
    IF i.itemList=NIL THEN
      i.itemList:=item;
    ELSE
      i.itemLast.next:=item;
      item.last:=i.itemLast;
    END;
    i.itemLast:=item;
  END AddItem;

  PROCEDURE (i : Item) GetEntry*(path : ARRAY OF CHAR):Item;

  VAR
    rest    : U.Text;
    pos,len : INTEGER;
    item    : Item;

    PROCEDURE FindSlash():INTEGER;

    VAR
      pos : INTEGER;

    BEGIN
      pos:=0;
      WHILE pos<LEN(path) DO
        IF path[pos]="/" THEN
          RETURN pos;
        END;
        INC(pos);
      END;
      RETURN -1;
    END FindSlash;

  BEGIN
    pos:=FindSlash();
    IF pos>0 THEN
      path[pos]:=0X;
      item:=i.itemList;
      WHILE item#NIL DO
        IF (item.name#NIL) & (item.name^=path) THEN
          path[pos]:="/";
          len:=str.Length(path)-pos;
          NEW(rest,len+1);
          str.Extract(path,pos+1,len,rest^);
          RETURN item.GetEntry(rest^);
        END;
        item:=item.next;
      END;
      RETURN NIL;
    ELSE
      item:=i.itemList;
      WHILE item#NIL DO
        IF (item.name#NIL) & (item.name^=path) THEN
          RETURN item;
        END;
        item:=item.next;
      END;
      RETURN NIL;
    END;
  END GetEntry;

  PROCEDURE (i : Item) GetStringEntry*(name : ARRAY OF CHAR; VAR text : ARRAY OF CHAR):BOOLEAN;

  VAR
    value : Item;

  BEGIN
    value:=i.GetEntry(name);
    IF (value#NIL) & (value IS ValueItem) & (value(ValueItem).value#NIL) THEN
      COPY(value(ValueItem).value^,text);
      RETURN TRUE;
    ELSE
      RETURN FALSE;
    END;
  END GetStringEntry;

  PROCEDURE (i : Item) GetIntEntry*(name : ARRAY OF CHAR; default : LONGINT):LONGINT;

  VAR
    value : Item;
    number : LONGINT;
    res    : I.ConvResults;

  BEGIN
    value:=i.GetEntry(name);
    IF (value#NIL) & (value IS ValueItem) & (value(ValueItem).value#NIL) THEN
      I.StrToInt(value(ValueItem).value^,number,res);
      IF res=I.strAllRight THEN
        RETURN number;
      END;
    END;
    RETURN default;
  END GetIntEntry;

  PROCEDURE (i : Item) GetBoolEntry*(name : ARRAY OF CHAR; default : BOOLEAN):BOOLEAN;

  VAR
    value : Item;

  BEGIN
    value:=i.GetEntry(name);
    IF (value#NIL) & (value IS ValueItem) & (value(ValueItem).value#NIL) THEN
      str.Capitalize(value(ValueItem).value^);
      RETURN value(ValueItem).value^="TRUE";
    ELSE
      RETURN default;
    END;
  END GetBoolEntry;

  PROCEDURE (i : Item) Print*(writer : T.Writer; indent : LONGINT);

  VAR
    help : Item;

  BEGIN
    help:=i.itemList;
    WHILE help#NIL DO
      help.Print(writer,indent);
      IF help.next#NIL THEN
        writer.WriteChar(";");
      END;
      writer.WriteLn;
      help:=help.next;
    END;
  END Print;

  PROCEDURE (v : BlockItem) SetName*(name : ARRAY OF CHAR);

  BEGIN
    NEW(v.name,str.Length(name)+1);
    COPY(name,v.name^);
  END SetName;

  PROCEDURE (b : BlockItem) Print*(writer : T.Writer; indent : LONGINT);

  VAR
    x : LONGINT;

  BEGIN
    FOR x:=1 TO indent DO
      writer.WriteChar(" ");
    END;
    writer.WriteString("BEGIN ");
    writer.WriteString(b.name^);
    writer.WriteLn;

    b.Print^(writer,indent+2);
    FOR x:=1 TO indent DO
      writer.WriteChar(" ");
    END;
    writer.WriteString("END");
  END Print;

  PROCEDURE (v : ValueItem) SetValue*(name,value : ARRAY OF CHAR);

  BEGIN
    NEW(v.name,str.Length(name)+1);
    COPY(name,v.name^);
    NEW(v.value,str.Length(value)+1);
    COPY(value,v.value^);
  END SetValue;

  PROCEDURE (v : ValueItem) SetBool*(name : ARRAY OF CHAR; value : BOOLEAN);

  BEGIN
    IF value THEN
      v.SetValue(name,"TRUE");
    ELSE
      v.SetValue(name,"FALSE");
    END;
  END SetBool;

  PROCEDURE (v : ValueItem) SetInt*(name : ARRAY OF CHAR; value : LONGINT);

  VAR
    string : ARRAY 12 OF CHAR;

  BEGIN
    I.IntToStr(value,string);
    v.SetValue(name,string);
  END SetInt;

  PROCEDURE (v : ValueItem) Print*(writer : T.Writer; indent : LONGINT);

  VAR
    x : LONGINT;

  BEGIN
    FOR x:=1 TO indent DO
      writer.WriteChar(" ");
    END;

    writer.WriteString(v.name^);
    writer.WriteString(":=");
    writer.WriteChar('"');
    writer.WriteString(v.value^);
    writer.WriteChar('"');
  END Print;




  PROCEDURE Initialize*(item : Item);

  BEGIN
    IF item=NIL THEN
      NEW(top);
      top.Init;
    ELSE
      top:=item;
    END;
  END Initialize;




(* ==================================================================== *)

PROCEDURE Error (n: INTEGER);
BEGIN
  VOPrefsScanner.Error(n, VOPrefsScanner.nextPos)
END Error;

PROCEDURE Get ();
BEGIN
  VOPrefsScanner.Get(sym)
END Get;

PROCEDURE Expect (n: INTEGER);
BEGIN
  IF sym = n THEN Get(); ELSE Error(n); END;
END Expect;

PROCEDURE StartOf (s: INTEGER): BOOLEAN;
BEGIN
  RETURN (sym MOD setSize) IN symSet[s, sym DIV setSize];
END StartOf;

PROCEDURE ExpectWeak(n, follow: INTEGER);
BEGIN
  IF sym = n THEN
    Get ();
  ELSE
    Error (n);
    WHILE ~StartOf (follow) DO Get(); END;
  END;
END ExpectWeak;

PROCEDURE WeakSeparator (n, syFol, repFol: INTEGER): BOOLEAN;
VAR
  s: SymbolSet; i: INTEGER;
BEGIN
  IF sym = n THEN
    Get ();
    RETURN TRUE;
  ELSIF StartOf (repFol) THEN
    RETURN FALSE;
  ELSE
    FOR i := 0 TO nSets-1 DO
      s[i] := symSet[syFol, i] + symSet[repFol, i] + symSet[0, i];
    END;
    Error (n);
    WHILE ~((sym MOD setSize) IN s[sym DIV setSize]) DO Get(); END;
    RETURN StartOf (syFol);
  END;
END WeakSeparator;

PROCEDURE ^Number(VAR value : ValueItem);
PROCEDURE ^String(VAR value : ValueItem);
PROCEDURE ^Parameter(VAR item : Item);
PROCEDURE ^Entry(block : BlockItem);
PROCEDURE ^Ident(VAR text : U.Text);
PROCEDURE ^Block(VAR block : BlockItem);
PROCEDURE ^VOPrefs;

PROCEDURE Number(VAR value : ValueItem);
BEGIN
  value:=NIL;
  NEW(value);
  value.Init
    ;
  Expect(3);
  NEW(value.value,VOPrefsScanner.len+1);
  VOPrefsScanner.GetName(VOPrefsScanner.pos,VOPrefsScanner.len,value.value^);
    ;
END Number;

PROCEDURE String(VAR value : ValueItem);
BEGIN
  value:=NIL;
  NEW(value);
  value.Init
    ;
  Expect(2);
  NEW(value.value,VOPrefsScanner.len-1);
  VOPrefsScanner.GetName(VOPrefsScanner.pos+1,VOPrefsScanner.len-2,value.value^);
    ;
END String;

PROCEDURE Parameter(VAR item : Item);
  VAR block : BlockItem; value : ValueItem; text : U.Text;
BEGIN
  item:=NIL; value:=NIL; block:=NIL; text:=NIL ;
  IF (sym = 2) THEN
    WHILE ~( (sym = 0) OR (sym = 2)) DO Error(10); Get END;
    String(value);
    IF value#NIL THEN
      item:=value
    END
      ;
  ELSIF (sym = 3) THEN
    WHILE ~( (sym = 0) OR (sym = 3)) DO Error(11); Get END;
    Number(value);
    IF value#NIL THEN
      item:=value
    END
      ;
  ELSIF (sym = 1) THEN
    Ident(text);
    IF text#NIL THEN
      NEW(value);
      value.Init;
      value.value:=text;
      item:=value
    END
      ;
  ELSIF (sym = 4) THEN
    Block(block);
    IF block#NIL THEN
      item:=block
    END
      ;
  ELSE Error(12)
  END;
END Parameter;

PROCEDURE Entry(block : BlockItem);
  VAR help : Item; text : U.Text; subBlock : BlockItem;
BEGIN
  IF (sym = 1) THEN
    text:=NIL;
      ;
    Ident(text);
    Expect(7);
    help:=NIL ;
    Parameter(help);
    IF help#NIL THEN
      help.name:=text;
      block.AddItem(help);
    END
      ;
    WHILE (sym = 8) DO
      Get;
      help:=NIL ;
      Parameter(help);
      IF help#NIL THEN
        block.AddItem(help);
      END
        ;
    END;
  ELSIF (sym = 4) THEN
    subBlock:=NIL ;
    Block(subBlock);
    IF subBlock#NIL THEN
      block.AddItem(subBlock);
    END;
      ;
  ELSE Error(13)
  END;
END Entry;

PROCEDURE Ident(VAR text : U.Text);
BEGIN
  text:=NIL ;
  Expect(1);
  NEW(text,VOPrefsScanner.len+1);
  VOPrefsScanner.GetName(VOPrefsScanner.pos,VOPrefsScanner.len,text^);
    ;
END Ident;

PROCEDURE Block(VAR block : BlockItem);
  VAR entry : Item;
BEGIN
  NEW(block);
  block.Init
    ;
  WHILE ~( (sym = 0) OR (sym = 4)) DO Error(14); Get END;
  Expect(4);
  Ident(block.name);
  entry:=NIL ;
  IF (sym = 1) OR (sym = 4) THEN
    Entry(block);
    WHILE WeakSeparator(5, 1, 2)  DO
      IF (sym = 1) OR (sym = 4) THEN
        Entry(block);
      END;
    END;
  END;
  WHILE ~( (sym = 0) OR (sym = 6)) DO Error(15); Get END;
  Expect(6);
END Block;

PROCEDURE VOPrefs;
  VAR block : BlockItem;
BEGIN
  NEW(top.name,str.Length("TOP")+1);
  COPY("TOP",top.name^);
    ;
  WHILE (sym = 4) DO
    block:=NIL ;
    Block(block);
    IF block#NIL THEN
      top.AddItem(block);
    END
      ;
  END;
  Expect(0);
END VOPrefs;



PROCEDURE Parse*;
BEGIN
  Get ();
  VOPrefs;

END Parse;

BEGIN
  symSet[0, 0] := {0,2,3,4,6};
  symSet[1, 0] := {1,4,5,6};
  symSet[2, 0] := {6};

END VOPrefsParser.
