(**
  A dialog to select one of the internal images.
**)

MODULE VOImgSelDlg;

(*
    A dialog to select one of the internal images.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT A  := VOArray,
       B  := VOButton,
       BR := VOButtonRow,
       G  := VOGUIObject,
       KH := VOKeyHandler,
       L  := VOLabel,
       O  := VOObject,
       P  := VOPanel,
       PL := VOPlate,
       Q  := VOQuickHelp,
       S  := VOSpace,
       T  := VOText,
       V  := VOVecImage,
       W  := VOWindow,
       WG := VOWindowGroup;

CONST
  setMsg * = 0;

  okId     = 100;
  cancelId = 101;

TYPE
  ImgSelDlg*     = POINTER TO ImgSelDlgDesc;
  ImgSelDlgDesc* = RECORD (W.WindowDesc)
                     image-   : LONGINT;
                     tmpImage : LONGINT;
                     current  : V.VecImage;
                     selImage : V.VecImage;
                   END;

  SetMsg*        = POINTER TO SetMsgDesc;
  SetMsgDesc*    = RECORD (O.MessageDesc)
                     image* : LONGINT;
                   END;


  PROCEDURE (d : ImgSelDlg) Init*;

  VAR
    keyHandler : KH.KeyHandler;

  BEGIN
    d.Init^;

    d.image:=V.checkmark;
    d.current:=NIL;

    NEW(keyHandler);
    keyHandler.Init;
    d.AddKeyHandler(keyHandler);

    d.SetModal;
    d.SetTitle("Image select dialog");
  END Init;

  PROCEDURE (d : ImgSelDlg) PreInit*;

  VAR
    panel   : P.Panel;
    array   : A.Array;
    button  : B.Button;
    row     : BR.ButtonRow;
    image   : V.VecImage;
    plate   : PL.Plate;
    space   : S.Space;
    label   : L.Label;
    wGroup  : WG.WindowGroup;
    i       : LONGINT;

  BEGIN
    d.tmpImage:=d.image;

    NEW(panel);
    panel.Init;
    panel.Set(P.vertical);

      NEW(array);
      array.Init;
      array.SetFlags({G.horizontalFlex});
      array.Set(5,TRUE);
      array.SetSpace(TRUE,TRUE);

      FOR i:=0 TO V.imageCount-1 DO
        NEW(button);
        button.Init;

          NEW(plate);
          plate.Init;
            NEW(image);
            image.Init;
            image.SetFlags({G.horizontalFlex,G.verticalFlex});
            image.SetMinWidth(G.sizeFontRel,3);
            image.SetMinHeight(G.sizeFontRel,3);
            image.Set(i);
          plate.Add(image);

        button.SetImage(plate);
        button.SetHelpObject(Q.InitHelp(d.display,T.MakeLeftText(V.images[i]),button));
        d.keyHandler.AddFocusObject(button);
        button.SetId(i);
        button.Forward(B.pressedMsg,d);

        array.Add(button);
      END;
    panel.Add(array);

      NEW(space);
      space.Init;
      space.Set(TRUE,S.normal);
    panel.Add(space);

      NEW(label);
      label.Init;
        NEW(plate);
        plate.Init;
          NEW(image);
          image.Init;
          image.SetMinWidth(G.sizeFontRel,3);
          image.SetMinHeight(G.sizeFontRel,3);
          image.Set(d.image);
          d.current:=image;
        plate.Add(image);
      label.AddTextLabel("Current value:",plate);
    panel.Add(label);


      NEW(space);
      space.Init;
      space.Set(TRUE,S.normal);
    panel.Add(space);

      NEW(row);
      row.Init;
      row.SetFlags({G.horizontalFlex});

        NEW(button);
        button.Init;
        button.SetFlags({G.horizontalFlex,G.verticalFlex});
        button.SetLabelText("_Ok*",d.keyHandler);
        button.SetId(okId);
        button.Forward(B.pressedMsg,d);
        d.keyHandler.AddFocusObject(button);
      row.Add(button);

        NEW(button);
        button.Init;
        button.SetFlags({G.horizontalFlex,G.verticalFlex});
        button.SetLabelText("_Cancel^",d.keyHandler);
        button.SetId(cancelId);
        button.Forward(B.pressedMsg,d);
        d.keyHandler.AddFocusObject(button);
      row.Add(button);
    panel.Add(row);

    NEW(wGroup);
    wGroup.Init;
    wGroup.Set(NIL,panel,TRUE);

    d.SetTop(wGroup);

    d.Forward(W.closeMsg,d);

    d.PreInit^;
  END PreInit;

  PROCEDURE (d : ImgSelDlg) Receive*(message : O.Message);

  VAR
    set : SetMsg;

  BEGIN
    WITH
      message : B.PressedMsg DO
        CASE message.source.id OF
          okId:
            d.image:=d.tmpImage;
            d.Close;
            NEW(set);
            set.image:=d.image;
            d.Send(set,setMsg);
        | cancelId:
            d.Close;
        ELSE
          d.tmpImage:=message.source.id;
          d.current.Set(d.tmpImage);
        END;
    | message : W.CloseMsg DO
        d.Delete;
    ELSE
      d.Receive^(message);
    END;
  END Receive;

  PROCEDURE (d : ImgSelDlg) SetImage*(image : LONGINT);

  BEGIN
    d.image:=image;
    IF d.current#NIL THEN
      d.current.Set(d.image);
    END;
  END SetImage;

END VOImgSelDlg.