MODULE VOFuelGaugePrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOButton,
       F   := VOFrame,
       FR  := VOFrameGroup,
       FG  := VOFuelGauge,
       FSD := VOFrmSelDlg,
       G   := VOGUIObject,
       O   := VOObject,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (PG.PrefsItemDesc)
                prefs      : FG.PrefsDesc;
                frmSelDlg  : FSD.FrmSelDlg;
                frame      : F.Frame;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Fuelgauge";
    PG.settings.AddItem(d);

    NEW(d.frmSelDlg);
    d.frmSelDlg.Init;
  END Init;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.prefs:=FG.prefs^;

    d.frame.SetInternalFrame(d.prefs.frame);
    d.frmSelDlg.SetFrame(d.prefs.frame);
  END Refresh;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    button    : B.Button;
    frame     : FR.FrameGroup;

  BEGIN
    d.frmSelDlg.SetDisplay(d.display);
    d.frmSelDlg.Forward(FSD.setMsg,d);

    NEW(frame);
    frame.Init;
    frame.SetTextLabel("Frame");

      button:=PG.CreateFrameButton(d.prefs.frame,d.frame,d.display,d.frmSelDlg,
                                   d.window.keyHandler,"Select frame");
    frame.Add(button);

    RETURN frame;
  END GetObject;

  PROCEDURE (p : Item) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    buffer   : ARRAY 256 OF CHAR;
    pos      : LONGINT;
    top      : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    top:=p.LoadPrefsFile("FuelGauge",appName);

    IF top#NIL THEN
      IF top.GetStringEntry("FUELGAUGE/frame",buffer) THEN
        pos:=F.GetFrameEntry(buffer);
        IF pos>=0 THEN
          FG.prefs.frame:=pos;
        ELSE
          p.ErrorWrongData("FUELGAUGE/frame",buffer);
        END;
      END;
    END;
  END LoadPrefs;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    FG.prefs^:=p.prefs;
  END Apply;

  PROCEDURE (p : Item) Save*;

  VAR
    block    : PP.BlockItem;
    value    : PP.ValueItem;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("FUELGAUGE");
      NEW(value);
      value.Init;
      value.SetValue("frame",F.internalFrames[p.prefs.frame]);
    block.AddItem(value);

    p.SaveItems("FuelGauge",block);
  END Save;

  PROCEDURE (p : Item) Receive*(message : O.Message);

  BEGIN
    WITH
      message : FSD.SetMsg DO
        p.frame.SetInternalFrame(message.frame);
        p.prefs.frame:=message.frame;
    ELSE
      p.Receive^(message);
    END;
  END Receive;

BEGIN
  NEW(prefs);
  prefs.Init;

END VOFuelGaugePrefs.