MODULE VOButtonRowPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT BG  := VOBackground,
       BR  := VOButtonRow,
       F   := VOFrameGroup,
       G   := VOGUIObject,
       L   := VOLabel,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser,
       R   := VORadio,
       V   := VOValue;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (PG.PrefsItemDesc)
                prefs : BR.PrefsDesc;
                model : V.IntModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Buttonrow";

    NEW(d.model);
    d.model.Init;

    PG.settings.AddItem(d);
  END Init;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.prefs:=BR.prefs^;

    d.model.SetLongint(d.prefs.alignment);
  END Refresh;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    frame : F.FrameGroup;
    label : L.Label;
    radio : R.Radio;

  BEGIN
    NEW(frame);
    frame.Init;
    frame.SetTextLabel("Button alignment");

      NEW(label);
      label.Init;
      label.Set(TRUE);

        NEW(radio);
        radio.Init;
        radio.SetModel(d.model,G.alignLeft);
        d.window.keyHandler.AddFocusObject(radio);
        label.AddTextLabel("left",radio);

        NEW(radio);
        radio.Init;
        radio.SetModel(d.model,G.alignCenter);
        d.window.keyHandler.AddFocusObject(radio);
      label.AddTextLabel("center",radio);

        NEW(radio);
        radio.Init;
        radio.SetModel(d.model,G.alignRight);
        d.window.keyHandler.AddFocusObject(radio);
      label.AddTextLabel("right",radio);

        NEW(radio);
        radio.Init;
        radio.SetModel(d.model,G.alignBound);
        d.window.keyHandler.AddFocusObject(radio);
      label.AddTextLabel("bound",radio);

    frame.Add(label);

    RETURN frame;
  END GetObject;

  PROCEDURE (p : Item) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    buffer   : ARRAY 256 OF CHAR;
    pos      : LONGINT;
    top      : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    top:=p.LoadPrefsFile("ButtonRow",appName);
    IF top=NIL THEN
      RETURN;
    END;
    top:=top.GetEntry("BUTTONROW");
    IF top=NIL THEN
      RETURN;
    END;

    IF top.GetStringEntry("alignment",buffer) THEN
      pos:=G.GetAlignment(buffer);
      IF pos>=0 THEN
        BR.prefs.alignment:=pos;
      ELSE
        p.ErrorWrongData("alignment",buffer);
      END;
    END;

    BR.prefs.background:=BG.LoadBackground(top);
  END LoadPrefs;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.prefs.alignment:=p.model.GetLongint();
    BR.prefs^:=p.prefs;
  END Apply;

  PROCEDURE (p : Item) Save*;

  VAR
    block    : PP.BlockItem;
    value    : PP.ValueItem;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("BUTTONROW");
      NEW(value);
      value.Init;
      value.SetValue("alignment",G.alignments[p.prefs.alignment]);
    block.AddItem(value);

    BG.SaveBackground(block,p.prefs.background);

    p.SaveItems("ButtonRow",block);
  END Save;

BEGIN
  NEW(prefs);
  prefs.Init;

END VOButtonRowPrefs.