MODULE TextView;

(*
    A simple textviewer as demo for the textview gadget of
    VisualOberon.

    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D  := VODisplay,
       G  := VOGUIObject,
       K  := VOKeyHandler,
       O  := VOObject,
       P  := VOPanel,
       S  := VOString,
       SC := VOScroller,
       SP := VOSpace,
       TM := VOTextViewModel,
       TV := VOTextView,
             VOUsePrefs,
       U  := VOUtil,
       V  := VOValue,
       W  := VOWindow,

             Err,
       F  := Files,
             Out;

TYPE
  Display     = POINTER TO DisplayDesc;
  DisplayDesc = RECORD (D.DisplayDesc)
                  stringModel : V.StringModel;
                END;

VAR
  d           : Display;
  w           : W.Window;
  keyHandler  : K.KeyHandler;
  msg2Exit    : D.Msg2Exit;

  top,
  panel       : P.Panel;
  scroller    : SC.Scroller;
  space       : SP.Space;
  string      : S.String;
  textModel   : TM.ListTextModel;
  textView    : TV.TextView;
  text        : ARRAY 256 OF CHAR;


  PROCEDURE LoadFile(name : ARRAY OF CHAR);

  VAR
    file : F.File;
    res  : F.Result;

  BEGIN
    file:=F.Old(name,{F.read},res);
    IF file#NIL THEN
      IF ~textModel.LoadFromChannel(file) THEN
        res.GetText(text);
        Out.String("Error: "); Out.String(text); Out.Ln;
      END;
      file.Close;
    ELSE
      res.GetText(text);
      Out.String("Error: "); Out.String(text); Out.Ln;
    END;
  END LoadFile;

  PROCEDURE (d : Display)  Receive*(message : O.Message);

  VAR
    text : U.Text;

  BEGIN
    WITH message : S.EnteredMsg DO
      text:=d.stringModel.GetText();
      LoadFile(text^);
    ELSE
      d.Receive^(message);
    END;
  END Receive;


BEGIN
  NEW(d);
  IF ~d.InitDisplay("TextView") THEN
    Err.String("Cannot init application!"); Err.Ln;
    HALT(1);
  END;

  NEW(keyHandler);
  keyHandler.Init;

  NEW(top);
  top.Init;
  top.Set(P.vertical);
  top.SetFlags({G.horizontalFlex,G.verticalFlex});

    NEW(d.stringModel);
    d.stringModel.Init;
    d.stringModel.SetString("./");

    NEW(string);
    string.Init;
    string.SetFlags({G.horizontalFlex});
    keyHandler.AddFocusObject(string);
    string.Forward(S.enteredMsg,d);
(*    string.help:=Q.InitHelp(d,MakeListText("Enter filename of\ntextfile to display."),string);*)
    string.SetModel(d.stringModel);
  top.Add(string);

    NEW(space);
    space.Init;
    space.Set(TRUE,SP.normal);
  top.Add(space);

    NEW(panel);
    panel.Init;
    panel.Set(P.horizontal);
    panel.SetFlags({G.horizontalFlex,G.verticalFlex});

      NEW(textModel);
      textModel.Init;

      NEW(textView);
      textView.Init;
      textView.SetFlags({G.horizontalFlex,G.verticalFlex});
      textView.SetWidth(G.sizeFontRel,90);
      textView.SetHeight(G.sizeScreenRel,80);
      textView.SetModel(textModel);
   panel.Add(textView);

      NEW(scroller);
      scroller.Init;
      scroller.SetFlags({G.verticalFlex});
      scroller.SetModel(textView.topPos,textView.vis,textView.total);
   panel.Add(scroller);

  top.Add(panel);

  NEW(w);
  w.Init;
  w.SetDisplay(d);
  w.SetTop(top);
  w.SetTitle("Textview");
  w.AddKeyHandler(keyHandler);

  NEW(msg2Exit);
  msg2Exit.destination:=d;
  w.AddHandler(msg2Exit,W.closeMsg);

  w.Open;
(*  LoadFile("./TextView.Mod");*)
  d.Handler;

END TextView.
