
MODULE StringTest;

IMPORT        VOString,
              VOPanel,
       D   := VODisplay,
       G   := VOGUIObject,
              VOUsePrefs,
       W   := VOWindow,
       K   := VOKeyHandler,
       V   := VOValue,

              Err,
       L   := Locales;

VAR
  keyHandler : K.KeyHandler;
  d          : D.Display;
  w          : W.Window;
  string,
  c,
  r          : VOString.String;
  sm         : V.StringModel;
  msg2Exit   : D.Msg2Exit;
  panel      : VOPanel.Panel;

  old        : ARRAY 32 OF CHAR;


BEGIN
  NEW(d);
  IF ~d.InitDisplay("StringTest") THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  NEW(keyHandler);
  keyHandler.Init;

  L.Set(L.ALL,"",old);  (* use env variables *)

  NEW(panel);
  panel.Init();

  NEW(sm);
  sm.Init();
  sm.SetString("It's cool, hu hu huh!");

  NEW(string);
  string.Init();
  string.SetFlags({G.horizontalFlex});
  string.SetStringWidth(120, 80);
  string.SetStringAlignment(VOString.leftAligned);
  string.SetModel(sm);
  keyHandler.AddFocusObject(string);
  panel.Add(string);

  NEW(c);
  c.Init();
  c.SetFlags({G.horizontalFlex});
  c.SetStringWidth(120, 80);
  c.SetStringAlignment(VOString.centerAligned);
  c.SetModel(sm);
  keyHandler.AddFocusObject(c);
  panel.Add(c);

  NEW(r);
  r.Init();
  r.SetFlags({G.horizontalFlex});
  r.SetStringWidth(120, 80);
  r.SetStringAlignment(VOString.rightAligned);
  r.SetModel(sm);
  keyHandler.AddFocusObject(r);
  panel.Add(r);

  NEW(w);
  w.Init;
  w.SetDisplay(d);
  w.SetTop(panel);
  w.SetTitle("StringTest");
  NEW(msg2Exit);
  msg2Exit.destination:=d;
  w.AddHandler(msg2Exit,W.closeMsg);
  w.AddKeyHandler(keyHandler);
  w.Open;

  d.Handler;

  d.Deinit;
END StringTest.
