/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <vdkb/vdkb_object.h>
#include <vdk/vdkutils.h>
#include <vdk/widcontain.h>
#include <vdkb/vdkb_types.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_evcontain.h>
#include <vdkb/vdkb_objinspect.h>
#include <vdkb/vdkb_form.h>
#include <vdkb/vdkb_prjman.h>
#include <vdkb/vdkb_fixed.h>
#include <vdkb/vdkb_scrolled.h>
#include <stdlib.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdkx.h>
#include <vdkb/vdkb_notebook.h>
#include <vdkb/vdkb_frame.h>
static char buff[256];
#define VERBOSE 0

/* The cursors used when selecting/adding/moving/resizing widgets */
/*
static GdkCursor *cursor_selector = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
static GdkCursor *cursor_add_widget = gdk_cursor_new (GDK_PLUS);
static GdkCursor *cursor_add_to_fixed = gdk_cursor_new (GDK_TCROSS);
static GdkCursor *cursor_move = gdk_cursor_new (GDK_FLEUR);
static GdkCursor *cursor_top_left = gdk_cursor_new (GDK_TOP_LEFT_CORNER);
static GdkCursor *cursor_top_right = gdk_cursor_new (GDK_TOP_RIGHT_CORNER);
static GdkCursor *cursor_bottom_left = gdk_cursor_new (GDK_BOTTOM_LEFT_CORNER);
static GdkCursor *cursor_bottom_right = gdk_cursor_new (GDK_BOTTOM_RIGHT_CORNER);
*/
/*
 */
char* vdkbclass_names[] =
{
  "form",
  "gnomeform",
  0
};
/*
 */
// VDKBCLASSES_OFFSET is 1024
int
ClassTypeLookup(char* word)
{
int t=0;
for(;vdkbclass_names[t];t++)
  if(!strcmp(word,vdkbclass_names[t]))
     return VDKB_GUI_CLASSES_OFFSET+t;
return -1;
}
/*
 */
char* vdkobj_props[] =
{
NORMALBACKGROUND,PRELIGHTBACKGROUND,
INSENSITIVEBACKGROUND,ACTIVEBACKGROUND,
SELECTEDBACKGROUND,FOREGROUND,
FONT,ENABLED,
CURSOR,USIZE,VISIBLE,
JUSTIFY_INTERNAL, EXPAND_INTERNAL,
FILL_INTERNAL,PADDING_INTERNAL,
TIP,TAG,LABEL,TABLEROW,TABLECOL,
0
};

char* vdkobj_signals[] = { SIGNAL_REALIZE,0 };
char* vdkobj_nicknames[] = { NICK_REALIZE,0 };

//////////////////////////////////////////////
VDKBObject::VDKBObject(char* name):name(name)
{
  int t;
  for(t=0;vdkobj_props[t];t++)
    proplist.add(VDKBProperty(vdkobj_props[t]));
  for(t=0; vdkobj_signals[t]; t++)
    siglist.add(VDKBSignal(vdkobj_signals[t],
			   this,
			   vdkobj_nicknames[t]));
  // set adding  props to default value
  SetPropValue(VISIBLE,CHECK_TRUE);
  SetPropValue(ENABLED,CHECK_TRUE);
  SetPropValue(JUSTIFY_INTERNAL,"0"); // l_justify or side in packer or x in fixed
  SetPropValue(EXPAND_INTERNAL,"1"); // or anchor in packer or y in fixed
  SetPropValue(FILL_INTERNAL,"1"); // or options in packer
  SetPropValue(PADDING_INTERNAL,"0"); // or border width in packer
  object = NULL;
}

/*
 */
VDKBObject::~VDKBObject()
{
}
/*
 */

VDKString VDKBObject::nihil_property = NIHIL_PROP;

void
VDKBObject::SetPropValue(char* prop, char* value)
{
  VDKBProperty  p(prop);
  VDKBProperty* pp;
  if( (pp = proplist.find(p)))
    pp->Value(value);
}

/*
 */
VDKString&
VDKBObject::GetProp(char* prop)
{
  VDKBProperty  p(prop);
  VDKBProperty* pp;
  //VDKString value = NIHIL_PROP;
  if( (pp = proplist.find(p)))
    //value = pp->Value();
    //return value;
    return pp->Property();
  else
    return VDKBObject::nihil_property;
}


/*
widget selection stuff,
shameless stolen to
Damon Chaplin, glade author
*/
// into vdkb_widsel.c
extern "C"
{
  extern void
  paint_selection (GdkWindow * window, GdkGC * gc, gint x, gint y,
		   gint width, gint height);
  extern void
  clear_widget_selection (GtkWidget * widget);

  extern GdkWindow*
  get_widget_window (GtkWidget *parent, GtkWidget *widget);
}

/*
 */
void
  VDKBObject::ClearMark()
{
#if VERBOSE
  printf("\nVDKBObject::ClearMark()");
  fflush(stdout);
#endif
  clear_widget_selection (object->Widget());
}

/*
 */
void
VDKBObject::Mark()
{
if(object && GTK_WIDGET_DRAWABLE(object->Widget()))
  {
    GdkWindow *window;
    GdkGC *gc;
    gint x, y, w, h;
    GtkWidget* widget,  *ancestor;
    widget = ancestor = object->Widget();
    gc =  widget->style->black_gc;
    gdk_gc_set_subwindow (gc, GDK_INCLUDE_INFERIORS);
    window = get_widget_window (ancestor->parent, ancestor);
    if (window && ancestor->parent)
      {
	x = ancestor->allocation.x;
	y = ancestor->allocation.y;
	w = ancestor->allocation.width;
	h = ancestor->allocation.height;
      }
    else
      {
	x = 0;
	y = 0;
	gdk_window_get_size (window, &w, &h);
      }
    paint_selection (window, gc, x, y, w, h);
    /* Reset gc - maybe we should remember the current setting */
    gdk_gc_set_subwindow (gc, GDK_CLIP_BY_CHILDREN);
  }
}

/*
===========================================================
 */
/*

 */
void
VDKBObject::WriteBgProp(char* propname, GtkStateType state, FILE* fp)
{
  VDKString nihilProp = NIHIL_PROP;
  VDKString prop = GetProp(propname);
  /*
  char color[32];	
  if( prop == nihilProp)	
  {	
  VDKRgb rgb = object->GetBackground(state);
  if(rgb.red > 0)
  {
  sprintf(color,"%d,%d,%d",rgb.red,rgb.green,rgb.blue);
  fprintf(fp,"\n\t%s:%s;",propname,color);
  }
  else
  fprintf(fp,"\n\t%s:%s;",propname,(char*) nihilProp);
  }
  else
  */
  fprintf(fp,"\n\t%s:%s;",propname,(char*) prop);

}
/*
 */
void
VDKBObject::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  char* oname = (char*) Name();


  fprintf(fp,"\n[object]\n{\n\tthis:%s;\n\tclass:%s;",
	  oname,(char*) VDKName());
  fprintf(fp,"\n\tparent:%s;",
	  parentobj ? (char*) parentobj->Name(): NIHIL_PROP);
  if(!object)
    return;
  // jump these props for containers
  else if(!dynamic_cast<VDKBEventContainer*>(this))
    {
      VDKString prop;
      VDKString nihilProp = NIHIL_PROP;
      VDKRgb rgb;
      WriteBgProp(NORMALBACKGROUND,GTK_STATE_NORMAL,fp);
      WriteBgProp(PRELIGHTBACKGROUND,GTK_STATE_PRELIGHT,fp);
      WriteBgProp(INSENSITIVEBACKGROUND,GTK_STATE_INSENSITIVE,fp);
      WriteBgProp(ACTIVEBACKGROUND,GTK_STATE_ACTIVE,fp);
      WriteBgProp(SELECTEDBACKGROUND,GTK_STATE_ACTIVE,fp);
      fprintf(fp,"\n\t%s%s;",
	      PROP_FOREGROUND,
	      (char*) GetProp(FOREGROUND));
      fprintf(fp,"\n\t%s%s;",
	       PROP_FONT,
	      (char*) GetProp( FONT));
      fprintf(fp,"\n\t%s%s;",
	      PROP_ENABLED,
	      (char*) GetProp(ENABLED));
      fprintf(fp,"\n\t%s%s;",
	      PROP_CURSOR,
	      (char*) GetProp(CURSOR));
      fprintf(fp,"\n\t%s%s;",
	      PROP_VISIBLE,
	      (char*) GetProp(VISIBLE));
      fprintf(fp,"\n\tTip:\"%s\";",
	      (char*) GetProp("Tip"));
    }
  WriteCommonOnFrm(fp, parentobj);
 }
/*
 */
void
VDKBObject::WriteCommonOnFrm(FILE* fp, VDKBObject* parentobj)
{
  VDKString Nihil = NIHIL_PROP;
  // these are common to all widgets
  fprintf(fp,"\n\t%s%s;",
	  PROP_JUSTIFY_INTERNAL,
	  (char*) GetProp(JUSTIFY_INTERNAL));
  fprintf(fp,"\n\t%s%s;",
	  PROP_EXPAND_INTERNAL,
	  (char*) GetProp( EXPAND_INTERNAL));
  fprintf(fp,"\n\t%s%s;",
	  PROP_FILL_INTERNAL,
	  (char*) GetProp(FILL_INTERNAL));
  fprintf(fp,"\n\t%s%s;",
	  PROP_PADDING_INTERNAL,
	  (char*) GetProp(PADDING_INTERNAL));
  fprintf(fp,"\n\t%s%s;",
	  PROP_TAG,
	  (char*) GetProp(TAG));


  //
#if VERBOSE
  printf("\nwriting common properties of:%s", (char*) Name());
  fflush(stdout);
#endif
   if(GetProp("TableRow") != Nihil)
        fprintf(fp,"\n\tTableRow:%s;",(char*) GetProp("TableRow"));
   if(GetProp("TableCol") != Nihil)
        fprintf(fp,"\n\tTableCol:%s;",(char*) GetProp("TableCol"));
  // does not write size for scrolled window
  // and scrolled window childs.
  // with fixed exception
  //  bool isScrolled = GTK_IS_SCROLLED_WINDOW(ObjectFromVDK()->Widget());
  bool isScrolled = dynamic_cast<VDKBScrolled*>(this);
  bool isParentFixed = parentobj && dynamic_cast<VDKBFixed*>(parentobj);
  if( isScrolled && !isParentFixed)
    {
#if VERBOSE
  printf("\n%s: - size not stored", (char*) Name());
  fflush(stdout);
#endif
  fprintf(fp,"\n\t%s%s;", PROP_USIZE,NIHIL_PROP);
  return;
    }
  if(parentobj)
    {
      VDKObject* p;
      for (p = parentobj->ObjectFromVDK(); p ; p = p->Parent())
	{
	  bool isFixed = dynamic_cast<VDKBFixed*>(p);
	  if(isFixed)
	    break;
	  //	  else if(GTK_IS_SCROLLED_WINDOW(p->Widget()))
	  else if(dynamic_cast<VDKBScrolled*>(p))
	    {
#if VERBOSE
	      printf("\nparent of:%s is a scrolled - size not stored", (char*) Name());
	      fflush(stdout);
#endif
	      fprintf(fp,"\n\t%s%s;",
		      PROP_USIZE,NIHIL_PROP);
	      return;
	    }
	}
    }
   fprintf(fp,"\n\t%s%s;",  PROP_USIZE, (char*) GetProp( USIZE));

}
/*
 */
void
VDKBObject::CreateWidget(VDKBObject* gui_object,
			 char* buffer,VDKBParser& parser)
{
  char arg[128];
  VDKRgb color;
  if(! gui_object->ObjectFromVDK())
    return;
  color = parser.Color(buffer,PROP_NORMALBACKGROUND);
  if(color.red >= 0)
    {
      if( parser.GetParam(arg,buffer,PROP_NORMALBACKGROUND))
	gui_object->SetPropValue(NORMALBACKGROUND,arg);
	gui_object->ObjectFromVDK()->NormalBackground = color;
    }
  color = parser.Color(buffer,PROP_PRELIGHTBACKGROUND);
  if(color.red >= 0)
    {
      if( parser.GetParam(arg,buffer,PROP_PRELIGHTBACKGROUND))
	gui_object->SetPropValue(PRELIGHTBACKGROUND,arg);
      gui_object->ObjectFromVDK()->PrelightBackground = color;
    }
  color = parser.Color(buffer,PROP_INSENSITIVEBACKGROUND);
  if(color.red >= 0)
    {
      if( parser.GetParam(arg,buffer,PROP_INSENSITIVEBACKGROUND))
	gui_object->SetPropValue(INSENSITIVEBACKGROUND,arg);
      gui_object->ObjectFromVDK()->InsensitiveBackground = color;
    }
  color = parser.Color(buffer,PROP_ACTIVEBACKGROUND);
  if(color.red >= 0)
    {
      if( parser.GetParam(arg,buffer,PROP_ACTIVEBACKGROUND))
	gui_object->SetPropValue(ACTIVEBACKGROUND,arg);
      gui_object->ObjectFromVDK()->ActiveBackground = color;
    }

  color = parser.Color(buffer,PROP_SELECTEDBACKGROUND);
  if(color.red >= 0)
    {
      if( parser.GetParam(arg,buffer,PROP_SELECTEDBACKGROUND))
	gui_object->SetPropValue(SELECTEDBACKGROUND,arg);
      gui_object->ObjectFromVDK()->SelectedBackground = color;
    }
  color = parser.Color(buffer,PROP_FOREGROUND);
  if(color.red >= 0)
    {
      if( parser.GetParam(arg,buffer,PROP_FOREGROUND))
	gui_object->SetPropValue(FOREGROUND,arg);
      gui_object->ObjectFromVDK()->Foreground = color;
    }
// other props here
 if(parser.GetParam(arg,buffer,PROP_ENABLED) && strcmp(arg,NIHIL_PROP))
   gui_object->SetPropValue(ENABLED,arg);
 if(parser.GetParam(arg,buffer,PROP_VISIBLE) && strcmp(arg,NIHIL_PROP))
   gui_object->SetPropValue(VISIBLE,arg);
 if(parser.GetParam(arg,buffer,PROP_TAG) && strcmp(arg,NIHIL_PROP))
   gui_object->SetPropValue("Tag",arg);
 // avoid in case of form
 if( dynamic_cast<VDKBGuiForm*>(gui_object) == NULL)
   {
     if(
	parser.GetParam(arg,buffer,PROP_JUSTIFY_INTERNAL) &&
	strcmp(arg,NIHIL_PROP)
	)
       gui_object->SetPropValue(JUSTIFY_INTERNAL,arg);
     if(parser.GetParam(arg,buffer,PROP_EXPAND_INTERNAL)
	&& strcmp(arg,NIHIL_PROP))
       gui_object->SetPropValue( EXPAND_INTERNAL,arg);
     if(parser.GetParam(arg,buffer,PROP_FILL_INTERNAL)
	&& strcmp(arg,NIHIL_PROP))
       gui_object->SetPropValue("_Fill",arg);
     if(parser.GetParam(arg,buffer,PROP_PADDING_INTERNAL)
	&& strcmp(arg,NIHIL_PROP))
       gui_object->SetPropValue("_Padding",arg);
     if(parser.GetParam(arg,buffer,PROP_TIP) && strcmp(arg,NIHIL_PROP))
       gui_object->SetPropValue("Tip",arg);
   }
 //
 if(parser.GetParam(arg,buffer,PROP_FONT) && strcmp(arg,NIHIL_PROP))
   {
     VDKFont* font = new VDKFont(gui_object->ObjectFromVDK()->Owner(),arg);
     if((char*) font)
       {
	 gui_object->SetPropValue( FONT,arg);
	 gui_object->ObjectFromVDK()->Font = font;
       }
     else
       font->Destroy();
   }
//
// get size
 // avoid in case of form
 if( dynamic_cast<VDKBGuiForm*>(gui_object) == NULL)
   {
     VDKPoint size = parser.Size(buffer);
     if(size.X() > 0 || size.Y() > 0)
       {
	 if(parser.GetParam(arg,buffer,PROP_USIZE))
	   gui_object->SetPropValue(USIZE,arg);
	 gui_object->ObjectFromVDK()->SetSize(size.X(),size.Y());
       }
   }
}
/*
 */
char*
VDKBObject::CreateSource(char* buffer,VDKBParser& parser,char* obj_name)
{
  char* source = new char [4096];
  char tmp[256];
  char arg[128];
  VDKRgb color;
  *source = '\0';
  color = parser.Color(buffer,PROP_NORMALBACKGROUND);
  if(color.red >= 0)
    {
      sprintf(tmp,"\n%s->NormalBackground = VDKRgb(%d,%d,%d);",
	      obj_name,
	      color.red,color.green,color.blue);
      strcpy(source,tmp);
    }

  color = parser.Color(buffer,PROP_PRELIGHTBACKGROUND);
  if(color.red >= 0)
    {
      sprintf(tmp,"\n%s->PrelightBackground = VDKRgb(%d,%d,%d);",
	      obj_name,
	      color.red,color.green,color.blue);
      strcat(source,tmp);
    }

  color = parser.Color(buffer,PROP_INSENSITIVEBACKGROUND);
  if(color.red >= 0)
    {
      sprintf(tmp,"\n%s->InsensitiveBackground = VDKRgb(%d,%d,%d);",
	      obj_name,
	      color.red,color.green,color.blue);
      strcat(source,tmp);
    }

  color = parser.Color(buffer,PROP_INSENSITIVEBACKGROUND);
  if(color.red >= 0)
    {
      sprintf(tmp,"\n%s->ActiveBackground = VDKRgb(%d,%d,%d);",
	      obj_name,
	      color.red,color.green,color.blue);
      strcat(source,tmp);
    }

  color = parser.Color(buffer,PROP_SELECTEDBACKGROUND);
  if(color.red >= 0)
    {
      sprintf(tmp,"\n%s->SelectedBackground = VDKRgb(%d,%d,%d);",
	      obj_name,
	      color.red,color.green,color.blue);
      strcat(source,tmp);
    }

  color = parser.Color(buffer,"Foreground:");
  if(color.red >= 0)
    {
      sprintf(tmp,"\n%s->Foreground = VDKRgb(%d,%d,%d);",
	      obj_name,
	      color.red,color.green,color.blue);
      strcat(source,tmp);
    }
  // other props here
  // set enabled only if == false
  if(parser.GetParam(arg,buffer,PROP_ENABLED) && !strcmp(arg,CHECK_FALSE) )
    {
      sprintf(tmp,"\n%s->Enabled = %s;", obj_name,arg);
      strcat(source,tmp);
    }

  if(parser.GetParam(arg,buffer,PROP_CURSOR) && strcmp(arg,NIHIL_PROP))
    {
      sprintf(tmp,"\n%s->Cursor = %s;", obj_name,arg);
      strcat(source,tmp);
    }

  if(parser.GetParam(arg,buffer,PROP_TIP) && strcmp(arg,NIHIL_PROP))
    {
      sprintf(tmp, "\n%s->SetTip(\"%s\");", obj_name,arg);
      strcat(source,tmp);
    }
  if(parser.GetParam(arg,buffer,PROP_TAG) && strcmp(arg,NIHIL_PROP))
    {
      sprintf(tmp, "\n%s->Tag = %s;", obj_name,arg);
      strcat(source,tmp);
    }
  // font
    if(parser.GetParam(arg,buffer,"Font:") && strcmp(arg,NIHIL_PROP))
    {
      sprintf(tmp,
	      "\nVDKFont* %s_font = new VDKFont(this,\"%s\");", obj_name,arg);
      strcat(source,tmp);
      sprintf(tmp, "\n%s->Font = %s_font;", obj_name,obj_name);
      strcat(source,tmp);
    }
    VDKPoint size = parser.Size(buffer);
    if(size.X() > 0 || size.Y() > 0)
      {
	sprintf(tmp,"\n%s->SetSize(%d,%d);",obj_name,size.X(),size.Y());
	strcat(source,tmp);
      }
    return source;
}

/*
 */
void
VDKBObject::WriteOnFrmEnd(FILE* fp)
{
 fprintf(fp,"\n}");
}

/*
 */
void
VDKBObject::PopObjectBrowser()
{
  if(object)
    object->Owner()->Application()->MessageBox(APPNAME,
					       "Sorry, not yet implemented",
					       MB_OK| MB_ICONINFORMATION);
}
/*
This should be override by subclasses in order
to add their own controls to inspector.
At this level results in a unuseful call
 */
VDKObjectContainer*
VDKBObject::ExtraWidget(VDKBObjectInspector* isp)
{
#ifdef VDKBDEBUG
printf("\n** WARNING **\nUnuseful call VDKBObject::ExtraWidget(%p)",
       isp);
fflush(stdout);
#endif
return (VDKObjectContainer*) NULL;
}

/*
 */
bool
VDKBObject::AddToParent(VDKObject* obj, GdkEvent* ev)
{
  VDKBObject* vdkbobj =
    dynamic_cast<VDKBObject*> (ObjectFromVDK()->Parent());
  if(vdkbobj)
    {
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(vdkbobj);
      if(container)
	{
	  // flag true will force args to AddWidget
	  bool flag = false;
	  VDKBProjectManager* prjman = NULL;
	  VDKBGuiForm* ownerform =
	    dynamic_cast<VDKBGuiForm*>(ObjectFromVDK()->Owner());
	  if(ownerform)
	     prjman = dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
	  if(prjman && prjman->objInspector)
	    flag = prjman->objInspector->preview->Checked;
	  if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      VDKBObject* self =
		dynamic_cast<VDKBObject*>(obj);
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      if(self)
		self->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      if(self)
		self->SetPropValue( EXPAND_INTERNAL,buff);
	      // others than justify and flag unuseful
	      container->AddWidget(obj,int(event->x),
				   int(event->y),
				   flag,true,true);
	    }
	  else
		  container->AddWidget(obj,
				       l_justify,
				       flag,flag,true,flag);

	  VDKBObject* self =
	    dynamic_cast<VDKBObject*>(obj);
	  if(self)
	    {
	      VDKBEventContainer* self_container =
		dynamic_cast<VDKBEventContainer*>(self);
	      if(self_container)
		  self_container->Outerbox(container);
	    }
	  return true;
	}
      else
	return false;
    }
  else
    return false;
}
/*
=======================================
COMMON RESPONSE METHODS DOR ALL OBJECTS
=======================================
*/
void
VDKBObject::SetupSignals(VDKObject* obj)
{
  // obsolete
}

/*
FIXED MOVING STUFF
 */
// 0 = none, 1 = move, 2 = resize
int dragAction = 0;
bool onDraggingAnObjectIntoAFixed = false;
extern GtkWidget *grabbed_widget;
VDKPoint drag_offset;
static VDKPoint last_position;
static VDKPoint startPoint;
static VDKPoint old_size;
// resizing stuff, disabled for now
// since must be reviewed
/*
VDKPoint drag_widget1;
VDKPoint drag_widget2;
*/
extern "C"
{
GtkWidget* get_event_widget (GtkWidget *widget,
			     GdkWindow *window,
			     gint x, gint y,
			     gint * x_return,
			     gint * y_return);
void
fixed_draw_grid (GtkWidget * widget,
		 int grid_horz_spacing,
		 int grid_vert_spacing,
		 int grid_style);
}
/*
  - handle mouse button click
 */

bool
VDKBObject::ButtonPressed(VDKObject* sender, GdkEvent* ev)
{
  VDKBEventContainer* container = NULL;
  GdkEventButton* event = (GdkEventButton*) ev;
  bool stop = true;
#if HAVE_GNOME
  stop = ! dynamic_cast<VDKGnomeDateEdit*>(sender);
#endif  
  if(stop)
      gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),
  		       "button_press_event");
  /*
    checks widget parent container
    to wich propagate message.
  */
  if(sender)
    container = dynamic_cast<VDKBEventContainer*>(sender->Parent());
  /*
    if check is done successfully, calls
    VDKBEventContainer::OnButtonPress() that:
    - Mark()  widget
    - set this as owner form active widget
    - if button pressed is 1 (left)
    propagates message to owner form if
    operational state shows that we are waiting for dropping
    a widget to gui.
    - else if button pressed is 3 (right)
    invokes virtual function Popmenu() that raises a
    popmenu.
    Note: void Popmenu() should be redefined in all new widgets
    and customized accordlying widget specs.
  */
  if(container)
    {
      container->OnButtonPressed(sender,ev);
      HandleFixed(sender,event);
     }
  return true;
}


/*
  - handle mouse button click release
 */
bool
VDKBObject::ButtonReleased(VDKObject* sender, GdkEvent* ev)
{
  VDKBEventContainer* container = NULL;
  VDKBFixed* fixed;
  // Fixing an obscure bug here, stopping signal
  // on a  scrollable notebook will hang
  // agreed isn't an elegant way to fix bugs
  // but i can't do better for now :-(
  bool stop = true;
  VDKBGuiNotebook* nbook = dynamic_cast<VDKBGuiNotebook*>(sender);
  if(nbook)
    {
      GtkNotebook* gtknotebook = GTK_NOTEBOOK(sender->Widget());
      stop = !(gtknotebook->scrollable);
    }
#if HAVE_GNOME
  stop = stop ? !dynamic_cast<VDKGnomeDateEdit*>(sender): stop;
#endif  
  if(stop)
      gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),
				 "button_release_event");
  Mark();
  // fixed widget stuff:
  // ungrab the mouse if were grabbed
  // during ButtonPressed
  if(grabbed_widget)
    {
      gtk_grab_remove(grabbed_widget);
      grabbed_widget = NULL;
    }
  // resets default cursor and global flags
  ObjectFromVDK()->SetCursor(curDefault);
  onDraggingAnObjectIntoAFixed = false;
  dragAction = 0;
  startPoint = VDKPoint(-1,-1);
  //  mark object and draw grid on fixed
  container = dynamic_cast<VDKBEventContainer*>(sender->Parent());
  if( container && (fixed = dynamic_cast<VDKBFixed*>(container)) )
    {
      bool have_grid = false;
      int horz_spacing = 1,vert_spacing = 1;
      VDKString isTrue = CHECK_TRUE;
      if(fixed && fixed->GetProp("have_grid") == isTrue)
	{
	  have_grid = true;
	  horz_spacing = atoi((char*) fixed->GetProp("h_grid_spacing"));
	  vert_spacing = atoi((char*) fixed->GetProp("v_grid_spacing"));
	}
      if(have_grid)
	fixed_draw_grid (fixed->Container(), horz_spacing,
			 vert_spacing, 1); // dots

    }
  return true;
}
/*
  - handle enter event
 */
bool
VDKBObject::OnEnter(VDKObject* sender, GdkEvent* ev)
{
  /*
    since gtk widgets  shouldn't react to events,
    signal is stopped here.
  */

#if VERBOSE
  printf("\nVDKBObject::OnEnter");
  fflush(stdout);
#endif
  gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),
			       "enter_notify_event");
 return true;
}
/*
  - handle leave event
 */
bool
VDKBObject::OnLeave(VDKObject* sender, GdkEvent* ev)
{
  /*
    since gtk widgets  shouldn't react to events,
    signal is stopped here.
  */
#if VERBOSE
  printf("\nVDKBObject::OnLeave");
  fflush(stdout);
#endif
  gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),
			       "leave_notify_event");
  return true;
}
/*


================================================



================================================
 */
/*
valid only for fixed containers
 */

bool
VDKBObject::HandleFixed(VDKObject* sender, GdkEventButton *event)
{
  VDKBEventContainer* container = NULL;
  container = dynamic_cast<VDKBEventContainer*>(sender->Parent());
  if( container && (event->button == 1) &&
      dynamic_cast<VDKBFixed*>(container))
    {
      int x = -1,y = -1;
      startPoint = VDKPoint(int(event->x),int(event->y));
      GtkWidget* widget = get_event_widget (sender->Widget(),
					    event->window,
					    int(event->x),
					    int(event->y),
					    &x,
					    &y);
      if(widget)
	{
#if VERBOSE
	  printf("\nVDKBObject::HandleFixed - %s - offset(%d,%d)",
		 gtk_widget_get_name (widget),
		 x,y);
	  fflush(stdout);
#endif
	  drag_offset = VDKPoint(x,y);
	  gtk_grab_add (grabbed_widget = widget);
	  const int width = widget->allocation.width-8;
	  const int height = widget->allocation.height-8;
	  VDKRect rs_corner(width,height,8,8);
	  VDKPoint mouse(x,y);
	  if(rs_corner.Contains(mouse))
	  {
	    dragAction = 2; // resize
	    sender->SetCursor((VDKCursorType) GDK_BOTTOM_RIGHT_CORNER);
	  }
	  else
	    {
	      dragAction = 1; // move
	      sender->SetCursor((VDKCursorType) GDK_FLEUR);
	    }
	  onDraggingAnObjectIntoAFixed = true;
	}
      else
	drag_offset = VDKPoint(0,0);
      return onDraggingAnObjectIntoAFixed;
    }
  return false;
}



#define USE_KEY_ROUTINES 0

#if USE_KEY_ROUTINES

/* here we use the simples method:
   reuse key routines
   drawbacks:
   show a "gummy" behaviours, are slow and flick
   like an hell
*/
/*
 */
bool
VDKBObject::OnMouseMove(VDKObject* sender, GdkEvent* ev)
{
  int event_x, event_y;
  VDKBFixed* fixed = NULL;
  VDKBEventContainer* container = NULL;
  GdkEventMotion *event = (GdkEventMotion*) ev;
#if VERBOSE
  printf("\n(1) VDKBObject::OnMouseMove - %s - x:%d,y%d",
	 gtk_widget_get_name (sender->Widget()),
	 int(event->x),
	 int(event->y));
  fflush(stdout);
#endif
  // stop the signal
  gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),
			       "motion_notify_event");
  container = dynamic_cast<VDKBEventContainer*>(ObjectFromVDK()->Parent());

  if(
     onDraggingAnObjectIntoAFixed &&
     container &&
     (fixed = dynamic_cast<VDKBFixed*>(container))
     )
    {
      GtkWidget* signal_widget =
	grabbed_widget ?
	grabbed_widget :
	sender->Widget();
      // get mouse position
      if (event->is_hint)
	gtk_widget_get_pointer (signal_widget, &event_x, &event_y);
      else
	// or use those in event
	{
	  event_x = int(event->x);
	  event_y = int(event->y);
	}
#if VERBOSE
      printf("\n(2) VDKBObject::OnMouseMove - %s - x:%d,y%d - state:%d",
	     gtk_widget_get_name (signal_widget),
	     event_x,
	     event_y,
	     event->state);
      printf("\n(3) VDKBObject::OnMouseMove - %s - x:%d,y%d",
	     gtk_widget_get_name (signal_widget),
	     event_x-startPoint.x,
	     event_y-startPoint.y);
      fflush(stdout);
#endif
      // moving/resizing work
      // have grid ?
      bool have_grid = false;
      bool isShift = event->state & GDK_SHIFT_MASK;
      VDKString isTrue = CHECK_TRUE;
      have_grid = fixed->GetProp("have_grid") == isTrue;
      // casting to owner edit form
      VDKBGuiForm* form = dynamic_cast<VDKBGuiForm*>(sender->Owner());
      // preparing dummy events
      GdkEventKey xkey_event;
      GdkEventKey ykey_event;
      // setting moving (1) /resizing(2) flags
      if(dragAction == 1)
	{
	  xkey_event.state = isShift && have_grid ? 1 : 0;
	  ykey_event.state = isShift && have_grid ? 1 : 0;
	}
      else
	{
	  xkey_event.state = isShift && have_grid ?  5 : 4;
	  ykey_event.state = isShift && have_grid ?  5 : 4;
	}
      // computing dragging distance
      int xMove = event_x-startPoint.x;
      int yMove = event_y-startPoint.y;
      // setting actions
      if(xMove > 0)
	xkey_event.keyval = GDK_Right;
      else if(xMove < 0)
	xkey_event.keyval = GDK_Left;
      if(yMove > 0)
	ykey_event.keyval = GDK_Down;
      else if(yMove < 0)
	ykey_event.keyval = GDK_Up;
      if(form && xMove)
	form->HandleOnKey(sender, &xkey_event);
      if(form && yMove)
	form->HandleOnKey(sender, &ykey_event);
      startPoint = VDKPoint(event_x,event_y);
    }
  return true;
}

#else
/*
here we use native mouse routines for moving and
key routines for resizing
drawbacks:
- moving is fast but erratic and do not work well
for containers
*/
bool
VDKBObject::OnMouseMove(VDKObject* sender, GdkEvent* ev)
{
  int event_x, event_y;
  VDKBFixed* fixed = NULL;
  VDKBEventContainer* container = NULL;
  GdkEventMotion *event = (GdkEventMotion*) ev;
#if VERBOSE
  printf("\nVDKBObject::OnMouseMove - %s - x:%d,y%d",
	 gtk_widget_get_name (sender->Widget()),
	 int(event->x),
	 int(event->y));
  fflush(stdout);
#endif
  // stop the signal
  //gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),
  //		       "motion_notify_event");
  container = dynamic_cast<VDKBEventContainer*>(ObjectFromVDK()->Parent());

  // this code interest only those widgets contained into a fixed.
  // extern <bool onDraggingAnObjectIntoAFixed> flag is set to true by
  // VDKOBject::ButtonPressed handler or should be set by
  // an overridden one in subclasses
  if(container && (fixed = dynamic_cast<VDKBFixed*>(container)))
    {
      if(onDraggingAnObjectIntoAFixed )
	{
	  // extern <GtkWidget* grabbed_widget> should be set by
	  // VDKOBject::ButtonPressed handler
	  // or an overridden one in subclasses
	  GtkWidget* signal_widget =
	    grabbed_widget ? grabbed_widget : sender->Widget();
	  // get mouse position
	  if (event->is_hint)
	    gtk_widget_get_pointer (signal_widget, &event_x, &event_y);
	  else
	    // or use those in event
	    {
	      event_x = int(event->x);
	      event_y = int(event->y);
	    }
	  // corrects with widget offset
	  event_x -= drag_offset.x;
	  event_y -= drag_offset.y;
	  // grid work
	  int horz_spacing = 0,vert_spacing = 0;
	  bool isShift = event->state & GDK_SHIFT_MASK;
	  VDKString isTrue = CHECK_TRUE;
	  bool have_grid = fixed->GetProp("have_grid") == isTrue;
	  if(have_grid && isShift)
	    {
	      horz_spacing = atoi((char*) fixed->GetProp("h_grid_spacing"));
	      vert_spacing = atoi((char*) fixed->GetProp("v_grid_spacing"));
	      // snaps to grid
	      event_x += horz_spacing / 2;
	      event_x -= event_x % horz_spacing;
	      event_y += vert_spacing / 2;
	      event_y -= event_y % vert_spacing;
	    }
	  VDKPoint new_position(event_x,event_y);
	
	  // here we move or resize
	  // for resize we use key routines
	  switch(dragAction)
	    {
	    case 1: // move
	      // move only if position is really changed
	      // and shows a reasonable value
	      if ( (new_position.x > 0) && (new_position.y > 0) &&
		   new_position != last_position)
		{
		  gtk_fixed_move(GTK_FIXED(fixed->Container()),
				 sender->Widget(),
				 new_position.x,
				 new_position.y);
		  // corrects GTK+ bug. Some widgets do not move unless
		  // you call gtk_widget_set_uposition()
		  gtk_widget_set_uposition (sender->Widget(),
					    new_position.x,
					    new_position.y);
		  // update widget properties
		  sprintf(buff,"%d",new_position.x);
		  SetPropValue(JUSTIFY_INTERNAL,buff);
		  sprintf(buff,"%d",new_position.y);
		  SetPropValue( EXPAND_INTERNAL,buff);
		  last_position = VDKPoint(grabbed_widget->allocation.x,
					   grabbed_widget->allocation.y);
		}
	      break;
	    case 2: // resize
	      {
		// casting to owner edit form
		VDKBGuiForm* form = dynamic_cast<VDKBGuiForm*>(sender->Owner());
		// preparing dummy events
		GdkEventKey xkey_event;
		GdkEventKey ykey_event;
		xkey_event.state = isShift && have_grid ?  5 : 4;
		ykey_event.state = isShift && have_grid ?  5 : 4;
		// computing dragging distance
		int xMove = event_x-startPoint.x;
		int yMove = event_y-startPoint.y;
		// setting actions
		if(xMove > 0)
		  xkey_event.keyval = GDK_Right;
		else if(xMove < 0)
		  xkey_event.keyval = GDK_Left;
		if(yMove > 0)
		  ykey_event.keyval = GDK_Down;
		else if(yMove < 0)
		  ykey_event.keyval = GDK_Up;
		if(form && xMove)
		  form->HandleOnKey(sender, &xkey_event);
		if(form && yMove)
		  form->HandleOnKey(sender, &ykey_event);
		startPoint = VDKPoint(event_x,event_y);
	      }
	      break;
	    }
	}
    }
  return true;
}
#endif







