/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_signal_h
#define _vdkb_signal_h
#include <vdk/vdkstring.h>
#include <vdk/value_sem_list.h>
//=========================
class VDKBObject;

class VDKBSignal
{
 protected:
  VDKString signal,slot,nickname;
  VDKBObject* sender;
  bool connected;
  bool slotFixed;
 public:
  VDKBSignal() {};
  VDKBSignal(char* name, VDKBObject* sender,  char* nickname,
	     char* slot = NULL);
  ~VDKBSignal() {};
  char* Signal() { return (char*) signal; }
  VDKBObject* Sender();
  char* Slot(char* s = NULL) { if(s) slot = s; return slot; }
  char* Nickname() { return (char*) nickname; }
  bool Connected(int f = -1) 
    { if(f >=0) connected = f; return connected; }
  bool SlotFixed(int f = -1) 
    { if(f >=0) slotFixed = f; return slotFixed; }
  bool operator==(VDKBSignal& p);
  bool operator<(VDKBSignal& p)
    { return sender < p.sender; }
};
//===========================================================
typedef VDKValueList<VDKBSignal> VDKBSList;
typedef VDKValueListIterator<VDKBSignal> VDKBSListIterator;
//===========================================================
class VDKBSignalList: public VDKBSList
{
 protected:

 public:
  VDKBSignalList() {}
  ~VDKBSignalList(){}
};

#endif
