/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_event_box_h
#define _vdkb_event_box_h

#include <vdkb/vdkb_evcontain.h>
#include <vdkb/vdkb_widpopmenu.h>
//#include <vdk/menu.h>


class VDKBGuiForm;
class VDKBParser;
class VDKBObjectInspector;

class VDKBEventBox: public VDKBEventContainer
{
 protected:
  VDKMenuItem *delBox, *addHbox, *addVbox, *split, *setsize;
  VDKMenuItem *addwidget,*delwidget;
  void Init(int w, int h);
  // property controls used by object inspector
  VDKSpinButton* border;
  VDKCheckButton* evboxCb;
  VDKBObjectInspector* inspector; // object inspector

 public:
  static int Counter;
  bool PreviewFlag;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static int MakeWidgetV(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  static int MakeWidgetH(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBEventBox(char* name, VDKForm* owner , bool empty);

  VDKBEventBox(char* name, VDKForm* owner, int mode = v_box, 
	       int w = 16, int h = 16);

  VDKBEventBox(char* name, VDKBEventContainer* outer,
	       int mode = v_box, 
	       int w = 16, int h = 16);

  virtual ~VDKBEventBox() {}
  
  void AddBox();

  void AddCanvas(int w, int h);

  void PopMenu() { if(popmenu) popmenu->Popup(); }

  bool OnButtonPressed(VDKObject*, GdkEvent*);

  bool OnButtonReleased(VDKObject*, GdkEvent*);

  bool OnMouseMove(VDKObject*, GdkEvent*);

  bool Split(VDKObject* sender);

  bool AddVBox(VDKObject*);

  bool AddHBox(VDKObject*);

  bool DelBox(VDKObject* sender);

  virtual int Type() { return vdkbevbox_class; }

  virtual int isA() { return vdkbevbox_class; }


  virtual void Add(VDKObject* obj, int justify = l_justify,
		   int expand = TRUE, int fill = TRUE , int padding = 0);

  virtual void AddWidget(VDKObject* w, int justify = l_justify,
		 int expand = TRUE, int fill = TRUE , 
		 int padding = 0, bool forceArgs = false);

  virtual char* VDKName() { return "VDKBox"; }

  bool OnDragStop(VDKObject*, GdkEvent* );
  bool SetBoxSize(VDKObject* sender);
  // designer
  virtual void WriteOnFrm(FILE* fp, VDKBObject* parentobj);
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  bool OnBorderWidth(VDKObject*);
  bool OnSetEventBox(VDKObject*);
  DECLARE_EVENT_LIST(VDKBEventBox);
  DECLARE_SIGNAL_LIST(VDKBEventBox);
};

#endif

