
#include <testvdk.h>
/*
defining signal and events
dynamics tables
*/
DEFINE_SIGNAL_LIST(TestvdkForm,VDKForm);
DEFINE_EVENT_LIST(TestvdkForm,VDKForm);
/*
defining signal static table
*/
DEFINE_SIGNAL_MAP(TestvdkForm,VDKForm)
ON_SIGNAL(showNoteBookButton,clicked_signal,OnshowNoteBookButtonClick),
ON_SIGNAL(quitButton,clicked_signal,OnquitButtonClick),
ON_SIGNAL(sourceText,realize_signal,OnsourceTextRealize),
ON_SIGNAL(headerText,realize_signal,OnheaderTextRealize),
ON_SIGNAL(list,select_row_signal,OnlistSelectRow),
ON_SIGNAL(testButton,clicked_signal,OntestButtonClick),
ON_SIGNAL(main_notebook,switch_page_signal,Onmain_notebookSwitchPage),
ON_SIGNAL(gui_headerText,realize_signal,Ongui_HeaderTextRealize),
ON_SIGNAL(gui_sourceText,realize_signal,Ongui_sourceTextRealize)
END_SIGNAL_MAP
/*
main form setup
*/
void
TestvdkForm::GUISetup(void)
{
	SetSize(376,277);
	Title = "VDK Test program";
VDKRawPixmap* _backpix = new VDKRawPixmap(this,"vdklogo.xpm");
if(_backpix) BackgroundPixmap = _backpix ;
vbox2 = new VDKBox(this,v_box);
Add(vbox2,0,1,1,0);
main_status_bar = new VDKStatusbar(this);
main_status_bar->Foreground = VDKRgb(255,255,255);
vbox2->Add(main_status_bar,2,0,0,0);
handlebox1 = new VDKHandleBox(this);
vbox2->Add(handlebox1,0,0,0,0);
hbox3 = new VDKBox(this,h_box);
handlebox1->Add(hbox3,0,1,1,0);
quitButton = new VDKCustomButton(this,"exit.xpm","_Quit",16,(GtkPositionType) 1);
hbox3->Add(quitButton,0,1,1,0);
showNoteBookButton = new VDKCustomButton(this,"viewunits.xpm","_Show tests",16,(GtkPositionType) 1);
showNoteBookButton->SetSize(104,30);
hbox3->Add(showNoteBookButton,0,1,1,0);
combobutton = new VDKCustomButton(this,(char*) NULL,"Tests",20,(GtkPositionType) 0);
hbox3->Add(combobutton,0,1,1,0);
dialogcombobutton = new VDKCustomButton(this,(char*) NULL,"Dialogs",20,(GtkPositionType) 0);
hbox3->Add(dialogcombobutton,0,1,1,0);
main_notebook = new VDKNotebook(this);
vbox2->Add(main_notebook,0,1,1,0);
notebookPage0 = new VDKBox(this,v_box);
main_notebook->AddPage(notebookPage0,"Test list");
fixed2 = new VDKFixed(this);
notebookPage0->Add(fixed2,0,1,1,0);
label0 = new VDKLabel(this,"Last update");
label0->SetSize(84,20);
label0->Justify =  (GtkJustification) 2;
fixed2->Add(label0,256,0,1,0);
entry0 = new VDKEntry(this,0);
entry0->SetSize(120,26);
fixed2->Add(entry0,232,20,1,0);
testButton = new VDKCustomButton(this,"mini-ray.xpm","Test it",16,(GtkPositionType) 1);
testButton->Enabled = false;
testButton->SetSize(120,30);
fixed2->Add(testButton,232,50,1,0);
char* listTitles[] = { "Example name","Avl" };
list = new VDKCustomList(this,2,listTitles,(GtkSelectionMode) 0);
list->SetSize(224,184);
fixed2->Add(list,0,0,1,0);
pixmap0 = new VDKPixmap(this,"gtk-logo-rgb.xpm");
pixmap0->SetSize(40,40);
fixed2->Add(pixmap0,272,136,1,0);
pixmap1 = new VDKPixmap(this,"vdk-logo.xpm");
pixmap1->SetSize(56,32);
fixed2->Add(pixmap1,264,80,1,0);
label1 = new VDKLabel(this,"a C++ wrapper of");
VDKFont* label1_font = new VDKFont(this,"-adobe-helvetica-bold-r-normal-*-*-120-*-*-p-*-iso8859-1");
label1->Font = label1_font;
label1->SetSize(104,16);
fixed2->Add(label1,240,115,1,0);
main_notebook_page1 = new VDKBox(this,v_box);
main_notebook->AddPage(main_notebook_page1,"Source code");
sourceText = new VDKText(this,true);
VDKFont* sourceText_font = new VDKFont(this,"-adobe-courier-medium-r-normal-*-*-120-*-*-m-*-iso8859-1");
sourceText->Font = sourceText_font;
sourceText->WordWrap = false;
main_notebook_page1->Add(sourceText,0,1,1,0);
main_notebook_page2 = new VDKBox(this,v_box);
main_notebook->AddPage(main_notebook_page2,"Source header");
headerText = new VDKText(this,true);
VDKFont* headerText_font = new VDKFont(this,"-adobe-courier-medium-r-normal-*-*-120-*-*-m-*-iso8859-1");
headerText->Font = headerText_font;
headerText->WordWrap = false;
main_notebook_page2->Add(headerText,0,1,1,0);
main_notebook_page3 = new VDKBox(this,v_box);
main_notebook->AddPage(main_notebook_page3,"GUI source");
gui_sourceText = new VDKText(this,true);
VDKFont* gui_sourceText_font = new VDKFont(this,"-adobe-courier-medium-r-normal-*-*-120-*-*-m-*-iso8859-1");
gui_sourceText->Font = gui_sourceText_font;
gui_sourceText->WordWrap = false;
main_notebook_page3->Add(gui_sourceText,0,1,1,0);
main_notebook_page4 = new VDKBox(this,v_box);
main_notebook->AddPage(main_notebook_page4,"GUI header");
gui_headerText = new VDKText(this,true);
VDKFont* gui_headerText_font = new VDKFont(this,"-adobe-courier-medium-r-normal-*-*-120-*-*-m-*-iso8859-1");
gui_headerText->Font = gui_headerText_font;
gui_headerText->WordWrap = false;
main_notebook_page4->Add(gui_headerText,0,1,1,0);
}
