#!/bin/sh
echo "This script will create two CVS modules to be used to"
echo "demonstrate merging of vendor code into the a local version"
echo It will create:
echo "  1. Create CVS Module Examples/Local"
echo "  2. Create CVS Module Examples/Vendor"
echo "  3. Checkout CVS administrative module "modules" in your home directory"
echo "  4. Append #D and #M lines associated with the above two modules to file"
echo "     modules"
echo "  5. Check back in file modules"
echo "as described in the file vendor.readme"
echo ""
echo "Continue? (y/n):"
read answer
case "$answer" in
  y) ;;
  Y) ;;
  *) exit
esac

if test -d Examples
then
  echo directory Examples exists already
else
  mkdir Examples
  echo created directory Examples
fi

cd Examples
if test -d Local
then 
  echo directory Local already exists
  cd Local
  rm -f *
else
  mkdir Local
  echo created directory Local
  cd Local
fi

# Create files for module Local
cat > main <<END
program Main
Revision 1
 ..
 .. (local code)
Get
 ..
end
END
cat > get <<END
Proc Get
Revision 1
 ..
 ..
end
END
ls
cat main
cat get
cvs import -m"Local code used for testing" Examples/Local LOCAL rev1
echo ---------------------------------------------------------------
echo ""
 
cd ..
if test -d Vendor
then 
  echo directory Vendor already exists
  cd Vendor
  rm -rf *
else
  mkdir Vendor
  echo created directory Vendor
  cd Vendor
fi

# Create files for Vendor, revision 1
mkdir V1
cd V1
cat > main <<END
program Main
Revision 1
 ..
Get
 ..
end
END
cat > get <<END
Proc Get
Revision 1
 ..
 ..
end
END
ls
cat main
cat get
cvs import -m"Vendor code used for testing" Examples/Vendor VENDOR rev1
echo Imported code for vendor code, rev 1
echo ------------------------------------------------------------------
echo ""

# Create files for Vendor, revision 2
cd ..
mkdir V2
cd V2
cat > main <<END
program Main
Revision 2
 ..
Get
 ..
Sort
Printout
end
END
cat > get <<END
Proc Get
Revision 2
 ..
 ..
 (new code inv rev 2)
end
END
cat > sort <<END
Proc Sort
Revision 2
 ..
end
END
pwd
ls
cat main
cat get
cat sort
cvs import -m"Vendor code used for testing" Examples/Vendor VENDOR rev2
echo Imported code for Vendor code, rev 2
echo ------------------------------------------------------------------
echo ""

# Create files for Vendor, revision 3
cd ..
mkdir V3
cd V3
cat > main <<END
program Main
Revision 3
 ..
GetSort
Printout
end
END
cat > getsort <<END
Proc GetSort
Revision 3
 ..
 ..
end
END

ls
cat main
cat getsort
cvs import -m"Vendor code used for testing" Examples/Vendor VENDOR rev3
echo Imported code for Vendor code, rev 3
echo ------------------------------------------------------------------

echo "Add #D and #M lines to the CVS modules file?"
echo " y - if this is the first time branchgen.sh is invoked"
echo " n - otherwise (y/n)"
read answer
case "$answer" in
  y) ;;
  Y) ;;
  *) exit
esac

# Checkout a CVS modules named "modules" in your home directory
cd
if test -d modules
then
  echo Directory modules already exists in your home directory.
  echo It will be removed.
  rm -rf modules
fi
# cvs checkout of modules in your home directory
cvs co modules
cd modules

# Your local copy of the modules file needs to be modified so
# that tkcvs knows where the directory Examples and where the
# modules local and vendor are located

cat >> modules <<END

#D	Examples	Directory of testing

#M	local	Local code used for testing Merge
local	Examples/Local

#M	vendor	Vendor code used for testing Merge
vendor	Examples/Vendor
END

# Checkin modules back to the repository
cvs ci -m "added inputs from branchgen.sh" modules
