      SUBROUTINE PBSTRADD( ICONTXT, UPLO, FORM, M, N, ALPHA, A, LDA,
     $                     BETA, B, LDB, MINT, NINT, MEN, NEN )
*
*  -- PB-BLAS routine (version 2.1) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory.
*     April 28, 1996
*
*     .. Scalar Arguments ..
      CHARACTER          FORM, UPLO
      INTEGER            ICONTXT, LDA, LDB, M, MEN, MINT, N, NEN, NINT
      REAL               ALPHA, BETA
*     ..
*     .. Array Arguments ..
      REAL               A( LDA, * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  PSTRADD copies part of an upper (or lower) triangular matrix A
*  to another matrix B:
*                       B <== alpha * A + beta * B
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, J, JP, JX, MM, MX
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      EXTERNAL           ICEIL, LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           PBSMATADD, PBSVECADD
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN
*     ..
*     .. Executable Statements ..
*
      IF( LSAME( UPLO, 'U' ) ) THEN
*
         IF( LSAME( FORM, 'T' ) ) THEN
*
*           A is upper triangular (triangular part is at the bottom)
*
            MM = M
            JP = 0
            DO 20 I = 1, ICEIL( NEN, NINT )
               DO 10 J = 1, MIN( N, NEN-JP )
                  JX = JP + J
                  CALL PBSVECADD( ICONTXT, 'G', MM+J, ALPHA, A( 1, JX ),
     $                            1, BETA, B( 1, JX ), 1 )
   10          CONTINUE
               MM = MM + MINT
               JP = JP + NINT
   20       CONTINUE
*
         ELSE
*
*           A is a rectangular matrix
*
            MM = M
            JP = 1
            DO 30 I = 1, ICEIL( NEN, NINT )
               CALL PBSMATADD( ICONTXT, 'G', MM, MIN( N, NEN-JP+1 ),
     $                         ALPHA, A( 1, JP ), LDA, BETA, B( 1, JP ),
     $                         LDB )
               MM = MM + MINT
               JP = JP + NINT
   30       CONTINUE
         END IF
*
      ELSE
*
         IF( LSAME( FORM, 'T' ) ) THEN
*
*           A is lower triangular (triangular part is at the top)
*
            MM = M
            JP = 0
            DO 50 I = 1, ICEIL( NEN, NINT )
               DO 40 J = 1, MIN( N, NEN-JP )
                  MX = MM + J
                  JX = JP + J
                  IF( MX.LE.MEN )
     $               CALL PBSVECADD( ICONTXT, 'G', MEN-MX+1, ALPHA,
     $                               A( MX, JX ), 1, BETA, B( MX, JX ),
     $                               1 )
   40          CONTINUE
               MM = MM + MINT
               JP = JP + NINT
   50       CONTINUE
*
         ELSE
*
*           A is a rectangular matrix
*
            MM = M + 1
            JP = 1
            DO 60 I = 1, ICEIL( NEN, NINT )
               CALL PBSMATADD( ICONTXT, 'G', MEN-MM+1,
     $                         MIN( N, NEN-JP+1 ), ALPHA, A( MM, JP ),
     $                         LDA, BETA, B( MM, JP ), LDB )
               MM = MM + MINT
               JP = JP + NINT
   60       CONTINUE
         END IF
      END IF
*
      RETURN
*
*     End of PBSTRADD
*
      END
