      SUBROUTINE PBCLACPZ( ICONTXT, UPLO, FORM, DIAG, M, N, A, LDA, B,
     $                     LDB, MINT, NINT, MEN, NEN )
*
*  -- PB-BLAS routine (version 2.1) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory.
*     April 28, 1996
*
*     .. Scalar Arguments ..
      CHARACTER*1        DIAG, FORM, UPLO
      INTEGER            ICONTXT, LDA, LDB, M, MEN, MINT, N, NEN, NINT
*     ..
*     .. Array Arguments ..
      COMPLEX            A( LDA, * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  PBCLACPZ copies part of a two-dimensional upper (or lower) tri-
*  angular Matrix A to another matrix B with forced zeros in the
*  other part.
*
*  =====================================================================
*
*     .. Parameters ..
      COMPLEX            ONE, ZERO
      PARAMETER          ( ONE  = ( 1.0E+0, 0.0E+0 ),
     $                     ZERO = ( 0.0E+0, 0.0E+0 ) )
*     ..
*     .. Local Scalars ..
      LOGICAL            NOUNIT
      INTEGER            I, J, JJ, JP, MN, MX
      COMPLEX            DUMMY
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      EXTERNAL           ICEIL, LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           CCOPY, PBCMATADD, PBCVECADD
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN, REAL
*     ..
*     .. Executable Statements ..
*
      NOUNIT = LSAME( DIAG, 'N' )
      JP = 0
      MN = M
*
      IF( LSAME( UPLO, 'U' ) ) THEN
*
         IF( LSAME( FORM, 'T' ) ) THEN
*
*           A is upper triangular
*
            DO 20 I = 1, ICEIL( NEN, NINT )
               DO 10 J = 1, MIN( N, NEN-JP )
                  JJ = JP + J
                  MX = MN + J
                  IF( NOUNIT ) THEN
                     CALL CCOPY( MX, A( 1, JJ ), 1, B( 1, JJ ), 1 )
                  ELSE
                     CALL CCOPY( MX-1, A( 1, JJ ), 1, B( 1, JJ ), 1 )
                     B( MX, JJ ) = ONE
                  END IF
                  CALL PBCVECADD( ICONTXT, 'G', MEN-MX, ZERO, DUMMY, 1,
     $                            ZERO, B( MX+1, JJ ), 1 )
   10          CONTINUE
               MN = MN + MINT
               JP = JP + NINT
   20       CONTINUE
*
         ELSE IF( LSAME( FORM, 'H' ) ) THEN
*
*           A is upper triangular Hermitian
*
            DO 40 I = 1, ICEIL( NEN, NINT )
               DO 30 J = 1, MIN( N, NEN-JP )
                  JJ = JP + J
                  MX = MN + J
                  CALL CCOPY( MX-1, A( 1, JJ ), 1, B( 1, JJ ), 1 )
                  IF( NOUNIT ) THEN
                     B( MX, JJ ) = REAL( A( MX, JJ ) )
                  ELSE
                     B( MX, JJ ) = ONE
                  END IF
                  CALL PBCVECADD( ICONTXT, 'G', MEN-MX, ZERO, DUMMY, 1,
     $                            ZERO, B( MX+1, JJ ), 1 )
   30          CONTINUE
               MN = MN + MINT
               JP = JP + NINT
   40       CONTINUE
*
         ELSE
*
*           A is a rectangular matrix
*
            DO 50 I = 1, ICEIL( NEN, NINT )
               MX = MIN( N, NEN-JP )
               CALL PBCMATADD( ICONTXT, 'V', MN, MX, ONE, A( 1, JP+1 ),
     $                         LDA, ZERO, B( 1, JP+1 ), LDB )
               CALL PBCMATADD( ICONTXT, 'G', MEN-MN, MX, ZERO, DUMMY, 1,
     $                         ZERO, B( MN+1, JP+1 ), LDB )
               MN = MN + MINT
               JP = JP + NINT
   50       CONTINUE
*
         END IF
*
      ELSE
*
         IF( LSAME( FORM, 'T' ) ) THEN
*
*           A is lower triangular
*
            MN = M - 1
            DO 70 I = 1, ICEIL( NEN, NINT )
               DO 60 J = 1, MIN( N, NEN-JP )
                  JJ = JP + J
                  MX = MN + J
                  CALL PBCVECADD( ICONTXT, 'G', MX, ZERO, DUMMY, 1,
     $                            ZERO, B( 1, JJ ), 1 )
                  IF( NOUNIT ) THEN
                     CALL CCOPY( MEN-MX, A( MX+1, JJ ), 1,
     $                           B( MX+1, JJ ), 1 )
                  ELSE
                     B( MX+1, JJ ) = ONE
                     CALL CCOPY( MEN-MX-1, A( MX+2, JJ ), 1,
     $                           B( MX+2, JJ ), 1 )
                  END IF
   60          CONTINUE
               MN = MN + MINT
               JP = JP + NINT
   70       CONTINUE
*
         ELSE IF( LSAME( FORM, 'H' ) ) THEN
*
*           A is lower triangular Hermitian
*
            MN = M - 1
            DO 90 I = 1, ICEIL( NEN, NINT )
               DO 80 J = 1, MIN( N, NEN-JP )
                  JJ = JP + J
                  MX = MN + J
                  CALL PBCVECADD( ICONTXT, 'G', MX, ZERO, DUMMY, 1,
     $                            ZERO, B( 1, JJ ), 1 )
                  IF( NOUNIT ) THEN
                     B( MX+1, JJ ) = REAL( A( MX+1, JJ ) )
                  ELSE
                     B( MX+1, JJ ) = ONE
                  END IF
                  CALL CCOPY( MEN-MX-1, A( MX+2, JJ ), 1,
     $                        B( MX+2, JJ ), 1 )
   80          CONTINUE
               MN = MN + MINT
               JP = JP + NINT
   90       CONTINUE
*
         ELSE
*
*           A is a rectangular matrix
*
            DO 100 I = 1, ICEIL( NEN, NINT )
               MX = MIN( N, NEN-JP )
               CALL PBCMATADD( ICONTXT, 'G', MN, MX, ZERO, DUMMY, 1,
     $                         ZERO, B( 1, JP+1 ), LDB )
               CALL PBCMATADD( ICONTXT, 'V', MEN-MN, MX, ONE,
     $                         A( MN+1, JP+1 ), LDA, ZERO,
     $                         B( MN+1, JP+1), LDB )
               MN = MN + MINT
               JP = JP + NINT
  100       CONTINUE
*
         END IF
*
      END IF
*
      RETURN
*
*     End of PBCLACPZ
*
      END
