
(define *interrupt-mbox* (make-mailbox))

(define (do-user-intr)
  (send-message! *interrupt-mbox* (cons 'SIGINT (time))))

(define (do-c-signal name)
  (send-message! *interrupt-mbox* (cons name (time))))

(define *finalization-mbox* (make-mailbox))

(define *finalizer-pool* (make-thread-pool "finalize" finalize))

(define (thread-yield)
  (thread-sleep 1))

(define (finalizer)
  (let outer-loop ()
    ;;(format #t "trying to finalize\n")
    (let loop ((lst (receive-message! *finalization-mbox*)))
      (if (null? lst)
	  (outer-loop)
	  (begin
	    (thread-pool-invoke *finalizer-pool* (car lst))
	    (thread-yield)
	    (loop (cdr lst)))))))
	
(define (do-finalize items)
  (send-message! *finalization-mbox* items))

(define (do-gc-flip)
  ;(display "GC flip\n")
  (values))
  
;;

(define (boot-threads-system thunk)
  (set-thread-state-reg! (thread-var-default-state))
  (set-dynamic-state-reg! '())
  (start-threads
   (list (make-thread* thunk "main" (make <thread-group>))
	 (make-thread* finalizer "finalize" (make <thread-group>)))))

(define (start-with-thread thunk)
  ;
  (let ((inp (open-mbox-input-port 0))
	(out (open-queued-output 1))
	(err (open-queued-output 2)))
    (set-flush-lines?! out #t)
    (set-flush-lines?! err #t)
    ;
    (vector-set! *thread-var-prototype* 1 inp)
    (vector-set! *thread-var-prototype* 2 out)
    ;
    (vector-set! *thread-var-prototype*
		 0
		 (vector
		  '*error-port*
		  err
		  (vector
		   '*console-input-port*
		   inp
		   (vector
		    '*console-output-port*
		    out
		    (vector
		     '*console-error-port*
		     err
		     #f)))))
    (vector-set! *thread-var-prototype* 3 *backstop-handler-chain*))
  ;
  (set! *interrupt-mbox* (make-mailbox))
  (set! *finalization-mbox* (make-mailbox))
  (set! *finalizer-pool* (make-thread-pool "finalize" finalize))
  ;
  (register-interrupt-handler! 'timer time-slice-over)
  (register-interrupt-handler! 'user-intr do-user-intr)
  (register-interrupt-handler! 'child-exited do-child-exited)
  (register-interrupt-handler! 'finalize do-finalize)
  (register-interrupt-handler! 'gc-flip do-gc-flip)
  (register-interrupt-handler! 'c-signal do-c-signal)
  ;
  (setup-c-signal-handler! 'SIGUSR1)
  (setup-c-signal-handler! 'SIGPIPE)
  ;
  (enable-subprocess-capture)
  (boot-threads-system thunk))

(%early-once-only
 (set-start-threads-hook! start-with-thread))
