#|------------------------------------------------------------*-Scheme-*--|
 | File:	    packages/threads/shell/bg.scm
 |
 |          Copyright (C)1998 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |	    See <http://www.rscheme.org/> for the latest info.
 |
 | File version:     1.3
 | File mod date:    1998.12.02 10:18:24
 | System build:     v0.7.3.1-b39, 1999-12-25
 | Owned by module:  rs.sys.threads.shell
 |
 | Purpose:          Provide functionality somewhat like shell's "&"
 |		     in creating background jobs
 `------------------------------------------------------------------------|#

(define (run-in-bg thunk)
  (let ((err (current-error-port)))
    ;
    (define (bg-condition-handler (c <condition>) next)
      (format err "error in background thread ~a\n~a" (current-thread) c)
      (kernel-next-thread))
    ;
    (thread-resume
     (make-thread 
      (lambda ()
	(handler-bind (<condition> bg-condition-handler)
	  (thunk)))
      "bg"))))

(define-syntax (bg . body)
  (run-in-bg
   (lambda ()
     (begin . body))))
