;;;

(define-constant $thread-state-suspend 0)
(define-constant $thread-state-waiting 1)
(define-constant $thread-state-running 2)
(define-constant $thread-state-blocked 3)
(define-constant $thread-state-sleeping 4)
(define-constant $thread-state-complete 5)

(define-constant $thread-state-names
  '#(SUSP WAIT RUN BLOCK SLEEP DONE))

(define-class <thread-group> (<object>)
  (threads type: <list> init-value: '())
  (parent-group init-value: #f))

;;; `thread-blocked-on' can be any of the following classes of object
;;; when the state is BLOCKED
;;;
;;;    <thread>              -- in `thread-join'
;;;    <semaphore>           -- in `semaphore-wait'
;;;    <queued-output-port>  -- in `fd-output-port-write-string'
;;;    <mailbox>             -- in `receive-message'
;;;
;;; also, if the state is SLEEPING, then `thread-state-blocked' is:
;;;    Event            -- in `thread-sleep'
;;;
;;; also, when the state is SUSPENDED, then any of those objects
;;; may be present as well.  When the thread is resumed, the type
;;; of object determines the new state, which is the inverse map
;;; of the above table:
;;;
;;;    thread-blocked-on     new thread-state
;;;    0                 --> WAITING
;;;    <fixnum>          --> SLEEPING   (ie, its a raw Event)
;;;    <object>          --> BLOCKED
;;;
;;; ** note that a thread may be suspended and still be present
;;;    on a queue according to how its blocked (ie, in either
;;;    a run list according to its priority, or in a <mailbox>,
;;;    <semaphore>, <queued-output-port>, or <thread> queue if it
;;;    was blocked, or in an Event object if it was sleeping)
;;;
;;;    whether or not the thread is still on the queue is indicated
;;;    by the SIGN of the suspend count.  If the suspend count is
;;;    postive (> 0), then the thread is still queued somewhere.
;;;    if the suspend count is negative, the thread has been removed
;;;    from the queue.
;;;
;;;    A thread is never SLEEPING with a negative suspend count,
;;;    because when the time goes off, the event is freed and the
;;;    thread is marked ready-to-run-when-unsuspended (ie, by
;;;    setting its thread-blocked-on to ZERO)
;;;
;;;    Likewise, a thread is never BLOCKED on a <queued-output-port>
;;;    with a negative suspend count; it works like timers, in that
;;;    it makes sense for the caller, `qout-flush', to return eventually
;;;    when the thread is resumed.
;;;

(define-class <thread> (<object>)
  (thread-state type: <fixnum> init-value: $thread-state-suspend)
  (thread-stack)
  (thread-vars)
  (thread-dynamic-state)
  (thread-time type: <interval>)
  (thread-group type: <thread-group>)
  (thread-priority type: <fixnum> init-value: 5)
  (thread-blocked-on init-value: 0) ;; dflt 0 instead of #f for event's benefit
  (thread-next-threadtime-event init-value: 0)
  (thread-joins type: <list> init-value: '())
  (internal-thread-name type: <string>)
  (thread-number type: <fixnum>)
  (thread-suspend-count type: <fixnum> init-value: -1))

;;;
;;;  the queue holds threads if `has-data?' is #f
;;;  or data elements if `has-data?' is #t
;;;

(define-class <mailbox> (<dequeue>)
  (has-data? type: <boolean> init-value: #t))

;;;
;;;  the queue holds waiting threads, and there are
;;;  |count| of them if count<0, otherwise there are 
;;;  0 of them
;;;

(define-class <semaphore> (<dequeue>)
  (count type: <fixnum> init-value: 0))

;;;

(define-class <thread-queue> (<dequeue>))
