#|------------------------------------------------------------*-Scheme-*--|
 | File:	    modules/lowscm/keywords.scm
 |
 |          Copyright (C)1998 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |	    See <http://www.rscheme.org/> for the latest info.
 |
 | File version:     1.1
 | File mod date:    1998.05.24 19:40:42
 | System build:     v0.7.3.1-b39, 1999-12-25
 | Owned by module:  low-scheme
 |
 | Purpose:          keyword list processing support procedures
 `------------------------------------------------------------------------|#

(define-class <keyword-list-malformed> (<condition>)
  kle-error-at
  kle-error-type
  kle-keyword-list)
  
(define-method display-object ((self <keyword-list-malformed>) port)
  (__format port "malformed keyword list from ~s:\n" (kle-error-at self))
  (__format port ">> ~a\n" (kle-error-type self))
  (__format port ">> list = ~#@*60s\n" (kle-keyword-list self)))

;;;
;;;  parses a list representation alternating keywords and values
;;;  into a vector suitable for vassq operations (ie, also alternating
;;;  keywords and values).
;;;
;;;  signals the error <keyword-list-malformed> if the input is not a 
;;;  proper list, the keys are not all keywords, or there is a missing
;;;  value for a keyword (ie, the list has an odd length)
;;;
;;;  doesn't terminate on a cyclic structure

(define (keyword-value-list->vector kv-list)
  (let ((q (make-dequeue)))
    (let loop ((p kv-list))
      (if (pair? p)
	  (begin
	    (if (keyword? (car p))
		(if (pair? (cdr p))
		    (begin
		      (dequeue-push-back! q (car p))
		      (dequeue-push-back! q (cadr p))
		      (loop (cddr p)))
		    (signal
		     (make <keyword-list-malformed>
			   kle-keyword-list: kv-list
			   kle-error-at: (car p)
			   kle-error-type: "missing value for keyword")))
		(signal
		 (make <keyword-list-malformed>
		       kle-keyword-list: kv-list
		       kle-error-at: (car p)
		       kle-error-type: "key element not a keyword"))))
	  (if (null? p)
	      (dequeue-state q)
	      (signal
	       (make <keyword-list-malformed>
		     kle-keyword-list: kv-list
		     kle-error-at: #f
		     kle-error-type: "not a proper list")))))))


;;;
;;;  construct a list of "remainder" keyword/values, where the "used"
;;;  entries have a key of #f
;;;

(define (remainder->list (v <vector>))
  (let loop ((r '())
	     ((k <fixnum>) (gvec-length v)))
    (if (eq? k 0)
	r
	(let (((i <fixnum>) (fixnum- k 2)))
	  (loop (if (vector-ref v i)
		    (cons* (vector-ref v i)
			   (vector-ref v (add1 i))
			   r)
		    r)
		i)))))

;;;  look up the given keyword (`kwd') in the given 
;;;  keyword/value vector (`v') and invoke the `found-proc'
;;;  with the associated value if present (after clobbering
;;;  all occurrences of the key in the vector with #f).  If
;;;  not present, invoke the `notfound-proc' with no arguments.

(define (using-keyword-value kwd (v <vector>) found-proc notfound-proc)
  (let ((i (vassq kwd v)))
    (if (fixnum? i)
	(let ((a (gvec-ref v i)))
	  (let loop ((i i))
	    (if (fixnum? i)
		(begin
		  (gvec-set! v (sub1 i) #f)
		  (loop (vassq kwd v)))
		(found-proc a))))
	(notfound-proc))))

(define (get-keyword-value (kvv <vector>) keyword default)
  (using-keyword-value
   keyword
   kvv
   (lambda (item)
     item)
   (lambda ()
     default)))

;;;  check to make sure all the keywords in the given 
;;;  keyword-value vector have been consumed by the
;;;  keyword processor

(define (check-all-keywords-used (v <vector>) fn-name)
  (let loop (((i <fixnum>) 0))
    (if (eq? i (vector-length v))
	(values)
	(if (vector-ref v i)
	    (some-keywords-not-used v fn-name)
	    (loop (fixnum+ i 2))))))

(define (some-keywords-not-used (v <vector>) fn-name)
  (let loop (((i <fixnum>) 0)
	     (r '()))
    (if (eq? i (vector-length v))
	(error "~s: excess keywords supplied: ~j" fn-name (reverse r))
	(if (vector-ref v i)
	    (loop (fixnum+ i 2) (cons (vector-ref v i) r))
	    (loop (fixnum+ i 2))))))
