/*
 * SHMAIN.C - the function main which when loaded with the SCHEME library
 *          - package gives a working Scheme
 *
 * Source Version: 4.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "scheme.h"

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MAIN - a fairly vanilla place to start up a Scheme */

int main(argc, argv)
   int argc;
   char **argv;
   {char command[MAXLINE];
    int i, load_sch = 0;
    int runt_flag = TRUE;
    int command_flag = FALSE;

    SC_init("ABORT: Gross Initialization Error", (PFByte) SS_end_scheme,
            TRUE, SS_interrupt_handler,
            TRUE, NULL, 0);

#ifdef MAC
    runt_flag = FALSE;

/* connect the I/O functions */
    PG_open_console("PACT Scheme", "MONOCHROME", 1, 0.1, 0.1, 0.8, 0.8);

#endif

/* process the command line arguments */
    for (i = 1; i < argc; i++)
        if (argv[i][0] == '-')
           {switch (argv[i][1])
               {case 'l' : load_sch = ++i;              /* load Scheme file */
                           break;
                case 'r' : runt_flag = FALSE;     /* don't load full Scheme */
                           break;};}
        else
           {command_flag = TRUE;
            strcpy(command, " ");
            for ( ; i < argc; i++)
                {strcat(command, argv[i]);
                 strcat(command, " ");};};

/* Initialize the Scheme system */
    SS_init_scheme(CODE, VERSION);

/* load the full Scheme */
    if (runt_flag)
       SS_load_scm("runt.scm");

/* read the optionally specified load file */ 
    if (load_sch != 0)
       SS_load_scm(argv[load_sch]);

    SS_nsave    = 0;
    SS_nrestore = 0;
    SS_nsetc    = 0;
    SS_ngoc     = 0;

    SC_mem_stats_set(0L, 0L);

/* this is where interface special variables are initialized */
/*
    SS_pr_ch_in  = SS_get_ch;
    SS_pr_ch_un  = SS_unget_ch;
    SS_pr_ch_out = SS_put_ch;
*/

    if (command_flag)
       {int ret;

        PRINT(STDOUT, "\n\n");
	ret = SS_run(command);
	PRINT(STDOUT, "\n\n");
	return(!ret);}
    else
       {SC_banner("");
        SS_repl();};

    return(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
