/*
 * PCBIN.C - binary IO for PPC
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "ppc.h"

#define N_TYPES 7

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_PR_FLUSH - flush function to hang on the io_flush_hook */

int _PC_pr_flush(fp)
   FILE *fp;
   {PROCESS *pp;

    pp = (PROCESS *) fp;
    PC_flush(pp);

    return(FALSE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_PR_TELL - a no-op tell to hang on the io_tell_hook */

off_t _PC_pr_tell(fp)
   FILE *fp;
   {return((off_t)0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_PR_SEEK - a no-op seek to hang on the io_seek_hook */

int _PC_pr_seek(stream, offset, whence)
   FILE *stream;
   off_t offset;
   int whence;
   {return(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_PR_READ_A - a read function to hang on the io_read_hook sometimes */

size_t _PC_pr_read_a(ptr, size, nitems, pp)
   byte *ptr;
   size_t size, nitems;
   PROCESS *pp;
   {char *s;

    s = PC_gets(ptr, size*nitems, pp);

    if (s != NULL)
       PRINT(stdout, "| %s", s);

    return(s == NULL ? 0 : strlen(s));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_PR_READ_B - a read function to hang on the io_read_hook sometimes */

size_t _PC_pr_read_b(ptr, size, nitems, pp)
   byte *ptr;
   size_t size, nitems;
   PROCESS *pp;
   {unsigned char *cp;
    long ni;
    size_t len;

    len = size*nitems;
    cp  = (unsigned char *) ptr;

/* vacuum anything left in the PROCESS ring into the buffer */

/* copy the output to the buffer */
    ni = _PC_buffer_out((char *) cp, pp, len, TRUE);

    len -= ni;
    cp  += ni;

    while (TRUE)
       {ni = read(pp->in, (char *) cp, len);
	if (ni < 0)
	    continue;

/* if not enough note what has come and get some more */
        if (ni < len)
           {len -= ni;
            cp  += ni;}

/* buffer up anything left over */
        else if (ni > len)
           {cp += len;
            ni -= len;
            _PC_buffer_in((char *) cp, ni, pp);
            break;}

/* if right on quit while ahead */
        else
           break;};

    return(nitems);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_PR_WRITE - a write function to hang on the io_write_hook */

size_t _PC_pr_write(ptr, size, nitems, pp)
   byte *ptr;
   size_t size, nitems;
   PROCESS *pp;
   {size_t ni, len;

    len = size*nitems;
    ni  = write(pp->out, ptr, len);

    return(ni/size);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_RECV_FORMATS - receive binary formats from the given PROCESS */

int PC_recv_formats(pp)
   PROCESS *pp;
   {long nc;
    char s[LRG_TXT_BUFFER+2];

    PC_ERR_TRAP(FALSE);

    PC_block(pp);
    PC_set_attr(pp, PC_LINE, TRUE);

    for (nc = 0; nc < LRG_TXT_BUFFER; nc = strlen(s))
       {if (PC_status(pp) != RUNNING)
           PC_error("PROCESS NOT RUNNING %d %d - PC_RECV_FORMATS",
                    pp->status, pp->reason);

        PC_gets(s+nc, MAXLINE, pp);
        if (strcmp(s+nc, "END FORMATS\n") == 0)
           break;};

    _PD_rd_prim_extras(pp->vif, ' ', '\f', s);

    PC_unblock(pp);

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_SEND_FORMATS - send binary formats to the parent PROCESS connected
 *                 - to standard in and out
 */

int PC_send_formats()
   {PFSize_t writeh;
    PFInt flushh;
    FILE *fp;
    char *_PD_tbuffer;

    fp = stdout;

    fflush(fp);
    SC_setbuf(fp, NULL);

/* remember the I/O hooks */
    writeh = io_write_hook;
    flushh = io_flush_hook;

/* reset the I/O hooks */
    io_write_hook = (PFSize_t) fwrite;
    io_flush_hook = (PFInt) fflush;

    if ((PC_terminal == NULL) || (PC_terminal->vif == NULL))
       {io_write_hook = writeh;
	io_flush_hook = flushh;
        return(FALSE);};

    _PD_wr_prim_extras(fp, PC_terminal->vif->chart, ' ', '\f');
    _PD_tbuffer = _PD_get_tbuffer();
    io_write(_PD_tbuffer, 1, strlen(_PD_tbuffer), fp);
    io_flush(fp);
    SFREE(_PD_tbuffer);

/* restore the I/O hooks */
    io_write_hook = writeh;
    io_flush_hook = flushh;

    PRINT(fp, "END FORMATS\n");

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_BIN_READ - do binary read from a PROCESS */

int _PC_bin_read(ptr, type, nitems, pp)
   byte *ptr;
   char *type;
   size_t nitems;
   PROCESS *pp;
   {PDBfile *file;
    int ni;
    syment *ep;
    PFfflush flushh;
    PFfseek seekh;
    PFftell tellh;
    PFfread readh;
#ifdef HAVE_THREADS
    PFfflush pflushh;
    PFfseek pseekh;
    PFftell ptellh;
    PFfread preadh;
#endif
    SC_THREAD_ID(_t_index);

    file = pp->vif;

    switch (setjmp(_PD_READ_ERR(_t_index)))
       {case ABORT    : return(FALSE);
        case ERR_FREE : return(TRUE);
        default       : memset(PD_err, 0, MAXLINE);
                        break;};

    ep = _PD_mk_syment(type, nitems, 0L, NULL, NULL);

/* remember the I/O hooks */
    flushh = io_flush_hook;
    tellh  = io_tell_hook;
    seekh  = io_seek_hook;
    readh  = io_read_hook;

/* reset the I/O hooks */
    io_flush_hook = (PFfflush) _PC_pr_flush;
    io_tell_hook  = (PFftell) _PC_pr_tell;
    io_seek_hook  = (PFfseek) _PC_pr_seek;
    io_read_hook  = (PFfread) _PC_pr_read_b;

#ifdef HAVE_THREADS
    pflushh = PIO_FLUSH_HOOK(_t_index);
    ptellh  = PIO_TELL_HOOK(_t_index);
    pseekh  = PIO_SEEK_HOOK(_t_index);
    preadh  = PIO_READ_HOOK(_t_index);
    PIO_FLUSH_HOOK(_t_index) = (PFfflush) _PC_pr_flush;
    PIO_TELL_HOOK(_t_index)  = (PFftell) _PC_pr_tell;
    PIO_SEEK_HOOK(_t_index)  = (PFfseek) _PC_pr_seek;
    PIO_READ_HOOK(_t_index)  = (PFfread) _PC_pr_read_b;
#endif

    ni = _PD_rd_syment(file, ep, type, ptr);

    _PD_rl_syment(ep);

/* restore the I/O hooks */
    io_flush_hook = flushh;
    io_tell_hook  = tellh;
    io_read_hook  = readh;
    io_seek_hook  = seekh;

#ifdef HAVE_THREADS
    PIO_FLUSH_HOOK(_t_index) = pflushh;
    PIO_TELL_HOOK(_t_index)  = ptellh;
    PIO_SEEK_HOOK(_t_index)  = pseekh;
    PIO_READ_HOOK(_t_index)  = preadh;
#endif

    return((int) ni);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_BIN_WRITE - do binary write to a PROCESS */

int _PC_bin_write(ptr, type, nitems, pp)
   byte *ptr;
   char *type;
   size_t nitems;
   PROCESS *pp;
   {PDBfile *file;
    int ni;
    PFfflush flushh;
    PFfseek seekh;
    PFftell tellh;
    PFfwrite writeh;

#ifdef HAVE_THREADS
    PFfflush pflushh;
    PFfseek pseekh;
    PFftell ptellh;
    PFfwrite pwriteh;
#endif

    SC_THREAD_ID(_t_index);

    file = pp->vif;

    switch (setjmp(_PD_WRITE_ERR(_t_index)))
       {case ABORT :
	     return(FALSE);
        case ERR_FREE :
	     return(TRUE);
        default :
	     memset(PD_err, 0, MAXLINE);
	     break;};

/* remember the I/O hooks */
    flushh = io_flush_hook;
    tellh  = io_tell_hook;
    seekh  = io_seek_hook;
    writeh = io_write_hook;

/* reset the I/O hooks */
    io_flush_hook = (PFfflush) _PC_pr_flush;
    io_tell_hook  = (PFftell) _PC_pr_tell;
    io_seek_hook  = (PFfseek) _PC_pr_seek;
    io_write_hook = (PFfwrite) _PC_pr_write;

#ifdef HAVE_THREADS
    pflushh = PIO_FLUSH_HOOK(_t_index);
    ptellh  = PIO_TELL_HOOK(_t_index);
    pseekh  = PIO_SEEK_HOOK(_t_index);
    pwriteh = PIO_WRITE_HOOK(_t_index);

    PIO_FLUSH_HOOK(_t_index) = (PFfflush) _PC_pr_flush;
    PIO_TELL_HOOK(_t_index)  = (PFftell) _PC_pr_tell;
    PIO_SEEK_HOOK(_t_index)  = (PFfseek) _PC_pr_seek;
    PIO_WRITE_HOOK(_t_index) = (PFfread) _PC_pr_write;
#endif

    ni = _PD_wr_syment(file, ptr, nitems, type, type);

/* restore the I/O hooks */
    io_flush_hook = flushh;
    io_tell_hook  = tellh;
    io_write_hook = writeh;
    io_seek_hook  = seekh;

#ifdef HAVE_THREADS
    PIO_FLUSH_HOOK(_t_index) = pflushh;
    PIO_TELL_HOOK(_t_index)  = ptellh;
    PIO_SEEK_HOOK(_t_index)  = pseekh;
    PIO_WRITE_HOOK(_t_index) = pwriteh;
#endif

    return(ni);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
