/*
 * PGS.H - header in support of Portable Graphics System
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#ifndef PCK_PGS

#include "cpyright.h"

#define PCK_PGS                               /* graphics package resident */

#ifdef X11R5
# define X11R4
# define __sys_stdtypes_h
#endif

#define PGS_TOL 1.0e-10

/* Think C compiler defines THINK_C; CodeWarrior defines __MWERKS__ */

#ifdef THINK_C

# include "score.h"
# include "pml.h"
# include "ppc.h"

#else

# ifdef __MWERKS__

#  include "score.h"
#  include "pml.h"
#  include "ppc.h"

# endif

#endif

#ifdef MAC

# define HAVE_WINDOW_DEVICE
# define MAC_COLOR
# define PACT_INCLUDES

# include <Controls.h>
# include <Dialogs.h>
# include <Menus.h>
# include <Devices.h>
# include <Events.h>
# include <Fonts.h>
# include <Menus.h>
# include <Palettes.h>
# include <Scrap.h>
# include <TextEdit.h>
# include <ToolUtils.h>

#endif

#ifndef PACT_INCLUDES

# include <score.h>
# include <pml.h>
# include <ppc.h>

#endif

#undef PACT_INCLUDES

#ifdef USE_OGL
# ifndef X11R4
#  define X11R4
# endif
# undef SIZEOF
# include <GL/glx.h>
# include <GL/gl.h>
# undef SIZEOF
# define SIZEOF (*SC_sizeof_hook)
#endif

#ifdef BGI
# include <graphics.h>
# include <dos.h>
# define HAVE_WINDOW_DEVICE
#endif

#ifdef MSC
#ifndef NO_WINDOWS
# include <graph.h>
# define HAVE_WINDOW_DEVICE
#endif
# include <dos.h>
#endif

#ifdef USE_SUNCORE
# undef OFF
# include <usercore.h>
# define HAVE_WINDOW_DEVICE
#endif

#ifdef X11R4
# ifdef LINUX
#  undef SYSV
# endif
# include <X11/Xlib.h>
# include <X11/X.h>
# include <X11/Xutil.h>
# include <X11/cursorfont.h>
# ifdef LINUX
#  define SYSV
# endif
# define HAVE_WINDOW_DEVICE
#endif

#ifdef USE_GL
# include <gl/gl.h>
# include <gl/device.h>
# undef BLACK
# undef WHITE
# undef RED
# undef GREEN
# undef BLUE
# undef MAGENTA
# undef CYAN
# undef YELLOW
# define HAVE_WINDOW_DEVICE
#endif

#include "gscgm.h"

/*--------------------------------------------------------------------------*/

/*                            DEFINED CONSTANTS                             */

/*--------------------------------------------------------------------------*/

#define LEFT    0
#define RIGHT   1
#define CENTER  2

#define MORE_WINDOW       -1
#define SCROLLING_WINDOW  -2
#define TEXT_INSERT       -3
#define TEXT_OVERWRITE    -4

#define WORLDC  1
#define NORMC   2
#define PIXELC  3

#define MOUSE_LEFT    1
#define MOUSE_MIDDLE  2
#define MOUSE_RIGHT   4

#define KEY_SHIFT    0x10
#define KEY_CNTL     0x20
#define KEY_ALT      0x40
#define KEY_LOCK     0x80

#define MOUSE_SOFTWARE 0
#define MOUSE_HARDWARE 1

#define N_COLORS 16
#define N_IOB_FLAGS 3

#define QUAD_ONE   1
#define QUAD_FOUR  4

#define N_ANGLES  180
#define DEGREE     1
#define RADIAN     2

#define HORIZONTAL    -10
#define VERTICAL      -11

#define PORTRAIT_MODE   10
#define LANDSCAPE_MODE  11

#define TXSPAN 80.0

#define TEXT_WINDOW_DEVICE    128            /* MAC requires to distinguish */
#define GRAPHIC_WINDOW_DEVICE 129                /* X Window and MAC Window */
#define PS_DEVICE             130                             /* PostScript */
#define CGMF_DEVICE           131                                    /* CGM */
#define HARD_COPY_DEVICE      132                    /* undifferentiated HC */
#define RASTER_DEVICE         133                          /* RASTER device */

#define GS_COPY 3
#define GS_XOR  6

#define LINE_SOLID          1
#define LINE_DASHED         2
#define LINE_DOTTED         3
#define LINE_DOTDASHED      4

#define AXIS_LINESTYLE      1
#define AXIS_LINETHICK      2
#define AXIS_LINECOLOR      3
#define AXIS_LABELCOLOR     4
#define AXIS_LABELSIZE      5
#define AXIS_LABELFONT      6
#define AXIS_LABELPREC      7
#define AXIS_X_FORMAT       8
#define AXIS_Y_FORMAT       9
#define AXIS_TICKSIZE      10
#define AXIS_GRID_ON       11
#define AXIS_SIGNIF_DIGIT  12
#define AXIS_CHAR_ANGLE    13

#define MAJOR                  '\001'
#define MINOR                  '\002'
#define LABEL                  '\003'
#define MAJOR_MINOR            '\004'
#define MAJOR_LABEL            '\005'
#define MINOR_LABEL            '\006'
#define MAJOR_MINOR_LABEL      '\007'
#define NO_TICKS               '\010'

#define RIGHT_OF_AXIS          '\011'
#define LEFT_OF_AXIS           '\012'
#define STRADDLE_AXIS          '\013'
#define ENDS                   '\014'
#define NOTHING_ON_AXIS        '\015'

#define GRID_LINESTYLE      1
#define GRID_LINETHICK      2
#define GRID_LINECOLOR      3
#define GRID_LABELCOLOR     4
#define GRID_LABELSIZE      5
#define GRID_LABELFONT      6
#define GRID_LABELPREC      7
#define GRID_XFORMAT        8
#define GRID_YFORMAT        9
#define GRID_TICKPOSITION  10
#define GRID_TICKSIZE      11
#define GRID_TICKTYPE      12
#define GRID_SIGNIF_DIGIT  13

#define VEC_SCALE           1
#define VEC_ANGLE           2
#define VEC_HEADSIZE        3
#define VEC_FIXSIZE         4
#define VEC_MAXSIZE         5
#define VEC_LINESTYLE       6
#define VEC_LINETHICK       7
#define VEC_COLOR           8
#define VEC_FIXHEAD         9

#define CLEAR_SCREEN       -5
#define CLEAR_VIEWPORT     -6
#define CLEAR_FRAME        -7

#define NOTICKS             0
#define INSIDE              1
#define OUTSIDE             2
#define INOUT               3
#define TICKTICK            1
#define LINELINE            2
#define TICKLINE            3
#define LINETICK            4

#define CARTESIAN          -1
#define POLAR              -2
#define INSEL              -3
#define HISTOGRAM          -4
#define SCATTER            -5
#define LOGICAL            -6
#define ERROR_BAR          -7
#define CARTESIAN_3D       -8

#define PG_TEXT             1
#define PG_FILL             2
#define PG_LINE             3

#define PLOT_CURVE         10
#define PLOT_CONTOUR       11
#define PLOT_IMAGE         12
#define PLOT_WIRE_MESH     13
#define PLOT_SURFACE       14
#define PLOT_VECTOR        15
#define PLOT_FILL_POLY     16
#define PLOT_MESH          17
#define PLOT_ERROR_BAR     18
#define PLOT_SCATTER       19
#define PLOT_DV_BND        20
#define PLOT_DEFAULT       21

#define PG_IMAGE_VERSION 0

#ifdef MAC

# ifdef THINK_C
#  define SCREEN_BITS   screenBits
#  define THE_PORT      thePort
#  define THE_ARROW     arrow
#  define C_STR_PASCAL  CtoPstr
# endif

# ifdef __MWERKS__
#  define SCREEN_BITS   qd.screenBits
#  define THE_PORT      qd.thePort
#  define THE_ARROW     qd.arrow
#  define C_STR_PASCAL  CtoPstr
# endif

# ifdef MPW
#  define SCREEN_BITS   qd.screenBits
#  define THE_PORT      qd.thePort
#  define THE_ARROW     qd.arrow
#  define C_STR_PASCAL  _PG_c_str_pascal
# endif

# define appleID            128                    /* This is a resource ID */
# define fileID             129                    /* This is a resource ID */
# define editID             130                    /* This is a resource ID */
# define fontID               5                    /* This is a resource ID */
# define sizeID             131                    /* This is a resource ID */

# define appleMenu        0                      /* MyMenus[] array indexes */
# define fileMenu         1
# define editMenu         2
# define fontMenu         3
# define sizeMenu         4
# define menuCount        5

# define DEFAULT_FONT_SIZE  12
# define MIN_FONT_SIZE       8
# define MENU_HEIGHT        19

/* items in appleMenu */
# define aboutMeCommand   1

/* items in fileMenu */
# define quitCommand      1

/* items in editMenu */
# define undoCommand      1
# define cutCommand       3
# define copyCommand      4
# define pasteCommand     5
# define clearCommand     6

/* items in sizeMenu */
# define Point6         1
# define Point8         2
# define Point10        3
# define Point12        4
# define Point16        5
# define Point20        6
# define Point24        7

/* For the one and only text window */
# define windowID       128

/* For the About Sample... DLOG */
# define aboutMeDLOG        128
# define okButton           1
# define authorItem         2                               /* For SetDialogItemText */
# define languageItem       3                               /* For SetDialogItemText */
# define versionItem        4                               /* For SetDialogItemText */

# define KEY_DOWN_EVENT     keyDown
# define KEY_UP_EVENT       keyUp
# define MOUSE_DOWN_EVENT   mouseDown
# define MOUSE_UP_EVENT     mouseUp
# define UPDATE_EVENT       updateEvt
# define EXPOSE_EVENT       activateEvt
# define MOTION_EVENT       100

# define MAXPIX 65535

#endif

#ifndef USE_SUNCORE
# define STICK                 0
# define SOLID                 1
#endif

#define TEXT_CHARACTER_PRECISION   1

/* Microsoft Graphics Constants */

#ifdef DOS

# ifdef MSC

#  define LOW_RES_CGA       _MRES4COLOR
#  define HI_RES_CGA        _MRES4COLOR
#  define HI_RES_EGA        _ERESCOLOR
#  define HI_RES_VGA        _VRES16COLOR
#  define HI_RES_EGA_MONO   _ERESNOCOLOR

# endif

# define MAXPIX 63

/* mouse related stuff */
# define CALL_MDD int86(0x33, &inreg, &outreg)

#endif

/* Something for the real world */

#ifndef LOW_RES_CGA
# define LOW_RES_CGA       0
# define HI_RES_CGA        1
# define HI_RES_EGA        2
# define HI_RES_VGA        3
# define HI_RES_EGA_MONO   4
#endif

/* X Windows Constants */

#ifdef X11R4

# define tie_fighter_width 16
# define tie_fighter_height 16
 
# define star_width 16
# define star_height 16
# define star_x_hot 7
# define star_y_hot 7
 
# define KEY_DOWN_EVENT     KeyPress
# define KEY_UP_EVENT       KeyRelease
# define MOUSE_DOWN_EVENT   ButtonPress
# define MOUSE_UP_EVENT     ButtonRelease
# define UPDATE_EVENT       ConfigureNotify
# define EXPOSE_EVENT       Expose
# define MOTION_EVENT       MotionNotify

# define MAXPIX 65535

#endif

/* GL Constants */

#ifdef USE_GL

# define KEY_DOWN_EVENT     1
# define KEY_UP_EVENT       2
# define MOUSE_DOWN_EVENT   3
# define MOUSE_UP_EVENT     4
# define UPDATE_EVENT       5
# define EXPOSE_EVENT       6 
# define MOTION_EVENT       7

# define MAXPIX 255

#endif

#ifndef MAXPIX
# define MAXPIX 1
#endif

/* language bindings for event handlers */

# define _C_LANG       1
# define _FORTRAN_LANG 2

/*--------------------------------------------------------------------------*/

/*                            PROCEDURAL MACROS                             */

/*--------------------------------------------------------------------------*/

/* COLOR_POSTSCRIPT_DEVICE - TRUE iff dev is a color PostScript device */

#define COLOR_POSTSCRIPT_DEVICE(dev)                                         \
    (dev->ps_color == TRUE)

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* POSTSCRIPT_DEVICE - TRUE iff dev is a PostScript device */

#define POSTSCRIPT_DEVICE(dev) (dev->type_index == PS_DEVICE)

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* CGM_DEVICE - TRUE iff dev is a CGM device */

#define CGM_DEVICE(dev) (dev->type_index == CGMF_DEVICE)

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* HARDCOPY_DEVICE - TRUE iff dev is a hard copy device */

#define HARDCOPY_DEVICE(dev) (dev->hard_copy_device)

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* WTOS - converts x and y from world coordinates to screen coordinates */

#define WtoS(dev, x, y)                                                      \
   {x = dev->axw_s + dev->bxw_s*x;                                           \
    y = dev->ayw_s + dev->byw_s*y;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* STOW - converts x and y from screen coordinates to world coordinates */

#define StoW(dev, x, y)                                                      \
   {x = dev->axs_w + dev->bxs_w*x;                                           \
    y = dev->ays_w + dev->bys_w*y;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* STOP - converts x and y from NDC/Screen coordinates to pixel coordinates */

#ifdef CRAY                        /* try to compensate for cray arithmetic */

#define StoP(dev, x, y, ix, iy)                                              \
   {int pcxmin, pcxmax, pcymin, pcymax;                                      \
    pcxmin = dev->min_pc_x;                                                  \
    pcxmax = dev->max_pc_x;                                                  \
    pcymin = dev->min_pc_y;                                                  \
    pcymax = dev->max_pc_y;                                                  \
    switch (dev->quadrant)                                                   \
       {case QUAD_ONE :                                                      \
	     ix = floor(x*dev->window_width + 0.50001) +                     \
                  dev->window_x_off;                                         \
	     iy = floor(y*dev->window_height + 0.50001) +                    \
                  dev->window_y_off;                                         \
             break;                                                          \
        case QUAD_FOUR :                                                     \
	     ix = floor(x*dev->window_width + 0.50001) +                     \
                  dev->window_x_off;                                         \
             iy = floor((1.0 - y)*dev->window_height + 0.50001) +            \
                  dev->window_y_off;                                         \
             break;};                                                        \
    ix = (ix < pcxmin) ? pcxmin : ix;                                        \
    ix = (ix > pcxmax) ? pcxmax : ix;                                        \
    iy = (iy < pcymin) ? pcymin : iy;                                        \
    iy = (iy > pcymax) ? pcymax : iy;}

#else

#define StoP(dev, x, y, ix, iy)                                              \
   {int pcxmin, pcxmax, pcymin, pcymax;                                      \
    pcxmin = dev->min_pc_x;                                                  \
    pcxmax = dev->max_pc_x;                                                  \
    pcymin = dev->min_pc_y;                                                  \
    pcymax = dev->max_pc_y;                                                  \
    switch (dev->quadrant)                                                   \
       {case QUAD_ONE :                                                      \
	     ix = floor(x*dev->window_width + 0.5) +                         \
                  dev->window_x_off;                                         \
	     iy = floor(y*dev->window_height + 0.5) +                        \
                  dev->window_y_off;                                         \
             break;                                                          \
        case QUAD_FOUR :                                                     \
	     ix = floor(x*dev->window_width + 0.5) +                         \
                  dev->window_x_off;                                         \
             iy = floor((1.0 - y)*dev->window_height + 0.5) +                \
                  dev->window_y_off;                                         \
             break;};                                                        \
    ix = (ix < pcxmin) ? pcxmin : ix;                                        \
    ix = (ix > pcxmax) ? pcxmax : ix;                                        \
    iy = (iy < pcymin) ? pcymin : iy;                                        \
    iy = (iy > pcymax) ? pcymax : iy;}

#endif

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* PTOS - converts x and y from pixel coordinates to NDC/Screen coordinates */

#define PtoS(dev, ix, iy, x, y)                                              \
   {switch (dev->quadrant)                                                   \
       {case QUAD_ONE  : x = (ix - dev->window_x_off)/dev->window_width;     \
                         y = (iy - dev->window_y_off)/dev->window_height;    \
                         break;                                              \
        case QUAD_FOUR : x = (ix - dev->window_x_off)/dev->window_width;     \
                         y = 1.0 - (iy - dev->window_y_off)/                 \
                                         dev->window_height;                 \
                         break;};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* COLOR_MAP - set up values for the 16 most common colors (EGA, CGA, MONO) */

#define Color_Map(dev, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)       \
    dev->BLACK        = a;                                                   \
    dev->WHITE        = b;                                                   \
    dev->GRAY         = c;                                                   \
    dev->DARK_GRAY    = d;                                                   \
    dev->BLUE         = e;                                                   \
    dev->GREEN        = f;                                                   \
    dev->CYAN         = g;                                                   \
    dev->RED          = h;                                                   \
    dev->MAGENTA      = i;                                                   \
    dev->BROWN        = j;                                                   \
    dev->DARK_BLUE    = k;                                                   \
    dev->DARK_GREEN   = l;                                                   \
    dev->DARK_CYAN    = m;                                                   \
    dev->DARK_RED     = n;                                                   \
    dev->YELLOW       = o;                                                   \
    dev->DARK_MAGENTA = p

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_CALL_HANDLER - call the registered event handler with language        */
/*                   appropriate arguments.                                 */

#define PG_CALL_HANDLER(hndler, dvice, evnt)                                 \
   {FIXNUM fdvice, fevnt;                                                    \
    if ((hndler).lang == _C_LANG)                                            \
       {(*(hndler).fnc)(dvice, &evnt);}                                      \
    else if ((hndler).lang == _FORTRAN_LANG)                                 \
       {fdvice = SC_GET_INDEX(dvice);                                        \
        fevnt  = SC_ADD_POINTER(&evnt);                                      \
        (*(hndler).fnc) (&fdvice, &fevnt);}}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_ADJUST_LIMITS_3D - adjust limits for 3d plots and axes */

#define PG_ADJUST_LIMITS_3D(xmn, xmx, ymn, ymx, zmn, zmx)                    \
    {REAL dx, dy, dz;                                                        \
     dx = (xmx - xmn)*TOLERANCE;                                             \
     dy = (ymx - ymn)*TOLERANCE;                                             \
     dz = (zmx - zmn)*TOLERANCE;                                             \
     xmn -= dx;                                                              \
     xmx += dx;                                                              \
     ymn -= dy;                                                              \
     ymx += dy;                                                              \
     zmn -= dz;                                                              \
     zmx += dz;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_SET_WITH_CLIP - gather simple clipping info while copying points */

#define PG_SET_WITH_CLIP_INIT(_ok, _os)                                      \
   {_ok = FALSE;                                                             \
    _os = -2;}

#define PG_SET_WITH_CLIP(_xo, _xi, _ok, _os, _mn, _mx)                       \
   {int _s;                                                                  \
    REAL _v;                                                                 \
    _v = _xi;                                                                \
    if (!_ok)                                                                \
       {if (_v < _mn)                                                        \
	   _s = -1;                                                          \
        else if (_mx < _v)                                                   \
	   _s = 1;                                                           \
	else                                                                 \
	   _s = 0;                                                           \
	_ok |= ((_s == 0) || ((_os != -2) && (_s != _os)));                  \
	_os  = _s;};                                                         \
    _xo = _v;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* LR_MAPPING_INFO - extract info for Logical-Rectangular mappings */

#define LR_MAPPING_INFO(alst, npts)                                          \
   {emap   = NULL;                                                           \
    SC_assoc_info(alst,                                                      \
		  "EXISTENCE", &emap,                                        \
		  NULL);                                                     \
    eflag  = (emap == NULL);                                                 \
    if (eflag)                                                               \
       {emap = FMAKE_N(char, npts, "LR_MAPPING_INFO:emap");                  \
	memset(emap, 1, npts);};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_PUSH_CHILD_IOB - add a child interface object to a parent's list */

#define PG_PUSH_CHILD_IOB(par, chld)                                         \
   {PG_interface_object *piob;                                               \
    piob = (par);                                                            \
    SC_REMEMBER(PG_interface_object *, chld, piob->children,                 \
                piob->n_children, piob->max_children, 10);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#ifdef DOS
# ifdef BGI
#  define PG_MOVE_TO       moveto
#  define PG_LINE_TO       lineto
#  define PG_OUT_TEXT(x)   outtext((unsigned char *) x)
#  define PG_SET_COLOR(x)  setcolor(x)
# endif

# ifdef MSC
#  define PG_MOVE_TO       _moveto
#  define PG_LINE_TO       _lineto
#  define PG_OUT_TEXT(x)   _outgtext((unsigned char *) x)
#  define PG_SET_COLOR(x)  _setcolor((short) (x))
# endif

#endif

#ifdef X11R4

# define PG_EVENT_TYPE(ev) (ev).type

# define PG_MOUSE_EVENT_INFO(dev, ev, ex, ey, eb, eq)                       \
    {int et;                                                                \
     ex = (ev)->xbutton.x;                                                  \
     ey = (ev)->xbutton.y;                                                  \
     switch ((ev)->xbutton.button)                                          \
        {case 1 : eb = MOUSE_LEFT;                                          \
                  break;                                                    \
         case 2 : eb = MOUSE_MIDDLE;                                        \
                  break;                                                    \
	 case 3 : eb = MOUSE_RIGHT;                                         \
                  break;};                                                  \
     et = (ev)->xbutton.state;                                              \
     eq  = (et & 1) ? KEY_SHIFT : 0;                                        \
     eq |= (et & 2) ? KEY_LOCK  : 0;                                        \
     eq |= (et & 4) ? KEY_CNTL  : 0;                                        \
     eq |= (et & 8) ? KEY_ALT   : 0;}

# define PG_KEY_EVENT_INFO(dev, ev, ex, ey, bf, n, eq)                      \
    {int et;                                                                \
     KeySym key;                                                            \
     XComposeStatus stat;                                                   \
     XLookupString(&((ev)->xkey), bf, n, &key, &stat);                      \
     ex = (ev)->xkey.x;                                                     \
     ey = (ev)->xkey.y;                                                     \
     et = (ev)->xkey.state;                                                 \
     eq  = (et & 1) ? KEY_SHIFT : 0;                                        \
     eq |= (et & 2) ? KEY_LOCK  : 0;                                        \
     eq |= (et & 4) ? KEY_CNTL  : 0;                                        \
     eq |= (et & 8) ? KEY_ALT   : 0;}

#endif

#ifdef USE_GL

# define PG_EVENT_TYPE(ev) (ev).type

# define PG_MOUSE_EVENT_INFO(dev, ev, ex, ey, eb, eq)                       \
    {int et;                                                                \
     ex = (ev)->x;                                                          \
     ey = (ev)->y;                                                          \
     switch ((ev)->btn)                                                     \
        {case 1 : eb = MOUSE_LEFT;                                          \
                  break;                                                    \
         case 2 : eb = MOUSE_MIDDLE;                                        \
                  break;                                                    \
	 case 3 : eb = MOUSE_RIGHT;                                         \
                  break;};                                                  \
     et = (ev)->mod;                                                        \
     eq  = (et & 1) ? KEY_SHIFT : 0;                                        \
     eq |= (et & 2) ? KEY_LOCK  : 0;                                        \
     eq |= (et & 4) ? KEY_CNTL  : 0;                                        \
     eq |= (et & 8) ? KEY_ALT   : 0;}

# define PG_KEY_EVENT_INFO(dev, ev, ex, ey, bf, n, eq)                      \
    {int et;                                                                \
     bf[0] = (ev)->btn;                                                     \
     ex = (ev)->x;                                                          \
     ey = (ev)->y;                                                          \
     et = (ev)->mod;                                                        \
     eq  = (et & 1) ? KEY_SHIFT : 0;                                        \
     eq |= (et & 2) ? KEY_LOCK  : 0;                                        \
     eq |= (et & 4) ? KEY_CNTL  : 0;                                        \
     eq |= (et & 8) ? KEY_ALT   : 0;}

#endif

#ifdef MAC

# define PG_EVENT_TYPE(ev) (ev).type

# define PG_MOUSE_EVENT_INFO(dev, ev, ex, ey, eb, eq)                       \
    {int et;                                                                \
     EventRecord sys;                                                       \
     sys = ev->sys_event;                                                   \
     ex = sys.where.h - dev->window_x;                                      \
     ey = sys.where.v - dev->window_y;                                      \
     eb = sys.what;                                                         \
     et = sys.modifiers;                                                    \
     eq  = (et & 0x0200) ? KEY_SHIFT : 0;                                   \
     eq |= (et & 0x0400) ? KEY_LOCK  : 0;                                   \
     eq |= (et & 0x1000) ? KEY_CNTL  : 0;                                   \
     eq |= (et & 0x0800) ? KEY_ALT   : 0;}

# define PG_KEY_EVENT_INFO(dev, ev, ex, ey, bf, n, eq)                      \
    {int et;                                                                \
     EventRecord sys;                                                       \
     sys = (ev)->sys_event;                                                   \
     ex = sys.where.h - dev->window_x;                                      \
     ey = sys.where.v - dev->window_y;                                      \
     bf[0] = BitAnd(sys.message, charCodeMask);                             \
     et = sys.modifiers;                                                    \
     eq  = (et & 0x0200) ? KEY_SHIFT : 0;                                   \
     eq |= (et & 0x0400) ? KEY_LOCK  : 0;                                   \
     eq |= (et & 0x1000) ? KEY_CNTL  : 0;                                   \
     eq |= (et & 0x0800) ? KEY_ALT   : 0;}

#endif

#define KEY_ACTION(b, bf)                                                   \
    {PFByte key;                                                            \
     key = b->keymap[bf[0]];                                                \
     _PG_draw_cursor(b, FALSE);                                             \
     if (key != NULL)                                                       \
        (*key)(b);                                                          \
     else                                                                   \
        (*b->write)(b, bf);                                                 \
     _PG_draw_cursor(b, TRUE);}

#define PG_IO_INTERRUPTS(x)   PC_io_interrupts_on = (x)

#define PG_write_abs          PG_write_WC
#define PG_get_window         PG_get_viewport_WC
#define PG_get_bound          PG_get_bound_WC
#define PG_clear_screen       PG_clear_window

#define PG_set_render_info(g, a)     (g)->info = (char *) (a)
#define PG_get_render_info(g, a)     a = (pcons *) ((g)->info)

#define PG_set_axis_decades(d)         _PG_axis_n_decades = (d)
#define PG_get_axis_decades(d)         d = _PG_axis_n_decades

#define PG_set_clear_mode(i)         PG_hl_clear_mode = (i)
#define PG_get_clear_mode(i)         i = PG_hl_clear_mode

#define PG_set_identifier(g, i)     (g)->identifier = (i)
#define PG_get_identifier(g, i)     i = (g)->identifier

#define PG_white_background(d, t)     (d)->background_color_white = (t)
#define PG_set_res_scale_factor(d, t) (d)->resolution_scale_factor = (t)
#define PG_set_border_width(d, t)     (d)->border_width = (t)

#define PG_set_ps_dots_inch(d)      _PG_ps_dots_inch = (d)
#define PG_get_ps_dots_inch(d)      d = _PG_ps_dots_inch

#define PG_turn_grid(d, t)         (d)->grid        = (t)
#define PG_turn_data_id(d, t)      (d)->data_id     = (t)
#define PG_turn_scatter(d, t)      (d)->scatter     = (t)
#define PG_turn_autodomain(d, t)   (d)->autodomain  = (t)
#define PG_turn_autorange(d, t)    (d)->autorange   = (t)
#define PG_turn_autoplot(d, t)     (d)->autoplot    = (t)

#define PG_set_viewport_pos(d, x, y)                                         \
    {(d)->view_x = (x);                                                      \
     (d)->view_y = (y);}

#define PG_set_viewport_shape(d, w, h, a)                                    \
    {(d)->view_width  = (w);                                                 \
     (d)->view_height = (h);                                                 \
     (d)->view_aspect = (a);}

#define PG_clear_frame(d)                                                    \
   PG_clear_region_NDC(d, d->fxmin, d->fxmax, d->fymin, d->fymax, 0)

#define PG_set_fill_bound(d, v)        d->draw_fill_bound = (v)
#define PG_get_fill_bound(d, v)        v = d->draw_fill_bound

#define PG_set_finish_state(d, v)        d->finished = (v)
#define PG_get_finish_state(d, v)        v = d->finished

#define PG_set_marker_scale(d, v)        d->marker_scale = max(v, 0.0)
#define PG_get_marker_scale(d, v)        v = d->marker_scale
#define PG_set_marker_orientation(d, v)  d->marker_orientation = (v)
#define PG_get_marker_orientation(d, v)  v = d->marker_orientation

#define PG_set_max_intensity(d, v)        d->max_intensity = min(v, 1.0)
#define PG_get_max_intensity(d, v)        v = d->max_intensity

#define PG_set_max_red_intensity(d, v)    d->max_red_intensity = min(v, 1.0)
#define PG_get_max_red_intensity(d, v)    v = d->max_red_intensity

#define PG_set_max_green_intensity(d, v)  d->max_green_intensity = min(v, 1.0)
#define PG_get_max_green_intensity(d, v)  v = d->max_green_intensity

#define PG_set_max_blue_intensity(d, v)   d->max_blue_intensity = min(v, 1.0)
#define PG_get_max_blue_intensity(d, v)   v = d->max_blue_intensity

#define PG_GET_NEXT_EVENT(ev)                                                \
    ((PG_get_event_hook != NULL) ? (*PG_get_event_hook)(&ev) : FALSE)

#define PG_handle_expose_event(d, ev)                                        \
    {if ((d) != NULL)                                                        \
        (*((d)->expose_event_handler.fnc))(d, &ev);}
#define PG_handle_update_event(d, ev)                                        \
    {if ((d) != NULL)                                                        \
        (*((d)->update_event_handler.fnc))(d, &ev);}
#define PG_handle_mouse_down_event(d, ev)                                    \
    {if ((d) != NULL)                                                        \
        (*((d)->mouse_down_event_handler.fnc))(d, &ev);}
#define PG_handle_mouse_up_event(d, ev)                                      \
    {if ((d) != NULL)                                                        \
        (*((d)->mouse_up_event_handler.fnc))(d, &ev);}
#define PG_handle_key_down_event(d, ev)                                      \
    {if ((d) != NULL)                                                        \
        (*((d)->key_down_event_handler.fnc))(d, &ev);}
#define PG_handle_key_up_event(d, ev)                                        \
    {if ((d) != NULL)                                                        \
        (*((d)->key_up_event_handler.fnc))(d, &ev);}
#define PG_handle_default_event(d, ev)                                       \
    {if ((d) != NULL)                                                        \
        (*((d)->default_event_handler.fnc))(d, &ev);}

#define PG_query_pointer(d, px, py, pb, pq)                                  \
    if ((d)->query_pointer != NULL)                                          \
       (*(d)->query_pointer)(d, px, py, pb, pq)

#define PG_get_event_device(ev)                                              \
    (PG_event_device_hook != NULL) ?                                         \
    (*PG_event_device_hook)(&ev) :                                           \
    NULL;

#define PG_get_char(d)                                                       \
    ((((d) != NULL) && ((d)->get_char != NULL)) ? (*(d)->get_char)(d) : '\0')

#define PG_get_text_ext_NDC(d, s, px, py)                                    \
    if ((d) != NULL)                                                         \
       {if ((d)->get_text_ext_NDC != NULL)                                   \
           (*(d)->get_text_ext_NDC)(d, s, px, py);}
#define PG_set_line_color(d, color)                                          \
    if ((d) != NULL)                                                         \
       {if ((d)->set_line_color != NULL)                                     \
           (*(d)->set_line_color)(d, color, TRUE);}
#define PG_set_color_line(d, color, mapped)                                  \
    if ((d) != NULL)                                                         \
       {if ((d)->set_line_color != NULL)                                     \
           (*(d)->set_line_color)(d, color, mapped);}
#define PG_set_text_color(d, color)                                          \
    if ((d) != NULL)                                                         \
       {if ((d)->set_text_color != NULL)                                     \
           (*(d)->set_text_color)(d, color, TRUE);}
#define PG_set_color_text(d, color, mapped)                                  \
    if ((d) != NULL)                                                         \
       {if ((d)->set_text_color != NULL)                                     \
           (*(d)->set_text_color)(d, color, mapped);}
#define PG_set_line_width(d, width)                                          \
    if ((d) != NULL)                                                         \
       {if ((d)->set_line_width != NULL)                                     \
	   {if (width > 0.0)                                                 \
	       (*(d)->set_line_width)(d, width);                             \
	    else                                                             \
	       (*(d)->set_line_width)(d, _PG_line_width);};}
#define PG_set_char_precision(d, p)                                          \
    if ((d) != NULL)                                                         \
       {if ((d)->set_char_precision != NULL)                                 \
           (*(d)->set_char_precision)(d, p);}
#define PG_set_char_space(d, s)                                              \
    if ((d) != NULL)                                                         \
       {if ((d)->set_char_space != NULL)                                     \
           (*(d)->set_char_space)(d, s);}
#define PG_set_char_up(d, x, y)                                              \
    if ((d) != NULL)                                                         \
       {if ((d)->set_char_up != NULL)                                        \
           (*(d)->set_char_up)(d, x, y);}
#define PG_set_char_size_NDC(d, x, y)                                        \
    if ((d) != NULL)                                                         \
       {if ((d)->set_char_size_NDC != NULL)                                  \
           (*(d)->set_char_size_NDC)(d, x, y);}
#define PG_set_char_path(d, x, y)                                            \
    if ((d) != NULL)                                                         \
       {if ((d)->set_char_path != NULL)                                      \
           (*(d)->set_char_path)(d, x, y);}
#define PG_set_font(d, face, style, size)                                    \
    if ((d) != NULL)                                                         \
       {if ((d)->set_font != NULL)                                           \
           (*(d)->set_font)(d, face, style, size);}
#define PG_set_char_line(d, n)                                               \
    if ((d) != NULL)                                                         \
       {if ((d)->set_char_line != NULL)                                      \
           (*(d)->set_char_line)(d, n);}
#define PG_set_clipping(d, flag)                                             \
    if ((d) != NULL)                                                         \
       {if ((d)->set_clipping != NULL)                                       \
           (*(d)->set_clipping)(d, flag);}
#define PG_set_bound(d, xmn, xmx, ymn, ymx)                                  \
    if ((d) != NULL)                                                         \
       {if ((d)->set_bound != NULL)                                          \
           (*(d)->set_bound)(d, xmn, xmx, ymn, ymx);}
#define PG_shade_poly(d, x, y, n)                                            \
    if ((d) != NULL)                                                         \
       {if ((d)->shade_poly != NULL)                                         \
           (*(d)->shade_poly)(d, x, y, n);}
#define PG_fill_curve(d, c)                                                  \
    if ((d) != NULL)                                                         \
       {if ((d)->fill_curve != NULL)                                         \
           (*(d)->fill_curve)(d, c);}
#define PG_move_gr_abs(d, x, y)                                              \
    if ((d) != NULL)                                                         \
       {if ((d)->move_gr_abs != NULL)                                        \
           (*(d)->move_gr_abs)(d, x, y);}
#define PG_move_tx_abs(d, x, y)                                              \
    if ((d) != NULL)                                                         \
       {if ((d)->move_tx_abs != NULL)                                        \
           (*(d)->move_tx_abs)(d, x, y);}
#define PG_move_tx_rel(d, x, y)                                              \
    if ((d) != NULL)                                                         \
       {if ((d)->move_tx_rel != NULL)                                        \
           (*(d)->move_tx_rel)(d, x, y);}
#define PG_draw_to_abs(d, x, y)                                              \
    if ((d) != NULL)                                                         \
       {if ((d)->draw_to_abs != NULL)                                        \
           (*(d)->draw_to_abs)(d, x, y);}
#define PG_draw_to_rel(d, x, y)                                              \
    if ((d) != NULL)                                                         \
       {if ((d)->draw_to_rel != NULL)                                        \
           (*(d)->draw_to_rel)(d, x, y);}
#define PG_set_line_style(d, style)                                          \
    if ((d) != NULL)                                                         \
       {if ((d)->set_line_style != NULL)                                     \
           (*(d)->set_line_style)(d, style);}
#define PG_set_logical_op(d, lop)                                            \
    if ((d) != NULL)                                                         \
       {if ((d)->set_logical_op != NULL)                                     \
           (*(d)->set_logical_op)(d, lop);}
#define PG_set_fill_color(d, color)                                          \
    if ((d) != NULL)                                                         \
       {if ((d)->set_fill_color != NULL)                                     \
           (*(d)->set_fill_color)(d, color, TRUE);}
#define PG_set_color_fill(d, color, mapped)                                  \
    if ((d) != NULL)                                                         \
       {if ((d)->set_fill_color != NULL)                                     \
           (*(d)->set_fill_color)(d, color, mapped);}
#define PG_draw_curve(d, c, clip)                                            \
    if ((d) != NULL)                                                         \
       {if ((d)->draw_curve != NULL)                                         \
           (*(d)->draw_curve)(d, c, clip);}
#define PG_draw_disjoint_polyline_2(d, x, y, n, flag, coord)                 \
    if ((d) != NULL)                                                         \
       {if ((d)->draw_dj_polyln_2 != NULL)                                   \
           (*(d)->draw_dj_polyln_2)(d, x, y, n, flag, coord);}
#define PG_clear_window(d)                                                   \
    if ((d) != NULL)                                                         \
       {if ((d)->clear_window != NULL)                                       \
           (*(d)->clear_window)(d);}
#define PG_clear_viewport(d)                                                 \
    if ((d) != NULL)                                                         \
       {if ((d)->clear_viewport != NULL)                                     \
           (*(d)->clear_viewport)(d);}
#define PG_clear_region_NDC(d, xmn, xmx, ymn, ymx, pad)                      \
    if ((d) != NULL)                                                         \
       {if ((d)->clear_region_NDC != NULL)                                   \
           (*(d)->clear_region_NDC)(d, xmn, xmx, ymn, ymx, pad);}
#define PG_update_vs(d)                                                      \
    if ((d) != NULL)                                                         \
       {if ((d)->update_vs != NULL)                                          \
           (*(d)->update_vs)(d);}
#define PG_finish_plot(d)                                                    \
    if ((d) != NULL)                                                         \
       {if ((d)->finish_plot != NULL)                                        \
           (*(d)->finish_plot)(d);}
#define PG_clear_page(d, i)                                                  \
    if ((d) != NULL)                                                         \
       {if ((d)->clear_page != NULL)                                         \
           (*(d)->clear_page)(d, i);}
#define PG_expose_device(d)                                                  \
    if ((d) != NULL)                                                         \
       {if ((d)->expose_device != NULL)                                      \
           (*(d)->expose_device)(d);}
#define PG_make_device_current(d)                                            \
    if ((d) != NULL)                                                         \
       {if ((d)->make_device_current != NULL)                                \
           (*(d)->make_device_current)(d);}
#define PG_release_current_device(d)                                         \
    if ((d) != NULL)                                                         \
       {if ((d)->release_current_device != NULL)                             \
           (*(d)->release_current_device)(d);}
#define PG_get_image(d, bf, ix, iy, nx, ny)                                  \
    if ((d) != NULL)                                                         \
       {if ((d)->get_image != NULL)                                          \
           (*(d)->get_image)(d, bf, ix, iy, nx, ny);}
#define PG_put_image(d, bf, ix, iy, nx, ny)                                  \
    if ((d) != NULL)                                                         \
       {if ((d)->put_image != NULL)                                          \
           (*(d)->put_image)(d, bf, ix, iy, nx, ny);}
#define PG_write_text(d, fp, s)                                              \
    if ((d) != NULL)                                                         \
       {if ((d)->write_text != NULL)                                         \
           (*(d)->write_text)(d, fp, s);}
#define PG_next_line(d)                                                      \
    if ((d) != NULL)                                                         \
       {if ((d)->next_line != NULL)                                          \
           (*(d)->next_line)(d);}
#define PG_open_screen(d, xf, yf, dxf, dyf)                                  \
    if ((d) != NULL)                                                         \
       {if ((d)->open_screen != NULL)                                        \
           (*(d)->open_screen)(d, xf, yf, dxf, dyf);}
#define PG_query_screen(d, pdx, pdy, pnc)                                    \
    if ((d) != NULL)                                                         \
       {if ((d)->query_screen != NULL)                                       \
           (*(d)->query_screen)(d, pdx, pdy, pnc);}
#define PG_close_device(d)                                                   \
    if ((d) != NULL)                                                         \
       {if ((d)->close_device != NULL)                                       \
           (*(d)->close_device)(d);}

#define PG_open_console(title, type, bckgr, xf, yf, dxf, dyf)                \
    ((PG_open_console_hook != NULL) ?                                        \
     (*PG_open_console_hook)(title, type, bckgr, xf, yf, dxf, dyf) :         \
     FALSE)

#define PG_close_console                                                     \
    if ((PG_console_device != NULL) &&                                       \
        (PG_console_device->close_console != NULL))                          \
       (*PG_console_device->close_console)

#define PG_fgets(buffer, maxlen, stream)                                     \
    (((PG_console_device != NULL) && (PG_console_device->ggets != NULL)) ?   \
     (*PG_console_device->ggets)(buffer, maxlen, stream) :                   \
     NULL)

#define PG_puts(bf)                                                          \
    if ((PG_console_device != NULL) && (PG_console_device->gputs != NULL))   \
       (*PG_console_device->gputs)(bf)

#define _PG_draw_iso(d, x, y, a, lev, k, l, nl, lb)                          \
    PG_draw_iso_nc_lr(d, a, x, y, lev, k, l, nl, lb)

#define PG_get_device_image(_d, _i)                                          \
    ((_i) = ((PG_image *) GET_RST_DEVICE(_d)->fp))

#define PG_put_device_image(_d, _i)                                          \
    (GET_RST_DEVICE(_d)->fp = (FILE *) (_i))

#define PG_set_color_type(dev, dev_type, color)                              \
    if (strcmp(dev_type, "PS") == 0)                                         \
       {if (strcmp(SX_ps_type, color) == 0)                                  \
	   return(SS_f);                                                     \
	SFREE(SX_ps_type);                                                   \
	SX_ps_type = SC_strsavef(color,                                      \
				 "char*:PG_SET_COLOR_TYPE:ps_type");         \
        SFREE(dev->type);                                                    \
        dev->type = SC_strsavef(color,                                       \
                                "char*:PG_SET_COLOR_TYPE:ps_type");          \
        if (strcmp(color, "COLOR"))                                          \
	   dev->ps_color = TRUE;                                             \
	else                                                                 \
	   dev->ps_color = FALSE;}

/*--------------------------------------------------------------------------*/

#ifdef MAC

/*--------------------------------------------------------------------------*/

/* SETRECT - Inline SetRect() macro, efficient when (rectp) is a constant
 *         - Must not be used if (rectp) has side effects
 *         - We could do an InsetRect() macro in a similar vein
 */
 
#define SETRECT(rectp, _left, _top, _right, _bottom)                         \
    (rectp)->left = (_left);                                                 \
    (rectp)->top = (_top);                                                   \
    (rectp)->right = (_right);                                               \
    (rectp)->bottom = (_bottom)

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* HIWORD - get the high 16 bits of a 32 bit long */

#define HIWORD(aLong) (((aLong) >> 16) & 0xFFFF)

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* LOWORD - get the low 16 bits of a 32 bit long */

#define LOWORD(aLong) ((aLong) & 0xFFFF)

/*--------------------------------------------------------------------------*/

#ifdef THINK_C

#ifdef VERSION_5

#define NEW_CONTROL    NewControl
#define GET_ITEM       GetItem
#define GET_FNUM       GetFNum
#define OPEN_DESK_ACC  OpenDeskAcc
#define SET_I_TEXT     SetDialogItemText
#define GET_KEYS(pk)   GetKeys(&pk)

/*--------------------------------------------------------------------------*/

#define NEW_WINDOW(w, n1, shape, title, f1, type, ptr, f2, n2)               \
    {char s[MAXLINE];                                                        \
     strcpy(s, title);                                                       \
     C_STR_PASCAL(s);                                                        \
     w = NewWindow(n1, shape, s, f1, type, ptr, f2, n2);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define NEW_C_WINDOW(w, n1, shape, title, f1, type, ptr, f2, n2)             \
    {char s[MAXLINE];                                                        \
     strcpy(s, title);                                                       \
     C_STR_PASCAL(s);                                                        \
     w = NewCWindow(n1, shape, s, f1, type, ptr, f2, n2);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define DRAW_STRING(s)                                                       \
   {char v[MAXLINE];                                                         \
    strcpy(v, s);                                                            \
    C_STR_PASCAL(v);                                                         \
    DrawString(v);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define STRING_WIDTH(ix, s)                                                  \
   {char t[MAXLINE];                                                         \
    sprintf(t, "%s", s);                                                     \
    C_STR_PASCAL(t);                                                         \
    ix = StringWidth(t);}

/*--------------------------------------------------------------------------*/

#endif

#ifdef VERSION_7

#define GET_ITEM       GetItem
#define GET_KEYS(pk)   GetKeys(pk)

/*--------------------------------------------------------------------------*/

#define NEW_WINDOW(w, n1, shape, title, f1, type, ptr, f2, n2)               \
    {char s[MAXLINE];                                                        \
     strcpy(s, title);                                                       \
     C_STR_PASCAL(s);                                                        \
     w = NewWindow(n1, shape, (ConstStr255Param) s, f1, type, ptr, f2, n2);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define NEW_C_WINDOW(w, n1, shape, title, f1, type, ptr, f2, n2)             \
    {char s[MAXLINE];                                                        \
     strcpy(s, title);                                                       \
     C_STR_PASCAL(s);                                                        \
     w = NewCWindow(n1, shape, (ConstStr255Param) s, f1, type, ptr, f2, n2);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define NEW_CONTROL(w, shape, s, f1, n1, n2, n3, type, n4)                   \
    NewControl(w, shape, (ConstStr255Param) s, f1, n1, n2, n3, type, n4)
                          
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define GET_FNUM(s, n)                                                       \
    {char P_s[MAXLINE];                                                      \
     strcpy(P_s, s);                                                         \
     C_STR_PASCAL(P_s);                                                      \
     GetFNum((ConstStr255Param) P_s, n);}
                          
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define OPEN_DESK_ACC(s)                                                     \
    {char P_s[MAXLINE];                                                      \
     strcpy(P_s, s);                                                         \
     C_STR_PASCAL(P_s);                                                      \
     OpenDeskAcc((ConstStr255Param) P_s);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define SET_I_TEXT(h, s)                                                     \
    {char P_s[MAXLINE];                                                      \
     strcpy(P_s, s);                                                         \
     C_STR_PASCAL(P_s);                                                      \
     SetDialogItemText(h, (ConstStr255Param) P_s);}
                          
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define DRAW_STRING(s)                                                       \
   {char v[MAXLINE];                                                         \
    strcpy(v, s);                                                            \
    C_STR_PASCAL(v);                                                         \
    DrawString((ConstStr255Param) v);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define STRING_WIDTH(ix, s)                                                  \
   {char t[MAXLINE];                                                         \
    sprintf(t, "%s", s);                                                     \
    C_STR_PASCAL(t);                                                         \
    ix = StringWidth((ConstStr255Param) t);}
                          
/*--------------------------------------------------------------------------*/

#endif

#endif

#ifdef __MWERKS__

#define GET_ITEM       GetMenuItemText
#define GET_KEYS(pk)   GetKeys(pk)

/*--------------------------------------------------------------------------*/

#define NEW_WINDOW(w, n1, shape, title, f1, type, ptr, f2, n2)               \
    {char s[MAXLINE];                                                        \
     strcpy(s, title);                                                       \
     C_STR_PASCAL(s);                                                        \
     w = NewWindow(n1, shape, (ConstStr255Param) s, f1, type, ptr, f2, n2);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define NEW_C_WINDOW(w, n1, shape, title, f1, type, ptr, f2, n2)             \
    {char s[MAXLINE];                                                        \
     strcpy(s, title);                                                       \
     C_STR_PASCAL(s);                                                        \
     w = NewCWindow(n1, shape, (ConstStr255Param) s, f1, type, ptr, f2, n2);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define NEW_CONTROL(w, shape, s, f1, n1, n2, n3, type, n4)                   \
    NewControl(w, shape, (ConstStr255Param) s, f1, n1, n2, n3, type, n4)
                          
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define GET_FNUM(s, n)                                                       \
    {char P_s[MAXLINE];                                                      \
     strcpy(P_s, s);                                                         \
     C_STR_PASCAL(P_s);                                                      \
     GetFNum((ConstStr255Param) P_s, n);}
                          
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define OPEN_DESK_ACC(s)                                                     \
    {char P_s[MAXLINE];                                                      \
     strcpy(P_s, s);                                                         \
     C_STR_PASCAL(P_s);                                                      \
     OpenDeskAcc((ConstStr255Param) P_s);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define SET_I_TEXT(h, s)                                                     \
    {char P_s[MAXLINE];                                                      \
     strcpy(P_s, s);                                                         \
     C_STR_PASCAL(P_s);                                                      \
     SetDialogItemText(h, (ConstStr255Param) P_s);}
                          
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define DRAW_STRING(s)                                                       \
   {char v[MAXLINE];                                                         \
    strcpy(v, s);                                                            \
    C_STR_PASCAL(v);                                                         \
    DrawString((ConstStr255Param) v);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define STRING_WIDTH(ix, s)                                                  \
   {char t[MAXLINE];                                                         \
    sprintf(t, "%s", s);                                                     \
    C_STR_PASCAL(t);                                                         \
    ix = StringWidth((ConstStr255Param) t);}
                          
/*--------------------------------------------------------------------------*/

#endif

#endif

/*--------------------------------------------------------------------------*/
 
/*                        TYPEDEF'S AND STRUCT'S                            */
 
/*--------------------------------------------------------------------------*/

typedef struct s_PG_axis_def PG_axis_def;
typedef struct s_PG_graph PG_graph;
typedef PG_graph *(*PFPPG_graph)();
typedef struct s_PG_marker PG_marker;
typedef struct s_PG_font_family PG_font_family;
typedef struct s_PG_curve PG_curve;
typedef struct s_PG_interface_object PG_interface_object;
typedef PG_interface_object *(*PFPPG_interface_object)();
typedef struct s_PG_device PG_device;
typedef PG_device *(*PFPPG_device)();
typedef struct s_PG_palette PG_palette;
typedef struct s_PG_picture_desc PG_picture_desc;
typedef struct s_PG_image PG_image;
typedef struct s_PG_par_rend_info PG_par_rend_info;
typedef struct s_PG_view_attributes PG_view_attributes;
typedef struct s_PG_dev_attributes PG_dev_attributes;
typedef struct s_curve curve;
typedef struct s_PG_text_box PG_text_box;
typedef struct s_PG_event_handler PG_event_handler;


/*--------------------------------------------------------------------------*/

struct s_curve
   {char *text;                            /* text associated with the data */
    int modified;                          /* flag indicating changed curve */
    byte *obj;                       /* pointer to the encapsulating object */
    REAL xmin;                                   /* calculate only on input */
    REAL xmax;
    REAL ymin;
    REAL ymax;
    int n;                                /* number of data points in array */
    REAL *xp;                                         /* pointer to x array */
    REAL *yp;                                           /* point to y array */
    pcons *info;
    byte *file_info;           /* file info - cast to some struct with info */
    int file_type;                          /* file type ASCII, BINARY, PDB */
    char *file;                                      /* file name for curve */
    char id;};                                         /* letter identifier */
     
/*--------------------------------------------------------------------------*/

/* PG_AXIS_DEF - axis definition information */

struct s_PG_axis_def
   {int axis_type;
    int tick_type;
    int label_type;
    int x_log_scale;
    int y_log_scale;
    double x0;
    double y0;
    double dr;

    int n_major;
    double major_end;
    double major_start;
    double major_space;
    double va_major;
    double vb_major;
    REAL *major_dx;

    int n_minor;
    double minor_end;
    double minor_start;
    double minor_space;
    double va_minor;
    double vb_minor;
    REAL *minor_dx;

    int n_label;
    double label_end;
    double label_start;
    double label_space;
    double scale;
    double x_scale;
    double y_scale;
    double cosa;
    double sina;
    double t1;
    double t2;
    double v1;
    double v2;
    double eps_rel;};

/*--------------------------------------------------------------------------*/

/* PICTURE - contains the information necessary to describe a picture
 *         - in some fashion
 */

struct s_PG_picture_desc
   {PG_graph *data;
    pcons *alist;
    REAL *viewport;
    int rendering;

    int pl_type;
    int mesh_fl;
    int label_fl;
    char *label;

    int axis_fl;                    /* axis description */
    int ax_type;

    int palette_fl;                 /* color palette display */
    PG_palette *palette;

    int legend_fl;                  /* contour plot legend */
    int n_levels;
    REAL *levels;

    int curve_fl;                   /* print curve labels */

    REAL theta;                     /* view angle */
    REAL phi;
    REAL chi;

    REAL vxmin;                     /* original viewport */
    REAL vxmax;
    REAL vymin;
    REAL vymax;

    REAL xmin;                      /* original WC */
    REAL xmax;
    REAL ymin;
    REAL ymax;};

/*--------------------------------------------------------------------------*/

/* GRAPH - contains the information necessary to display a list of functions
 *       - in some fashion
 */

struct s_PG_graph
   {PM_mapping *f;
    int rendering;
    int mesh;
    char *info_type;                       /* data type for the info member */
    byte *info;        /* attribute information for the rendering algorithm */
    int identifier;
    char *use;                          /* volatile communicator internally */
    void SC_DECLARE((*render),
		    (PG_device *dev, PG_graph *data, ...));
    struct s_PG_graph *next;};

/*--------------------------------------------------------------------------*/

/* MARKER - line segment description of a marker character */

struct s_PG_marker
   {int n_seg;
    REAL *x1;
    REAL *y1;
    REAL *x2;
    REAL *y2;};

/*--------------------------------------------------------------------------*/

/* FONT_FAMILY - info for a family of fonts
 *             - the canonical set of styles is (in order):
 *             -
 *             - Normal
 *             - Italic
 *             - Bold
 *             - Bold Italic
 *             -
 *             - others may be defined, but these should be here always
 */

struct s_PG_font_family
   {char *type_face;
    int n_styles;
    char **type_styles;
    struct s_PG_font_family *next;};

/*--------------------------------------------------------------------------*/

#ifdef MSC

union u_VGA_color
   {long color;
    struct
       {char red;
        char green;
        char blue;
        char gray;} rgb;};

typedef union u_VGA_color VGA_color;

#endif

#ifdef BGI

struct s_VGA_color
   {char red;
    char green;
    char blue;};

typedef struct s_VGA_color VGA_color;

#endif

/*--------------------------------------------------------------------------*/

/* declare RGB color map */

#ifndef MAC

struct s_RGB_color_map
   {double red;
    double green;
    double blue;};

typedef struct s_RGB_color_map RGB_color_map;

#endif

#ifdef MAC

#ifdef MAC_COLOR
typedef RGBColor RGB_color_map;
#endif

#endif

/*--------------------------------------------------------------------------*/

/* palette structure */
struct s_PG_palette
   {char *name;
    int max_pal_dims;                 /* number of different palette shapes */
    int **pal_dims;            /* shapes for 1, 2, ... dimensional palettes */
    int n_pal_colors;
    int n_dev_colors;
    REAL max_red_intensity;
    REAL max_green_intensity;
    REAL max_blue_intensity;
    RGB_color_map *pseudo_colormap;
    RGB_color_map *true_colormap;
    unsigned short *pixel_value;

#ifdef MAC_COLOR
    PaletteHandle hpalette;
#endif

    struct s_PG_palette *next;};

/*--------------------------------------------------------------------------*/

#ifdef USE_GL

#define EVENT_DEFINED

struct s_PG_event
   {long indev;
    long window;
    int x;
    int y;
    int btn;
    int mod;
    int type;};

typedef struct s_PG_event PG_event;

#endif

#ifdef X11R4

#define EVENT_DEFINED
typedef XEvent PG_event;

#endif

#ifdef MAC

#define EVENT_DEFINED

struct s_PG_event
   {EventRecord sys_event;
    int type;};

typedef struct s_PG_event PG_event;

#endif

#ifndef EVENT_DEFINED

struct s_PG_event
   {int type;};

typedef struct s_PG_event PG_event;

#endif

/*--------------------------------------------------------------------------*/

/* PG_CURVE - this is a structure containing a curve (line)
 *          - the points are in pixel coordinates which makes
 *          - plotting operations faster
 *          - it is useful for defining boundaries
 */

struct s_PG_curve
   {int n;
    int closed;
    int x_origin;
    int y_origin;
    int *x;
    int *y;};

/*--------------------------------------------------------------------------*/

struct s_PG_interface_object
   {PG_device *device;
    PG_curve *curve;
    char *name;
    char *type;
    byte *obj;
    int foreground;
    int background;
    int is_visible;
    int is_active;
    int is_selectable;

    char *draw_name;
    char *action_name;
    char *select_name;

    void SC_DECLARE((*draw), (PG_interface_object *iob));
    void SC_DECLARE((*action), (PG_interface_object *iob, PG_event *ev));
    PG_interface_object *SC_DECLARE((*select),
                                 (PG_interface_object *iob, PG_event *ev));

    PG_interface_object *parent;
    int n_children;
    int max_children;
    PG_interface_object **children;};

/*--------------------------------------------------------------------------*/

struct s_PG_text_box
   {char *name;
    int type;
    PG_device *dev;
    PG_curve *bnd;
    int n_lines;
    int n_chars_line;
    int n_lines_page;
    int line;
    int col;
    int mode;
    int align;
    double angle;
    int background;
    int foreground;
    double border;
    int standoff;
    char **text_buffer;
    PFByte *keymap;
    PG_text_box *next;

    char *SC_DECLARE((*backup), (PG_text_box *b, char *p, int n));
    char *SC_DECLARE((*gets), (PG_text_box *b, char *buffer,
			    int maxlen, FILE *stream));

    void SC_DECLARE((*clear), (PG_text_box *b, int i));
    void SC_DECLARE((*write), (PG_text_box *b, char *s));
    void SC_DECLARE((*newline), (PG_text_box *b));};

/*--------------------------------------------------------------------------*/

struct s_PG_event_handler
   {PFVoid fnc;
    int lang;};

/*--------------------------------------------------------------------------*/

/* PG_DEVICE - graphics device structure */

struct s_PG_device
   {

#ifdef MAC

    WindowPtr window;
    Rect window_shape;
    Rect scroll_bar_shape;
    Rect drag_bound_shape;
    Rect display_shape;  /* display rect which should be cleared */
    Rect text_shape;     /* display_shape inset by (4,0) */
    Point mouse;
    TEHandle text;
    ControlHandle scroll_bar;
    MenuHandle menu[menuCount];
    int next_palette_index;

#endif

#ifdef USE_SUNCORE

    jmp_buf jump_buffer;
    struct vwsurf *vwsurf;
    REAL red_tab[N_COLORS];
    REAL green_tab[N_COLORS];
    REAL blue_tab[N_COLORS];
 
#endif
 
/* X11R4 variables */

#ifdef X11R4

    int X_cap_style;
    int X_join_style;
    int X_line_style;
    unsigned int X_line_width;
    Display *display;
    Window window;
    GC gc;
# ifdef USE_OGL
    GLXContext glxgc;
# endif
    XGCValues values;
    XFontStruct *font_info;

#endif

/* GL variables */

#ifdef USE_GL

    long window;

#endif

#if 0
#ifdef DOS
 
    int physical_pixel_width;
    int physical_pixel_height;
    int physical_char_line;
    int physical_lines_page;

    VGA_color *colormap;

#endif
#endif
/* PostScript device info */
    int ps_color;                    /* TRUE if a color Post Script printer */
    int window_orientation;          /* PORTRAIT_MODE or LANDSCAPE_MODE */

/* CGM device info */
    int cgm_page_set;

/* generic device info */

    int absolute_n_color;
    int autodomain;             /* Sets the auto domain */
    int autoplot;
    int autorange;              /* Sets autoranging */

/* transformations between WC and NDC */
    REAL axs_w; 
    REAL axw_s; 
    REAL ayw_s; 
    REAL ays_w; 
    REAL bxs_w; 
    REAL bxw_s; 
    REAL bys_w;
    REAL byw_s; 

    int background_color_white;
    int border_width;
    REAL botspace;

/* character controls */
    REAL char_frac;
    REAL char_height_s;
    int char_precision;
    REAL char_path_x;
    REAL char_path_y;
    REAL char_space;
    REAL char_space_s;
    REAL char_up_x;
    REAL char_up_y;
    REAL char_width_s;
    
    int clipping;

    int data_id;
    int draw_fill_bound;

    FILE *file;
    int fill_color;
    int finished;

    PG_font_family *font_family;

/* frame limits */
    REAL fxmin;
    REAL fxmax;
    REAL fymin;
    REAL fymax;

/* graphics cursor location in WC */
    REAL gcurx;
    REAL gcury;

    int gprint_flag;     /* print suppression flag (TRUE = ON, FALSE = OFF) */
    int grid;

/* clipping limits in WC */
    REAL gxmax;
    REAL gxmin;
    REAL gymax;
    REAL gymin;

    int hard_copy_device;                     /* TRUE for hard copy devices */

    int ifxlog;
    int ifylog;
    PG_interface_object **interface_objects;
    int is_visible;

    REAL leftspace;
    int line_style;
    int line_color;
    REAL line_width;
    int logical_op;

/* marker controls */
    REAL marker_orientation;
    REAL marker_scale;

    REAL max_intensity;
    int max_interface_objects;
    REAL max_red_intensity;
    REAL max_green_intensity;
    REAL max_blue_intensity;

/* color mapping flags */
    int map_text_color;
    int map_line_color;
    int map_fill_color;

/* device limits in pixel coordinates */
    int min_pc_x;
    int min_pc_y;
    int max_pc_x;
    int max_pc_y;

    int mode;                           /* _mode = -1 when graphics is off */
    char *name;
    int ncolor;
    int n_interface_objects;
    PG_par_rend_info *pri;              /* parallel rendering info */
    int print_labels;
    int quadrant;
    int range_n_extrema;
    REAL *range_extrema;
    int re_open;
    int resolution_scale_factor;
    REAL rightspace;
    int scatter;
    int supress_setup;

/* viewport limits in NDC */
    REAL sxmax;
    REAL sxmin; 
    REAL symax; 
    REAL symin;
    
/* text cursor location in WC */
    REAL tcurx;
    REAL tcury;

    int text_color;
    char *title; 
    REAL topspace;

/* text window in WC */
    int txmax;
    int txmin;
    int tymax;
    int tymin;

    int type_index;
    REAL txt_ratio;
    char *type;

    char *type_face;
    char *type_style;
    int  type_size;

/* viewport location/size in window in NDC */
    REAL view_aspect;
    REAL view_height;
    REAL view_width;
    REAL view_x;
    REAL view_y;

/* window location/size in PIXELS */
    REAL window_height;
    REAL window_width;
    REAL window_x;
    REAL window_y;
    int window_x_off;
    int window_y_off;

    int xor_parity;

/* window limits in WC */
    REAL xmax;
    REAL xmin;
    REAL ymax;
    REAL ymin;

    PG_palette *palettes;
    PG_palette *current_palette;
    PG_palette *color_table;

/* 16 standard colors */
    int BLACK;
    int WHITE;
    int GRAY;
    int DARK_GRAY;
    int BLUE;
    int GREEN;
    int CYAN;
    int RED;
    int MAGENTA;
    int BROWN;
    int DARK_BLUE;
    int DARK_GREEN;
    int DARK_CYAN;
    int DARK_RED;
    int YELLOW;
    int DARK_MAGENTA;

    void SC_DECLARE((*query_pointer),
		    (PG_device *dev, int *px, int *py, int *pb, int *pq));
    void SC_DECLARE((*clear_page), (PG_device *dev, int i));
    void SC_DECLARE((*clear_window), (PG_device *dev));
    void SC_DECLARE((*clear_viewport), (PG_device *dev));
    void SC_DECLARE((*clear_region_NDC),
		    (PG_device *dev, double xmn, double xmx,
		     double ymn, double ymx, int pad));
    void SC_DECLARE((*close_console), (byte));
    void SC_DECLARE((*close_device), (PG_device *dev));
    void SC_DECLARE((*draw_dj_polyln_2),
		    (PG_device *dev, REAL *x, REAL *y, long n,
		     int flag, int coord));
    void SC_DECLARE((*draw_curve),
		    (PG_device *dev, PG_curve *crv, int clip));
    void SC_DECLARE((*draw_to_abs), (PG_device *dev, double x, double y));
    void SC_DECLARE((*draw_to_rel), (PG_device *dev, double x, double y));
    void SC_DECLARE((*expose_device), (PG_device *dev));
    void SC_DECLARE((*finish_plot), (PG_device *dev));
    int SC_DECLARE((*get_char), (PG_device *dev));
    void SC_DECLARE((*get_image),
		    (PG_device *dev, unsigned char *bf, int ix, int iy,
		     int nx, int ny));
    void SC_DECLARE((*get_text_ext_NDC),
		    (PG_device *dev, char *s, REAL *px, REAL *py));
    PFfgets ggets;
    void SC_DECLARE((*gputs), (char *bf));
    void SC_DECLARE((*set_bound),
		    (PG_device *dev, double xmn, double xmx,
		     double ymn, double ymx));
    void SC_DECLARE((*set_clipping), (PG_device *dev, int flag));
    void SC_DECLARE((*set_char_line), (PG_device *dev, int n));
    void SC_DECLARE((*set_char_path), (PG_device *dev, double x, double y));
    void SC_DECLARE((*set_char_precision), (PG_device *dev, int p));
    void SC_DECLARE((*set_char_space), (PG_device *dev, double s));
    void SC_DECLARE((*set_char_size_NDC), (PG_device *dev, double x, double y));
    void SC_DECLARE((*set_char_up), (PG_device *dev, double x, double y));
    void SC_DECLARE((*set_fill_color), (PG_device *dev, int color, int mapped));
    int SC_DECLARE((*set_font),
		   (PG_device *dev, char *face, char *style, int size));
    void SC_DECLARE((*set_line_color), (PG_device *dev, int color, int mapped));
    void SC_DECLARE((*set_line_style), (PG_device *dev, int style));
    void SC_DECLARE((*set_line_width), (PG_device *dev, double width));
    void SC_DECLARE((*set_logical_op), (PG_device *dev, int lop));
    void SC_DECLARE((*set_text_color), (PG_device *dev, int color, int mapped));
    void SC_DECLARE((*shade_poly), (PG_device *dev, REAL *x, REAL *y, int n));
    void SC_DECLARE((*fill_curve), (PG_device *dev, PG_curve *crv));
    void SC_DECLARE((*make_device_current), (PG_device *dev));
    void SC_DECLARE((*map_to_color_table), (PG_device *dev, PG_palette *pal));
    void SC_DECLARE((*match_rgb_colors), (PG_device *dev, PG_palette *pal));
    void SC_DECLARE((*move_gr_abs), (PG_device *dev, double x, double y));
    void SC_DECLARE((*move_tx_abs), (PG_device *dev, double x, double y));
    void SC_DECLARE((*move_tx_rel), (PG_device *dev, double x, double y));
    void SC_DECLARE((*next_line), (PG_device *dev));
    PG_device *SC_DECLARE((*open_screen),
			  (PG_device *dev, double xf, double yf,
			   double dxf, double dyf));
    void SC_DECLARE((*put_image),
		    (PG_device *dev, unsigned char *bf, int ix, int iy,
		     int nx, int ny));
    void SC_DECLARE((*query_screen),
		    (PG_device *dev, int *pdx, int *pdy, int *pnc));
    void SC_DECLARE((*release_current_device), (PG_device *dev));
    void SC_DECLARE((*update_vs), (PG_device *dev));
    void SC_DECLARE((*write_text), (PG_device *dev, FILE *fp, char *s));

    PG_event_handler expose_event_handler;
    PG_event_handler update_event_handler;
    PG_event_handler mouse_down_event_handler;
    PG_event_handler mouse_up_event_handler;
    PG_event_handler motion_event_handler;
    PG_event_handler key_down_event_handler;
    PG_event_handler key_up_event_handler;
    PG_event_handler default_event_handler;};
   
/*--------------------------------------------------------------------------*/

/* PG_IMAGE is PD_defstr'd in PDBX.C any changes here must be reflected
 * there!!
 */

struct s_PG_image
   {int version_id;    /* version id in case of change see PG_IMAGE_VERSION */
    char *label;
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    double zmin;
    double zmax;
    char *element_type;
    unsigned char *buffer;
    int kmax;
    int lmax;
    long size;
    int bits_pixel;
    PG_palette *palette;};


/*--------------------------------------------------------------------------*/

struct s_PG_par_rend_info
   {PG_device *dd;                   /* drawing device for parallel graphics */
    PROCESS *pp;                     /* process for parallel graphics */
    int ip;                          /* id of processor doing final output */
    int have_data;                   /* TRUE if current node has data */
    int *map;                        /* map of processors with data to plot */
    pcons *alist;                    /* picture attributes for parallel graphics */
    char *label;                     /* data label */
    int render;                      /* rendering mode for parallel graphics */
    int polar;};                     /* polar domain flag */

/*--------------------------------------------------------------------------*/

struct s_PG_view_attributes
   {REAL botspace;
    REAL leftspace;
    REAL rightspace;
    REAL topspace;

/* transformations between WC and NDC */
    REAL axs_w; 
    REAL axw_s; 
    REAL ayw_s; 
    REAL ays_w; 
    REAL bxs_w; 
    REAL bxw_s; 
    REAL bys_w;
    REAL byw_s; 

    int finished;

/* graphics cursor location in WC */
    REAL gcurx;
    REAL gcury;

/* clipping limits in WC */
    REAL gxmax;
    REAL gxmin;
    REAL gymax;
    REAL gymin;

    int ifxlog;
    int ifylog;

/* viewport limits in NDC */
    REAL sxmax;
    REAL sxmin; 
    REAL symax; 
    REAL symin;
    
/* text cursor location in WC */
    REAL tcurx;
    REAL tcury;

/* text window in WC */
    int txmax;
    int txmin;
    int tymax;
    int tymin;

/* viewport location/size in window in NDC */
    REAL view_aspect;
    REAL view_height;
    REAL view_width;
    REAL view_x;
    REAL view_y;

/* window limits in WC */
    REAL xmax;
    REAL xmin;
    REAL ymax;
    REAL ymin;};


/*--------------------------------------------------------------------------*/

struct s_PG_dev_attributes
   {int clipping;
    REAL char_frac;
    int char_precision;
    REAL char_space;
    REAL char_up_x;
    REAL char_up_y;
    int fill_color;
    int line_color;
    int line_style;
    REAL line_width;
    int logical_op;
    int text_color;
    PG_palette *palette;};

/*--------------------------------------------------------------------------*/
#if 0
#ifdef DOS

struct s_PG_mouse_state
   {int exists;
    int n_buttons;};

typedef struct s_PG_mouse_state PG_mouse_state;

struct s_PG_mouse_location
   {int button;
    int count;
    int x;
    int y;};

typedef struct s_PG_mouse_location PG_mouse_location;

struct s_PG_mouse_motion
   {int dx;
    int dy;};

typedef struct s_PG_mouse_motion PG_mouse_motion;

struct s_PG_mouse_cursor
   {unsigned image[32];
    unsigned int hX;
    unsigned int hY;};

typedef struct s_PG_mouse_cursor PG_mouse_cursor;

#endif
#endif
#ifdef __cplusplus
extern "C" {
#endif



/*--------------------------------------------------------------------------*/

/*                          VARIABLE DECLARATIONS                           */

/*--------------------------------------------------------------------------*/
 
extern FILE
 *stdscr;              /* this is the effective file pointer for the screen */
 
extern char
 *_PG_axis_label_x_format,
 *_PG_axis_label_y_format,
 *_PG_axis_type_face,
 *_PG_input_bf,
 *_PG_text_format,
 *PG_TEXT_OBJECT_S,
 *PG_VARIABLE_OBJECT_S,
 *PG_BUTTON_OBJECT_S,
 *PG_CONTAINER_OBJECT_S;

extern int
 _PG_axis_char_size,
 _PG_axis_grid_on,
 _PG_axis_grid_style,
 _PG_axis_labels,
 _PG_axis_line_style,
 _PG_axis_max_major_ticks,
 _PG_axis_n_minor_ticks,
 _PG_axis_n_minor_x_ticks,
 _PG_axis_n_minor_y_ticks,
 _PG_axis_on,
 _PG_axis_tick_type,
 _PG_axis_type,
 _PG_color_map_to_extrema,
 _PG_contour_n_levels,
 PG_edit_mode,
 PG_hide_rescale,
 _PG_hist_start,
 PG_hl_clear_mode,
 _PG_input_length,
 PG_jpg_quality,
 _PG_logical_plot,
 _PG_marker_index,
 PG_numeric_data_id,
 PG_overplot,
 PG_parallel_graphics,
 PG_parallel_simulate,
 PG_plot_labels,
 PG_plot_date,
 _PG_plot_type,
 _PG_palette_orientation,
 _PG_restore_viewport,
 _PG_scatter_plot,
 _PG_ref_mesh_color,
 _PG_ref_mesh;

extern REAL
 PG_CGM_text_mag,
 _PG_axis_char_angle,
 _PG_axis_label_x_standoff,
 _PG_axis_label_y_standoff,
 _PG_axis_line_width,
 _PG_axis_major_tick_size,
 _PG_axis_n_decades,
 _PG_contour_ratio,
 _PG_error_cap_size,
 _PG_palette_width,
 _PG_ps_dots_inch,
 _PG_line_width;

extern PG_device
 *PG_console_device;

extern PG_event
 PG_current_event;

extern HASHTAB
 *PG_callback_tab;


#if 0
#ifdef DOS

extern PG_mouse_cursor
 PG_mouse_I_Beam,
 PG_mouse_NW_Arrow,
 PG_mouse_Left_Arrow,
 PG_mouse_Cross,
 PG_mouse_Hand;

#endif
#endif

extern PFInt
 PG_get_event_hook,
 PG_open_console_hook;

extern PFPPG_device
 PG_event_device_hook;

extern void
 SC_DECLARE((*PG_picture_hook), (PG_device *dev, PG_graph *data,
				 PG_picture_desc *pd));

/*--------------------------------------------------------------------------*/

/*                          FUNCTION DECLARATIONS                           */

/*--------------------------------------------------------------------------*/


/* GSAUX.C declarations */

extern unsigned char
 *SC_DECLARE(PG_c_str_pascal, 
             (unsigned char *bf, char *s, long n, int pad));

extern int
 SC_DECLARE(PG_CGM_command,
	    (PG_device *dev, int cat, int id, int nparams, ...));


/* GSAXIS.C declarations */

extern int
 SC_DECLARE(PG_set_axis_attributes, (PG_device *dev, ...));

extern void
 SC_DECLARE(PG_axis, (PG_device *dev, int axis_type));

extern PG_axis_def
 *SC_DECLARE(PG_draw_axis,
	     (PG_device *dev, double xl, double yl, double xr, double yr,
	      double t1, double t2, double v1, double v2,
	      double sc, char *format, int tick_type, int label_type,
	      int flag, ...));


/* GSCLR.C declarations */

extern int
 SC_DECLARE(PG_rgb_index, (PG_device *dev, RGB_color_map *cm)),
 SC_DECLARE(PG_select_color, 
            (PG_device *dev, int n, REAL *a, REAL *extr)),
 SC_DECLARE(PG_wr_palette, 
            (PG_device *dev, PG_palette *pal, char *fname));

extern void
 SC_DECLARE(_PG_register_palette, (PG_device *dev, PG_palette *pal,
				   int map)),
 SC_DECLARE(_PG_match_rgb_colors, 
            (PG_device *dev, PG_palette *pal)),
 SC_DECLARE(PG_setup_standard_palettes, 
            (PG_device *dev, int nc, int l1,
	     int l2, int l3, int l4,
	     int l5, int l6)),
 SC_DECLARE(PG_rl_palette, (PG_palette *pal)),
 SC_DECLARE(PG_show_palettes, 
            (PG_device *sdev, char *type, int wbck)),
 SC_DECLARE(PG_show_colormap, (char *type, int wbck)),
 SC_DECLARE(PG_dump_colormap, (char *type, char *file));

extern PG_palette
 *SC_DECLARE(PG_get_palette, (PG_device *dev, char *name)),
 *SC_DECLARE(PG_set_palette, (PG_device *dev, char *name)),
 *SC_DECLARE(PG_make_palette, (PG_device *tdev, char *name,
			       int nclr, int wbck)),
 *SC_DECLARE(PG_make_ndim_palette, (PG_device *tdev, char *name,
				    int ndims, int *dims,  int wbck)),
 *SC_DECLARE(PG_rd_palette, (PG_device *dev, char *fname));


/* GSCNTR.C declarations */

extern PG_picture_desc
 *SC_DECLARE(PG_setup_picture_contour,
	     (PG_device *dev, PG_graph *data, int save, int clear));

extern void
 SC_DECLARE(PG_iso_limit, 
            (REAL *a, int npts, REAL *pmin, REAL *pmax)),
 SC_DECLARE(PG_contour_plot, (PG_device *dev, PG_graph *data, ...)),
 SC_DECLARE(PG_draw_iso_zc_lr, 
            (PG_device *dev, REAL *a, REAL *rx, REAL *ry,
             REAL *lev, int nlev, int labl, byte *cnnct,
	     pcons *alist)),
 SC_DECLARE(PG_draw_iso_nc_lr, 
            (PG_device *dev, REAL *a, REAL *rx, REAL *ry,
             REAL *lev, int nlev, int labl, byte *cnnct,
	     pcons *alist)),
 SC_DECLARE(PG_draw_iso_zc_ac, 
            (PG_device *dev, REAL *a, REAL *rx, REAL *ry,
             REAL *lev, int nlev, int labl, byte *cnnct,
	     pcons *alist)),
 SC_DECLARE(PG_draw_iso_nc_ac, 
            (PG_device *dev, REAL *a, REAL *rx, REAL *ry,
             REAL *lev, int nlev, int labl, byte *cnnct,
	     pcons *alist));


/* GSDLIN.C declarations */

extern void
 SC_DECLARE(PG_draw_polyline,
	    (PG_device *dev, REAL *x, REAL *y, int n, int clip)),
 SC_DECLARE(PG_draw_multiple_line,
	    (PG_device *dev, int nlines, double x1, double y1,
	     double x2, double y2, double x3, double y3,
	     double x4, double y4, REAL *dx)),
 SC_DECLARE(PG_draw_disjoint_polyline_3,
	    (PG_device *dev, REAL *x, REAL *y, REAL *z,
	     double theta, double phi, double chi,
	     long n, int flag, int norm)),
 SC_DECLARE(PG_draw_rad,
	    (PG_device *dev, double rmin, double rmax,
	     double a, double x, double y, int unit)),
 SC_DECLARE(PG_draw_arc,
	    (PG_device *dev, double r, double a1, double a2,
	     double x, double y, int unit));


/* GSDPLT.C declarations */

extern PG_picture_desc
 *SC_DECLARE(PG_setup_picture_mesh,
	     (PG_device *dev, PG_graph *data, int save, int clear));

extern void
 SC_DECLARE(PG_mesh_plot, (PG_device *dev, PG_graph *data, ...)),
 SC_DECLARE(PG_domain_plot, 
            (PG_device *dev, PM_set *dom, PM_set *ran)),
 SC_DECLARE(PG_draw_domain_boundary, (PG_device *dev, PM_mapping *f)),
 SC_DECLARE(PG_ref_mesh, (PG_device *dev, PG_graph *data, int ndims,
			  REAL nvxmn, REAL nvxmx, REAL nvymn,
			  REAL nvymx, REAL *vwprt));


/* GSDV.C declarations */

extern void
 SC_DECLARE(PG_setup_cgm_device, (PG_device *d)),
 SC_DECLARE(PG_setup_ps_device, (PG_device *d)),
 SC_DECLARE(PG_setup_window_device, (PG_device *d, int isvis)),
 SC_DECLARE(PG_query_device, 
            (PG_device *dev, int *pdx, int *pdy, int *pnc)),
 SC_DECLARE(PG_query_window, (PG_device *dev, int *pdx, int *pdy)),
 SC_DECLARE(PG_register_range_extrema, (PG_device *dev, int nd, REAL *extr));

extern PG_device
 *SC_DECLARE(PG_open_device,
	     (PG_device *dev, double xf, double yf, double dxf, double dyf));

extern char
 *SC_DECLARE(PG_wind_fgets, (char *str, int maxlen, FILE *stream));

extern int
 SC_DECLARE(PG_fprintf, (FILE *fp, char *fmt, ...)),
 SC_DECLARE(PG_write_NDC,
	    (PG_device *dev, double x, double y, char *fmt, ...)),
 SC_DECLARE(PG_write_WC,
	    (PG_device *dev, double x, double y, char *fmt, ...)),
 SC_DECLARE(PG_wind_fprintf, (FILE *fp, char *fmt, ...));

#ifdef MPW

extern char
 *SC_DECLARE(_PG_c_str_pascal, (char *s));

#endif

#ifdef __MWERKS__

extern char
 *SC_DECLARE(_PG_c_str_pascal, (char *s));

#endif


/* GSFIA.C declarations */

extern PG_view_attributes
 *SC_DECLARE(PG_view_attributes_pointer, (int vwatid));


/* GSGROT.C declarations */

extern void
 SC_DECLARE(PG_grotrian_plot, 
            (PG_device *dev, PG_graph *data, ...));


/* GSDV_IM.C declarations */

extern void
 SC_DECLARE(PG_setup_image_device, (PG_device *d));


/* GSDV_RST.C declarations */

extern void
 SC_DECLARE(_PG_rl_rst_fonts, (void));


/* GSIMAG.C declarations */

extern PG_picture_desc
 *SC_DECLARE(PG_setup_picture_image,
	     (PG_device *dev, PG_graph *data, int save, int clear));

extern void
 SC_DECLARE(PG_image_picture_info,
	    (PG_graph *data, int *pnd,
	     REAL *pxmn, REAL *pxmx, REAL *pymn, REAL *pymx,
	     REAL *pzmn, REAL *pzmx)),
 SC_DECLARE(PG_image_plot, 
            (PG_device *dev, PG_graph *data, ...)),
 SC_DECLARE(PG_draw_image_zc_lr,
	    (PG_device *dev, char *name, char *type, byte *f,
	     double xmn, double xmx, double ymn, double ymx,
	     double fmn, double fmx, byte *cnnct, pcons *alist)),
 SC_DECLARE(PG_draw_image_nc_lr,
	    (PG_device *dev, char *name, char *type, byte *f,
	     double xmn, double xmx, double ymn, double ymx,
	     double fmn, double fmx, byte *cnnct, pcons *alist)),
 SC_DECLARE(PG_draw_palette,
	    (PG_device *dev, double xmn, double ymn,
	     double xmx, double ymx, double zmn, double zmx,
	     double wid)),
 SC_DECLARE(PG_draw_2dpalette,
	    (PG_device *dev, double xmn, double ymn,
	     double xmx, double ymx, double z1mn, double z1mx,
	     double z2mn, double z2mx, double wid)),
 SC_DECLARE(_PG_intp_byte,
	    (unsigned char *op, unsigned char *np, int ox, int nx,
	     int os, int ns)),
 SC_DECLARE(PG_invert_image_data, (unsigned char *bf,
				   int kx, int lx, int bpi)),
 SC_DECLARE(PG_invert_image, (PG_image *im)),
 SC_DECLARE(PG_get_viewport_size,
	    (PG_device *dev, int *pix, int *piy, int *pnx, int *pny)),
 SC_DECLARE(PG_draw_image, 
            (PG_device *dev, PG_image *im, char *label,
	     pcons *alst)),
 SC_DECLARE(PG_rl_image, (PG_image *im));

extern PG_image
 *SC_DECLARE(PG_build_image,
	     (PG_device *dev, char *name, char *type, byte *z,
	      int kmax, int lmax,
	      double xmin, double xmax, double ymin, double ymax,
	      double zmin, double zmax)),
 *SC_DECLARE(PG_make_image,
	     (char *label, char *type, byte *z, double xmn, double xmx,
	      double ymn, double ymx, double zmn, double zmx,
	      int k, int l, int bits_pix, PG_palette *palette)),
 *SC_DECLARE(PG_extract_image, (PG_device *dev, int ix, int iy, int nx, int ny,
				double zmn, double zmx));

extern int
 SC_DECLARE(PG_render_data_type, (PG_graph *data)),
 SC_DECLARE(PG_copy_image, (PG_image *dim, PG_image *sim, int bck)),
 SC_DECLARE(PG_place_image, (PG_image *dim, PG_image *sim, int scale)),
 SC_DECLARE(PG_shift_image_range, (PG_image *a, PG_image *b, int off)),
 SC_DECLARE(_PG_allocate_image_buffer, 
            (PG_device *dev, unsigned char **pbf,
	     int *pnx, int *pny)),
 SC_DECLARE(_PG_byte_bit_map, 
            (unsigned char *bf, int nx, int ny, int complmnt)),
 SC_DECLARE(_PG_map_image_color, (PG_device *dev, int pc, int fc, int bc));


/* GSCRV.C declarations */

extern PG_picture_desc
 *SC_DECLARE(PG_setup_picture_curve,
	     (PG_device *dev, PG_graph *data, int save, int clear));

extern void
 SC_DECLARE(PG_curve_plot, (PG_device *dev, PG_graph *data, ...)),
 SC_DECLARE(_PG_print_graph_labels, (PG_device *dev, PG_graph *data)),
 SC_DECLARE(PG_plot_curve,
	    (PG_device *dev, REAL *x, REAL *y,
	     int n, pcons *info, int l)),
 SC_DECLARE(PG_draw_data_ids,
	    (PG_device *dev, REAL *x, REAL *y, int n,
	     int label, pcons *info)),
 SC_DECLARE(PG_rect_plot,
	    (PG_device *dev, REAL *x, REAL *y, int n, int lncol,
	     double lnwid, int lnsty, int scatter, int marker, int l)),
 SC_DECLARE(PG_histogram_plot,
	    (PG_device *dev, REAL *x, REAL *y, int n,
	     int lncol, double lnwid, int lnsty,
	     int scatter, int marker, int start, int l)),
 SC_DECLARE(PG_insel_plot,
	    (PG_device *dev, REAL *x, REAL *y, int n,
	     int lncol, double lnwid, int lnsty, int l)),
 SC_DECLARE(PG_polar_plot,
	    (PG_device *dev, REAL *x, REAL *y, int n, int lncol,
	     double lnwid, int lnsty, int scatter, int marker, int l));


/* GSHIGH.C declarations */

extern pcons
 *SC_DECLARE(PG_set_plot_type, (pcons *info, int plt, int axs));

extern void
 SC_DECLARE(PG_clip_polygon,
	    (PG_device *dev, REAL *tx, REAL *ty, int *ptn,
	     REAL *x, REAL *y, int n)),
 SC_DECLARE(PG_clip_data,
	    (PG_device *dev, REAL *tx, REAL *ty, int *ptn,
	     REAL *x, REAL *y, int n)),
 SC_DECLARE(PG_clip_line,
	    (int *pfl,
	     REAL *px1, REAL *py1, REAL *px2, REAL *py2,
	     double xmn, double xmx, double ymn, double ymx,
	     int xlf, int ylf)),
 SC_DECLARE(PG_center_label, (PG_device *dev, double sy, char *label)),
 SC_DECLARE(PG_set_limits,
	    (PG_device *dev, REAL *x, REAL *y, int n, int type));


/* GSREND.C declarations */

extern int
 SC_DECLARE(PG_get_processor_number, (byte)),
 SC_DECLARE(PG_get_number_processors, (byte)),
 SC_DECLARE(PG_est_rendering, (PG_graph *data));

extern void
 SC_DECLARE(PG_find_extrema, (PG_graph *data, REAL stdoff,
			      REAL **pdpex, REAL **prpex,
			      int *pnde, REAL **pddex,
			      int *pnre, REAL **prdex)),
 SC_DECLARE(PG_draw_picture,
	    (PG_device *dev, PM_mapping *f, int ptyp,
	     int bndp, int cbnd, int sbnd, double wbnd,
	     int mshp, int cmsh, int smsh, double wmsh)),
 SC_DECLARE(PG_finish_picture,
	    (PG_device *dev, PG_graph *data, PG_picture_desc *pd)),
 SC_DECLARE(PG_draw_graph, (PG_device *dev, PG_graph *data));

extern PG_picture_desc
 *SC_DECLARE(PG_setup_picture,
	     (PG_device *dev, PG_graph *data, int save, int clear, int par)),
 *SC_DECLARE(PG_get_rendering_properties, (PG_device *dev, PG_graph *data));


/* GSHLS.C declarations */

extern int
 SC_DECLARE(PG_hls_remove, (char *type, 
			    REAL *rx, REAL *ry, REAL *rz, REAL *dextr, REAL *f,
			    double theta, double phi, double chi,
			    byte *cnnct, pcons *alst,
			    REAL **prx, REAL **pry, REAL **prz, REAL **pf,
			    int *pn));


/* GSIOB.C declarations */

extern PG_device
 *SC_DECLARE(PG_handle_button_press, (byte *d, PG_event *ev)),
 *SC_DECLARE(PG_handle_key_press, (byte *d, PG_event *ev));

extern PG_interface_object
 *SC_DECLARE(PG_get_object_event, 
             (PG_device *dev, PG_event *ev));

extern void
 SC_DECLARE(PG_define_region,
	    (PG_device *dev, int coord, REAL *pxmn, REAL *pxmx,
	     REAL *pymn, REAL *pymx)),
 SC_DECLARE(PG_print_pointer_location,
	    (PG_device *dev, double cx, double cy, int coord)),
 SC_DECLARE(PG_register_callback, (char *name, PFVoid fnc)),
 SC_DECLARE(PG_register_variable,
	    (char *name, char *type, byte *var, byte *vn, byte *vx)),
 SC_DECLARE(PG_move_object,
	    (PG_interface_object *iob,
	     int ixmn, int ixmx, int iymn, int iymx, int redraw)),
 SC_DECLARE(PG_draw_interface_object, 
            (PG_interface_object *iob)),
 SC_DECLARE(PG_draw_interface_objects, (PG_device *dev)),
 SC_DECLARE(PG_register_interface_object,
	    (PG_device *dev, PG_interface_object *iob)),
 SC_DECLARE(PG_add_button,
	    (PG_device *dev, double xmn, double xmx,
	     double ymn, double ymx, char *s, PFVoid fnc));


/* GSMM.C declarations */

extern PG_graph
 *SC_DECLARE(PG_make_graph_1d,
	     (int id, char *label, int cp, int n, REAL *x, REAL *y,
	      char *xname, char *yname)),
 *SC_DECLARE(PG_make_graph_r2_r1,
	     (int id, char *label, int cp, int kmax, int lmax,
	      int centering, REAL *x, REAL *y,
	      REAL *r, char *dname, char *rname)),
 *SC_DECLARE(PG_make_graph_from_sets,
	     (char *name, PM_set *domain, PM_set *range,
	      int centering, char *info_type, byte *info,
	      int id, PG_graph *next)),
 *SC_DECLARE(PG_make_graph_from_mapping,
	     (PM_mapping *f, char *info_type, byte *info,
	      int id, PG_graph *next));

extern PG_device
 *SC_DECLARE(PG_make_device, 
             (char *name, char *type, char *title));

extern PG_view_attributes
 *SC_DECLARE(PG_make_view_attributes, (PG_device *dev));

extern PG_font_family
 *SC_DECLARE(PG_make_font_family,
	     (PG_device *dev, char *name,
	      PG_font_family *next, int n, ...));

extern PG_interface_object
 *SC_DECLARE(PG_make_interface_object,
	     (PG_device *dev, char *name, char *type, byte *obj,
	      int align, double ang, PG_curve *crv, int *flags,
	      int fc, int bc,
	      char *select, char *draw, char *action,
	      PG_interface_object *parent,
	      PG_interface_object **children));

extern PG_curve
 *SC_DECLARE(PG_make_curve,
	     (PG_device *dev, int mode, int closed, int n,
	      double xo, double yo, REAL *xd, REAL *yd)),
 *SC_DECLARE(PG_make_box_curve,
	     (PG_device *dev, int mode,
	      double xo, double yo,
	      double xmn, double xmx, double ymn, double ymx));

extern pcons
 *SC_DECLARE(PG_set_line_info,
	     (pcons *info, int type, int axis_type,
	      int style, int scatter, int marker,
	      int color, int start, double width)),
 *SC_DECLARE(PG_set_tds_info,
	     (pcons *info, int type, int axis_type,
	      int style, int color, int nlev, double ratio,
	      double width, double theta, double phi, double chi,
	      double d)),
 *SC_DECLARE(PG_set_tdv_info,
	     (pcons *info, int type, int axis_type, 
	      int style, int color, double width));

extern void
 SC_DECLARE(PG_rl_all, (byte)),
 SC_DECLARE(PG_register_device, (char *name, PFVoid fnc)),
 SC_DECLARE(PG_rl_graph, (PG_graph *g, int rld, int rlr)),
 SC_DECLARE(_PG_rl_interface_object, 
            (PG_interface_object *iob, int flag)),
 SC_DECLARE(_PG_rl_device, (PG_device *dev)),
 SC_DECLARE(PG_save_view_attributes, 
            (PG_view_attributes *d, PG_device *dev)),
 SC_DECLARE(PG_restore_view_attributes,
	    (PG_device *dev, PG_view_attributes *d)),
 SC_DECLARE(PG_release_curve, (PG_curve *reg));

extern int
 SC_DECLARE(PG_init_parallel, (char **argv, PROCESS *pp)),
 SC_DECLARE(PG_fin_parallel, (int trm));


/* GSMOUS.C declarations */

#if 0
#ifdef DOS

extern void
 SC_DECLARE(PG_show_mouse, (byte)),
 SC_DECLARE(PG_hide_mouse, (byte)),
 SC_DECLARE(PG_set_mouse_position, (int x, int y)),
 SC_DECLARE(PG_set_mouse_dx, (int xmn, int xmx)),
 SC_DECLARE(PG_set_mouse_dy, (int ymn, int ymx)),
 SC_DECLARE(PG_set_mouse_gr_cursor, (PG_mouse_cursor *cursor)),
 SC_DECLARE(PG_set_mouse_tx_cursor,
	    (int type, unsigned int arg1, unsigned int arg2)),
 SC_DECLARE(PG_install_mouse_hook, 
            (unsigned int mask, PFInt handler)),
 SC_DECLARE(PG_mouse_light_pen_on, (byte)),
 SC_DECLARE(PG_mouse_light_pen_off, (byte)),
 SC_DECLARE(PG_set_mouse_ratio, (int x, int y));

extern PG_mouse_state
 *SC_DECLARE(PG_reset_mouse, (byte));

extern PG_mouse_location
 *SC_DECLARE(PG_get_mouse_position, (byte)),
 *SC_DECLARE(PG_get_mouse_pressed, (int button)),
 *SC_DECLARE(PG_get_mouse_released, (int button));

extern PG_mouse_motion
 *SC_DECLARE(PG_get_mouse_motion, (byte));

#endif
#endif

/* GSPR.C declarations */

extern PFByte
 SC_DECLARE(PG_set_expose_event_handler,
	    (PG_device *dev, PFByte fnc)),
 SC_DECLARE(PG_set_update_event_handler,
	    (PG_device *dev, PFByte fnc)),
 SC_DECLARE(PG_set_mouse_down_event_handler,
	    (PG_device *dev, PFByte fnc)),
 SC_DECLARE(PG_set_mouse_up_event_handler,
	    (PG_device *dev, PFByte fnc)),
 SC_DECLARE(PG_set_motion_event_handler,
	    (PG_device *dev, PFByte fnc)),
 SC_DECLARE(PG_set_key_down_event_handler,
	    (PG_device *dev, PFByte fnc)),
 SC_DECLARE(PG_set_key_up_event_handler,
	    (PG_device *dev, PFByte fnc)),
 SC_DECLARE(PG_set_default_event_handler,
	    (PG_device *dev, PFByte fnc));

extern PG_dev_attributes
 *SC_DECLARE(PG_get_attributes, (PG_device *dev));

extern void
 SC_DECLARE(PG_get_fill_color, (PG_device *dev, int *pcl)),
 SC_DECLARE(PG_get_line_color, (PG_device *dev, int *pcl)),
 SC_DECLARE(PG_get_text_color, (PG_device *dev, int *pcl)),
 SC_DECLARE(PG_get_char_space, (PG_device *dev, REAL *pcsp)),
 SC_DECLARE(PG_get_char_precision, (PG_device *dev, int *pcp)),
 SC_DECLARE(PG_get_curve_extent, (PG_device *dev, PG_curve *crv,
				  int mode, REAL *pxmn, REAL *pxmx,
				  REAL *pymn, REAL *pymx)),
 SC_DECLARE(PG_get_frame,
	    (PG_device *dev, REAL *xmn, REAL *xmx, 
	     REAL *ymn, REAL *ymx)),
 SC_DECLARE(PG_get_bound_PC, (PG_device *dev,
			      int *ixmn, int *ixmx, int *iymn, int *iymx)),
 SC_DECLARE(PG_get_bound_NDC, (PG_device *dev,
			       REAL *xmn, REAL *xmx, REAL *ymn, REAL *ymx)),
 SC_DECLARE(PG_get_bound_WC, (PG_device *dev,
			      REAL *xmn, REAL *xmx, REAL *ymn, REAL *ymx)),
 SC_DECLARE(PG_get_viewport_PC, (PG_device *dev,
				 int *ixmn, int *ixmx, int *iymn, int *iymx)),
 SC_DECLARE(PG_get_viewport_NDC, (PG_device *dev,
				  REAL *xmn, REAL *xmx, REAL *ymn, REAL *ymx)),
 SC_DECLARE(PG_get_viewport_WC, (PG_device *dev,
				 REAL *xmn, REAL *xmx, REAL *ymn, REAL *ymx)),
 SC_DECLARE(PG_get_viewport, (PG_device *dev,
			      REAL *xmn, REAL *xmx, REAL *ymn, REAL *ymx)),
 SC_DECLARE(PG_get_text_ext, 
            (PG_device *dev, char *s, REAL *px, REAL *py)),
 SC_DECLARE(PG_get_line_width, (PG_device *dev, REAL *plw)),
 SC_DECLARE(PG_get_char_up, (PG_device *dev, REAL *px, REAL *py)),
 SC_DECLARE(PG_get_clipping, (PG_device *dev, int *flag)),
 SC_DECLARE(PG_get_font, 
            (PG_device *dev, char **pf, char **pst, int *psz)),
 SC_DECLARE(PG_get_char_size_NDC, (PG_device *dev, REAL *pw, REAL *ph)),
 SC_DECLARE(PG_get_char_size, (PG_device *dev, REAL *pw, REAL *ph)),
 SC_DECLARE(PG_get_line_style, (PG_device *dev, int *pl)),
 SC_DECLARE(PG_get_logical_op, (PG_device *dev, int *plop)),
 SC_DECLARE(PG_get_char_path, (PG_device *dev, REAL *px, REAL *py)),
 SC_DECLARE(PG_set_attributes, 
            (PG_device *dev, PG_dev_attributes *attr)),
 SC_DECLARE(_PG_find_clip_region,
	    (PG_device *dev, double xmn, double xmx,
	     double ymn, double ymx,
	     int *px0, int *py0, int *px1, int *py1,
	     int flag, int swflag)),
 SC_DECLARE(PG_setup_markers, (byte)),
 SC_DECLARE(PG_draw_markers,
	    (PG_device *dev, int n, REAL *x, REAL *y, int marker)),
 SC_DECLARE(PG_set_viewport,
	    (PG_device *dev, double x1, double x2, double y1, double y2)),
 SC_DECLARE(PG_frame_viewport, (PG_device *dev, REAL *x1, REAL *y1,
				REAL *x2, REAL *y2)),
 SC_DECLARE(PG_set_frame,
	    (PG_device *dev, double x1, double x2, double y1, double y2)),
 SC_DECLARE(PG_get_axis_log_scale,
	    (PG_device *dev, int *pxls, int *pyls)),
 SC_DECLARE(PG_set_axis_log_scale,
	    (PG_device *dev, int xls, int yls)),
 SC_DECLARE(_PG_set_bound,
	    (PG_device *dev, double xmn, double xmx,
	     double ymn, double ymx)),
 SC_DECLARE(PG_set_window,
	    (PG_device *dev, double xmn, double xmx,
	     double ymn, double ymx)),
 SC_DECLARE(PG_draw_box,
	    (PG_device *dev, double xmin, double xmax,
	     double ymin, double ymax)),
 SC_DECLARE(PG_draw_line,
	    (PG_device *dev, double x1, double y1, double x2, double y2));

extern int
 SC_DECLARE(PG_def_marker, 
            (int n, REAL *x1, REAL *y1, REAL *x2, REAL *y2)),
 SC_DECLARE(PG_setup_font,
	    (PG_device *dev, char *face, char *style, int size,
	     char **pfn, int *pnf, int *pns)),
 SC_DECLARE(_PG_trans_color, (PG_device *dev, int color));

/* GSPR_PS.C declarations */

extern void
 SC_DECLARE(_PG_PS_set_dev_color,
            (PG_device *dev, int prim));

/* GSRWI.C declarations */

extern int
 SC_DECLARE(PG_write_interface, (PG_device *dev, char *name)),
 SC_DECLARE(PG_read_interface, (PG_device *dev, char *name));

extern void
 SC_DECLARE(_PG_parent_limits_NDC,
	    (PG_device *dev, PG_interface_object *parent,
	     REAL *pxmn, REAL *pymn, REAL *pdx, REAL *pdy));


/* GSSCAT.C declarations */

extern PG_picture_desc
 *SC_DECLARE(PG_setup_picture_scatter,
	     (PG_device *dev, PG_graph *data, int save, int clear));

extern void
 SC_DECLARE(PG_scatter_plot, (PG_device *dev, PG_graph *data, ...)),
 SC_DECLARE(PG_draw_scatter,
	    (PG_device *dev, REAL *a1, REAL *a2,
	     int nn, int ne, REAL **x,
	     double theta, double phi, double chi, double width,
	     int color, int style, int type, char *name,
	     pcons *alist));


/* GSSURF.C declarations */

extern PG_picture_desc
 *SC_DECLARE(PG_setup_picture_surface,
	     (PG_device *dev, PG_graph *data, int save, int clear));

extern void
 SC_DECLARE(PG_surface_plot, (PG_device *dev, PG_graph *data, ...)),
 SC_DECLARE(PG_draw_surface,
	    (PG_device *dev, REAL *a1, REAL *a2, REAL *aext,
	     REAL *x, REAL *y, int nn,
	     double xmn, double xmx,
	     double ymn, double ymx,
	     double theta, double phi, double chi, double width,
	     int color, int style, int type, char *name,
	     char *mesh_type, byte *cnnct, pcons *alist)),
 SC_DECLARE(PG_axis_3d,
	    (PG_device *dev, REAL *px, REAL *py, REAL *pz,
	     int n_pts, double theta, double phi, double chi,
	     double xmn, double xmx, double ymn, double ymx,
	     double zmn, double zmx, int norm)),
 SC_DECLARE(PG_axis_3d_limits,
	    (PG_device *dev, REAL *px, REAL *py, REAL *pz,
	     int n_pts, double theta, double phi, double chi,
	     int norm, int offs, int wcflag,
	     double xmn, double xmx, double ymn,
	     double ymx, double zmn, double zmx,
	     REAL *p1, REAL *p2, REAL *p3)),
 SC_DECLARE(PG_rotate_3d_WC,
	    (REAL *px, REAL *py, REAL *pz,
	     double xmn, double xmx, double ymn, double ymx,
	     double zmn, double zmx, double theta, double phi, double chi,
	     REAL *rx, REAL *ry, REAL *rz, int n, int norm));


/* GSPOLF.C declarations */

extern PG_picture_desc
 *SC_DECLARE(PG_setup_picture_fill_poly,
	     (PG_device *dev, PG_graph *data, int save, int clear));

extern void
 SC_DECLARE(PG_poly_fill_plot, (PG_device *dev, PG_graph *data, ...)),
 SC_DECLARE(PG_fill_poly_zc_lr, (PG_device *dev, int nd, REAL **a,
				 REAL *x, REAL *y, REAL *aext, byte *cnnct,
				 pcons *alist)),
 SC_DECLARE(PG_fill_poly_nc_lr, (PG_device *dev, int nd, REAL **a,
				 REAL *x, REAL *y, REAL *aext, byte *cnnct,
				 pcons *alist)),
 SC_DECLARE(PG_fill_poly_zc_ac, (PG_device *dev, int nd, REAL **a,
				 REAL *x, REAL *y, REAL *aext, byte *cnnct,
				 pcons *alist)),
 SC_DECLARE(PG_fill_poly_nc_ac, (PG_device *dev, int nd, REAL **a,
				 REAL *x, REAL *y, REAL *aext, byte *cnnct,
				 pcons *alist));


/* GSDVB.C declarations */

extern PG_picture_desc
 *SC_DECLARE(PG_setup_picture_dv_bnd,
	     (PG_device *dev, PG_graph *data, int save, int clear));

extern void
 SC_DECLARE(PG_dv_bnd_plot, (PG_device *dev, PG_graph *data, ...)),
 SC_DECLARE(PG_dv_bnd_zc_lr, (PG_device *dev, int nd, int *a,
			      REAL *x, REAL *y, int npts, int *aext,
			      byte *cnnct, pcons *alist)),
 SC_DECLARE(PG_dv_bnd_zc_ac, (PG_device *dev, int nd, int *a,
			      REAL *x, REAL *y, int npts, int *aext,
			      byte *cnnct, pcons *alist));


/* GSTXT.C declarations */

extern PG_text_box
 *SC_DECLARE(PG_open_text_rect, (PG_device *dev, char *name, int type,
				 PFByte *keymap, PG_curve *crv)),
 *SC_DECLARE(PG_open_text_box, (PG_device *dev, char *name, int type,
				PFByte *keymap,
				double xf, double yf,
				double dxf, double dyf));

extern void
 SC_DECLARE(PG_refresh_text_box, (PG_text_box *b)),
 SC_DECLARE(PG_close_text_box, (PG_text_box *b)),
 SC_DECLARE(_PG_draw_cursor, (PG_text_box *b, int inv));


/* GSVECT.C declarations */

extern PG_picture_desc
 *SC_DECLARE(PG_setup_picture_vector,
	     (PG_device *dev, PG_graph *data, int save, int clear));

extern void
 SC_DECLARE(PG_vector_plot, (PG_device *dev, PG_graph *data, ...)),
 SC_DECLARE(PG_draw_vector, (PG_device *dev, PG_graph *g)),
 SC_DECLARE(PG_draw_vct_zc_lr, (PG_device *dev, REAL *ux, REAL *uy,
				REAL*rx, REAL *ry,
				byte *cnnct, pcons *alist)),
 SC_DECLARE(PG_draw_vct_nc_lr, (PG_device *dev, REAL *ux, REAL *uy,
				REAL*rx, REAL *ry,
				byte *cnnct, pcons *alist)),
 SC_DECLARE(PG_draw_vct_zc_ac, (PG_device *dev, REAL *ux, REAL *uy,
				REAL*rx, REAL *ry,
				byte *cnnct, pcons *alist)),
 SC_DECLARE(PG_draw_vct_nc_ac, (PG_device *dev, REAL *ux, REAL *uy,
				REAL*rx, REAL *ry,
				byte *cnnct, pcons *alist)),
 SC_DECLARE(_PG_draw_vct, (PG_device *dev, REAL *x, REAL *y,
			   REAL *u, REAL *v, int npts)),
 SC_DECLARE(PG_set_vec_attr, (PG_device *dev, ...));

#ifdef __cplusplus
}
#endif

#endif


