/*
 * GSMPGTST1.c - 1st mpeg test, a moving sine curve
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"
#include "gsrast.h"

#define N_MPG 10
#define N 100
#define TWOPI 2.0*3.1415926535897931
#define XCON TWOPI/N
#define YCON TWOPI/N_MPG
int ids = 0;

int main(argc, argv)
   int argc;
   char *argv[];
   {int i, n, label;
    REAL *x, *y;
    PG_graph *data;
    PG_device *dev;

    /*PG_register_device("MPEG", PG_setup_mpeg_device);*/
    dev = PG_make_device("MPEG", "COLOR", "mpgtst1");
    PG_open_device(dev, 0.0, 0.0, 512.0, 512.0);

    x = FMAKE_N(REAL, N, "MPGTST.C:x");
    y = FMAKE_N(REAL, N, "MPGTST.C:y");
    label = 'A';

    for (n = 0; n < N_MPG; n++)
        {for (i = 0; i < N; i++)
	     {x[i] = XCON*i;
	      y[i] = sin(x[i]+YCON*n);}

	 data = PG_make_graph_1d(label++, "Test Data #1", FALSE, N,
				 x, y, "X Values", "Y Values");
	 PG_turn_data_id(dev, ids);
	 data->info = (byte *) PG_set_line_info(data->info, 
						CARTESIAN, CARTESIAN, 
						SOLID, FALSE, 0,
						dev->BLUE, 0, 0.0);
	 PG_draw_graph(dev, data);}

    PG_rl_graph(data, TRUE, TRUE);
    PG_close_device(dev);
    PG_rl_all();

    return(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
