/*
 * GSDV_SUN.C - PGS SunCore routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
  
#include "pgs.h"

#define PHYSICAL_PIXEL_WIDTH  1152
#define PHYSICAL_PIXEL_HEIGHT  900

#include <sunwindow/window_hs.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sun/fbio.h>
#include <stdio.h>
#include <usercore.h>

static int
 n_screen_opens = 0;

int
 cgpixwindd(),
 gp1pixwindd(),
 pixwindd(),
 bw1dd(),
 bw2dd(),
 cg1dd(),
 cg2dd(),
 gp1dd();

char *getenv();

static int
 SC_DECLARE(_PG_sun_setup_font, (PG_device *dev, char *bf)),
 SC_DECLARE(_PG_sun_open_console,
         (char *title, char *type, int bckgr,
          double xf, double yf, double dxf, double dyf));

static PG_device
 SC_DECLARE(*_PG_sun_open_screen,
         (PG_device *dev, double xf, double yf, double dxf, double dyf));

static void
 SC_DECLARE(_PG_sun_query_pointer,
         (PG_device *dev, int *px, int *py, int *pb)),
 SC_DECLARE(_PG_sun_clear_page, (PG_device *dev, int i)),
 SC_DECLARE(_PG_sun_clear_window, (PG_device *dev)),
 SC_DECLARE(_PG_sun_clear_viewport, (PG_device *dev)),
 SC_DECLARE(_PG_sun_clear_region_NDC,
         (PG_device *dev, double xmn, double xmx,
          double ymn, double ymx, int pad)),
 SC_DECLARE(_PG_sun_close_console, (byte)),
 SC_DECLARE(_PG_sun_close_device, (PG_device *dev)),
 SC_DECLARE(_PG_sun_expose_device, (PG_device *dev)),
 SC_DECLARE(_PG_sun_finish_plot, (PG_device *dev)),
 SC_DECLARE(_PG_sun_make_device_current, (PG_device *dev)),
 SC_DECLARE(_PG_sun_map_to_color_table, 
            (PG_device *dev, PG_palette *pal)),
 SC_DECLARE(_PG_sun_next_line, (PG_device *dev)),
 SC_DECLARE(_PG_sun_puts, (char *bf)),
 SC_DECLARE(_PG_sun_query_screen,
         (PG_device *dev, int *pdx, int *pdy, int *pnc)),
 SC_DECLARE(_PG_sun_release_current_device, (PG_device *dev)),
 SC_DECLARE(_PG_sun_update_vs, (PG_device *dev)),
 SC_DECLARE(_PG_sun_write_text, (PG_device *dev, FILE *fp, char *s));

/* from the corresponding PR file */

int
 SC_DECLARE(_PG_sun_set_font,
         (PG_device *dev, char *face, char *style, int size));

void
 SC_DECLARE(_PG_sun_draw_disjoint_polyline_2,
         (PG_device *dev, REAL *x, REAL *y,
          long n, int flag, int coord)),
 SC_DECLARE(_PG_sun_draw_curve, 
            (PG_device *dev, PG_curve *crv, int clip)),
 SC_DECLARE(_PG_sun_draw_to_abs, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_sun_draw_to_rel, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_sun_get_text_ext_NDC,
         (PG_device *dev, char *s, REAL *px, REAL *py)),
 SC_DECLARE(_PG_sun_set_bound,
         (PG_device *dev, double xmn, double xmx,
          double ymn, double ymx)),
 SC_DECLARE(_PG_sun_set_clipping, (PG_device *dev, int flag)),
 SC_DECLARE(_PG_sun_set_char_line, (PG_device *dev, int n)),
 SC_DECLARE(_PG_sun_set_char_path, 
            (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_sun_set_char_precision, (PG_device *dev, int p)),
 SC_DECLARE(_PG_sun_set_char_space, (PG_device *dev, double s)),
 SC_DECLARE(_PG_sun_set_char_size_NDC, 
            (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_sun_set_char_up, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_sun_set_fill_color, 
            (PG_device *dev, int color, int mapped)),
 SC_DECLARE(_PG_sun_set_line_color, 
            (PG_device *dev, int color, int mapped)),
 SC_DECLARE(_PG_sun_set_line_style, (PG_device *dev, int style)),
 SC_DECLARE(_PG_sun_set_line_width, (PG_device *dev, double width)),
 SC_DECLARE(_PG_sun_set_logical_op, (PG_device *dev, int lop)),
 SC_DECLARE(_PG_sun_set_text_color, 
            (PG_device *dev, int color, int mapped)),
 SC_DECLARE(_PG_sun_shade_poly, 
            (PG_device *dev, REAL *x, REAL *y, int n)),
 SC_DECLARE(_PG_sun_fill_curve, (PG_device *dev, PG_curve *crv)),
 SC_DECLARE(_PG_sun_move_gr_abs, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_sun_move_tx_abs, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_sun_move_tx_rel, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_sun_get_image,
         (PG_device *dev, unsigned char *bf, int ix, int iy,
          int nx, int ny)),
 SC_DECLARE(_PG_sun_put_image,
         (PG_device *dev, unsigned char *bf, int ix, int iy,
          int nx, int ny));

PFInt
 PG_open_console_hook = _PG_sun_open_console;

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* PG_SETUP_WINDOW_DEVICE - do the device dependent device initialization
 *                        - for PG_make_device
 */

void PG_setup_window_device(d, isvis)
   PG_device *d;
   int isvis;
   {struct vwsurf *pv;

    pv = FMAKE(struct vwsurf, "PG_SETUP_WINDOW_DEVICE:pv");
    strcpy(pv->windowname, title);
    pv->screenname[0] = '\0';
    pv->windowfd      = 0;
    pv->dd            = pixwindd;
    pv->instance      = 0;
    pv->cmapsize      = 0;
    pv->cmapname[0]   = '\0';
    pv->flags         = 1;
    pv->ptr           = NULL;

    d->vwsurf         = pv;

    d->type_index     = GRAPHIC_WINDOW_DEVICE;
    d->is_visible     = isvis;

    d->query_pointer          = _PG_sun_query_pointer;
    d->clear_page             = _PG_sun_clear_page;
    d->clear_window           = _PG_sun_clear_window;
    d->clear_viewport         = _PG_sun_clear_viewport;
    d->clear_region_NDC       = _PG_sun_clear_region_NDC;
    d->close_console          = _PG_sun_close_console;
    d->close_device           = _PG_sun_close_device;
    d->draw_dj_polyln_2       = _PG_sun_draw_disjoint_polyline_2;
    d->draw_curve             = _PG_sun_draw_curve;
    d->draw_to_abs            = _PG_sun_draw_to_abs;
    d->draw_to_rel            = _PG_sun_draw_to_rel;
    d->expose_device          = _PG_sun_expose_device;
    d->finish_plot            = _PG_sun_finish_plot;
    d->get_image              = _PG_sun_get_image;
    d->get_text_ext_NDC       = _PG_sun_get_text_ext_NDC;
    d->ggets                  = (PFfgets) io_gets_hook;
    d->gputs                  = io_puts_hook;
    d->make_device_current    = _PG_sun_make_device_current;
    d->map_to_color_table     = _PG_sun_map_to_color_table;
    d->match_rgb_colors       = _PG_match_rgb_colors;
    d->move_gr_abs            = _PG_sun_move_gr_abs;
    d->move_tx_abs            = _PG_sun_move_tx_abs;
    d->move_tx_rel            = _PG_sun_move_tx_rel;
    d->next_line              = _PG_sun_next_line;
    d->open_screen            = _PG_sun_open_screen;
    d->put_image              = _PG_sun_put_image;
    d->query_screen           = _PG_sun_query_screen;
    d->release_current_device = _PG_sun_release_current_device;
    d->set_bound              = _PG_sun_set_bound;
    d->set_clipping           = _PG_sun_set_clipping;
    d->set_char_line          = _PG_sun_set_char_line;
    d->set_char_path          = _PG_sun_set_char_path;
    d->set_char_precision     = _PG_sun_set_char_precision;
    d->set_char_size_NDC      = _PG_sun_set_char_size_NDC;
    d->set_char_space         = _PG_sun_set_char_space;
    d->set_char_up            = _PG_sun_set_char_up;
    d->set_fill_color         = _PG_sun_set_fill_color;
    d->set_font               = _PG_sun_set_font;
    d->set_line_color         = _PG_sun_set_line_color;
    d->set_line_style         = _PG_sun_set_line_style;
    d->set_line_width         = _PG_sun_set_line_width;
    d->set_logical_op         = _PG_sun_set_logical_op;
    d->set_text_color         = _PG_sun_set_text_color;
    d->shade_poly             = _PG_sun_shade_poly;
    d->fill_curve             = _PG_sun_fill_curve;
    d->update_vs              = _PG_sun_update_vs;
    d->write_text             = _PG_sun_write_text;
    
    d->expose_event_handler.fnc     = NULL;
    d->update_event_handler.fnc     = NULL;
    d->mouse_down_event_handler.fnc = NULL;
    d->mouse_up_event_handler.fnc   = NULL;
    d->key_down_event_handler.fnc   = NULL;
    d->key_up_event_handler.fnc     = NULL;
    d->default_event_handler.fnc    = NULL;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_SUN_OPEN_SCREEN - initialize a "window" on a display screen */
 
static PG_device *_PG_sun_open_screen(dev, xf, yf, dxf, dyf)
   PG_device *dev;
   double xf, yf, dxf, dyf;
   {char position[MAXLINE], **t;
    int dev_width, dev_height, n_colors;
    REAL _txw0, _txh0;
    REAL view_x_max, view_y_max;
 
    PG_setup_markers();

    dev->type_index = GRAPHIC_WINDOW_DEVICE;
    dev->quadrant   = QUAD_ONE;

/* establish ndc space to be entire view surface in both dimensions */
    if (n_screen_opens == 0)
       {if (initialize_core(BASIC, NOINPUT, TWOD))
            exit(3);};

/* get the window shape in NDC */
    if ((xf == 0.0) && (yf == 0.0))
       {xf = 0.5;
        yf = 0.1;};

    if ((dxf == 0.0) && (dyf == 0.0))
       {dxf = 0.5;
        dyf = 0.5;};

    PG_query_screen(dev, &dev_width, &dev_height, &n_colors);

/* GOTCHA: The following pixel coordinate limits may be incorrect */
/* set device pixel coordinate limits */
    dev->min_pc_x = INT_MIN + dev_width;
    dev->max_pc_x = INT_MAX - dev_width;
    dev->min_pc_y = INT_MIN + dev_height;
    dev->max_pc_y = INT_MAX - dev_height;
 
/* convert the window shape info from NDC to pixels */
    dev->window_x      = xf*dev_width;
    dev->window_y      = yf*dev_height;
    dev->window_width  = dxf*dev_width;
    dev->window_height = dyf*dev_height;

/* initialize the window */
    strncpy(dev->vwsurf->windowname, getenv("WINDOW_ME"), DEVNAMESIZE);
    sprintf(position, "%d,%d,%d,%d,704,0,64,64,0",
            (int) dev->window_x, (int) dev->window_y,
            (int) dev->window_width, (int) dev->window_height);

    t                = FMAKE(char *, "_PG_SUN_OPEN_SCREEN:t");
    *t               = SC_strsavef(position,
                       "char*:_PG_SUN_OPEN_SCREEN:position");
    dev->vwsurf->ptr = t;

/* try to find an avialable view surface */
    if (get_view_surface(dev->vwsurf))
       {if (initialize_view_surface(dev->vwsurf, FALSE))
           exit(2);}
    else
       exit(2);

/* select that view surface */
    if (select_view_surface(dev->vwsurf))
       exit(3);

/* do a one time only set up of NDC space */
    if (n_screen_opens == 0)
       set_ndc_space_2(1.0, 1.0);

/* compute the viewport */
    if (dev->view_x == 0.0)
       {dev->view_x = 0.175;
        dev->view_y = 0.175;};

    if (dev->view_width == 0.0)
        dev->view_width = 0.65;

    if (dev->view_height == 0.0)
        dev->view_height = dev->view_width * dev->view_aspect;
 
    view_x_max = dev->view_x + dev->view_width;
    view_y_max = dev->view_y + dev->view_height;
 
/* initialize text size info */
    _txw0 = 1.0/TXSPAN;
    _txh0 = dev->txt_ratio*_txw0;
    PG_set_char_size_NDC(dev, _txw0, _txh0);

    create_temporary_segment();

/* initialize window to screen coordinates
 * (setview followed by setwin can change the window)
 */
    PG_set_viewport(dev, dev->view_x, view_x_max, dev->view_y, view_y_max);
    PG_set_window( dev, 0.0, 1.0, 0.0, 1.0);
 
/* initialize color tables */

/* all non-black (off) colors are white (on) */
    Color_Map(dev, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1);
/*
    dev->red_tab[0] = 0.1334;
    dev->red_tab[1] = 0.1334;
    dev->red_tab[2] = 0.4667;
    dev->red_tab[3] = 0.0000;
    dev->red_tab[4] = 0.2667;
    dev->red_tab[5] = 0.3334;
    dev->red_tab[6] = 0.5334;
    dev->red_tab[7] = 0.5334;

    dev->green_tab[0] = 0.5020;
    dev->green_tab[1] = 0.5020;
    dev->green_tab[2] = 0.5334;
    dev->green_tab[3] = 0.2667;
    dev->green_tab[4] = 0.4001;
    dev->green_tab[5] = 0.4001;
    dev->green_tab[6] = 0.4001;
    dev->green_tab[7] = 0.4001;

    dev->blue_tab[0] = 0.3529;
    dev->blue_tab[1] = 0.6471;
    dev->blue_tab[2] = 0.2118;
    dev->blue_tab[3] = 0.3882;
    dev->blue_tab[4] = 0.8001;
    dev->blue_tab[5] = 0.1334;
    dev->blue_tab[6] = 0.5334;
    dev->blue_tab[7] = 0.1334;

    define_color_indices(dev->vwsurf, 0, dev->ncolor,
                         dev->red_tab, dev->green_tab, dev->blue_tab);
*/
/* initialize line, text and fill colors */
    dev->ncolor           = n_colors;
    dev->absolute_n_color = n_colors;
/*
    set_line_index(WHITE);
    set_text_index(WHITE);
*/
    set_fill_index(3);

    close_temporary_segment();

/* initialize clipping to off */
    set_window_clipping(FALSE);
 
/* turn off this view surface */
    deselect_view_surface(dev->vwsurf);
 
/* increment the count of open display windows */
    n_screen_opens++;

    return(dev);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_SUN_QUERY_SCREEN - query some physical device characteristics */

static void _PG_sun_query_screen(dev, pdx, pdy, pnc)
   PG_device *dev;
   int *pdx, *pdy, *pnc;
   {*pdx = PHYSICAL_PIXEL_WIDTH;
    *pdy = PHYSICAL_PIXEL_HEIGHT;
    *pnc = 2;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_SUN_MAP_TO_COLOR_TABLE - map the PGS palette to host
 *                            - color table values
 */

static void _PG_sun_map_to_color_table(dev, pal)
   PG_device *dev;
   PG_palette *pal;
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_SUN_OPEN_CONSOLE - open up a special window to be used as a console or
 *                      - terminal window for systems which can't do this for
 *                      - themselves (i.e. MacIntosh) or the SINGLE SCREEN
 *                      - devices
 */
 
static int _PG_sun_open_console(title, type, bckgr, xf, yf, dxf, dyf)
   char *title, *type;
   int bckgr;
   double xf, yf, dxf, dyf;
   {REAL _txw0, _txh0;

    PG_setup_markers();

    PG_console_device = PG_make_device("SCREEN", type, title);
    PG_console_device->background_color_white = bckgr;

/* initialize text size info */
    _txw0 = 1.0/TXSPAN;
    _txh0 = PG_console_device->txt_ratio*_txw0;
    PG_set_char_size_NDC(PG_console_device, _txw0, _txh0);

    putln = (PFfprintf) PG_fprintf;
    getln = (PFfgets) dev->ggets;

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_SUN_CLOSE_DEVICE - close a device */
 
static void _PG_sun_close_device(dev)
   PG_device *dev;
   {char *loc;

    n_screen_opens--;
    if (n_screen_opens == 0)
       terminate_core();

/* clean up the device */
    _PG_rl_device(dev);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_SUN_CLOSE_CONSOLE - close the console device */
 
static void _PG_sun_close_console()
   {

/* clean up the device */
    _PG_rl_device(PG_console_device);

    PG_console_device = NULL;

/* connect I/O to standard functions */
    putln = io_printf_hook;
    getln = io_gets_hook;

    return;}

/*--------------------------------------------------------------------------*/

/*                           SCREEN STATE ROUTINES                          */

/*--------------------------------------------------------------------------*/
 
/* _PG_SUN_CLEAR_WINDOW - clear the screen */
 
static void _PG_sun_clear_window(dev)
   PG_device *dev;
   {PG_make_device_current(dev);

/* this function should destroy all existing segments for SunCore */
    close_temporary_segment();
    delete_all_retained_segments();
 
/* this will nail the temporary segments */
    new_frame();
    create_temporary_segment();
 
    PG_release_current_device(dev);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_SUN_CLEAR_VIEWPORT - clear the viewport */
 
static void _PG_sun_clear_viewport(dev)
   PG_device *dev;
   {return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_SUN_CLEAR_REGION_NDC - clear the rectangular region specified in NDC */
 
static void _PG_sun_clear_region_NDC(dev, xmn, xmx, ymn, ymx, pad)
   PG_device *dev;
   double xmn, xmx, ymn, ymx;
   int pad;
   {return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_SUN_UPDATE_VS - update the view surface for the given device */
 
static void _PG_sun_update_vs(dev)
   PG_device *dev;
   {return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_SUN_FINISH_PLOT - do what's necessary to finish up a graphical image
 *                     - and get the device updated with the image
 *                     - after this function nothing more can be added to
 *                     - the image
 */
 
static void _PG_sun_finish_plot(dev)
   PG_device *dev;
   {PG_make_device_current(dev);

    PG_update_vs(dev);

    PG_release_current_device(dev);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_SUN_CLEAR_PAGE - clear the current page
 *                    - and go to the line i on the screen
 */
 
static void _PG_sun_clear_page(dev, i)
   PG_device *dev;
   int i;
   {return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_SUN_EXPOSE_DEVICE - make this device the topmost one */
 
static void _PG_sun_expose_device(dev)
   PG_device *dev;
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_SUN_MAKE_DEVICE_CURRENT - make this device the current one for drawing
 *                             - purposes
 */
 
static void _PG_sun_make_device_current(dev)
   PG_device *dev;
   {if (vs_list == NULL)
       {vs_list  = FMAKE_N(PG_device *, 10,
                   "_PG_SUN_MAKE_DEVICE_CURRENT:vs_list");
        vs_index = 0;};

    if (dev->vwsurf->ptr != NULL)
       {vs_list[vs_index] = dev;

/* deselect the previous view surface */
        if (vs_index > 0)
           {close_temporary_segment();
            deselect_view_surface(vs_list[vs_index-1]->vwsurf);};

/* select the specified view surface */
        select_view_surface(dev->vwsurf);
        create_temporary_segment();
        vs_index++;};

    return;}
        
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_SUN_RELEASE_CURRENT_DEVICE - make no device current
 *                                - (SUN in its brilliance needs this)
 */
 
static void _PG_sun_release_current_device(dev)
   PG_device *dev;
   {if (dev->vwsurf->ptr != NULL)
       {close_temporary_segment();
        deselect_view_surface(dev->vwsurf);
        vs_index--;

        if (vs_index > 0)
           {dev = vs_list[vs_index];
            select_view_surface(dev->vwsurf);
            create_temporary_segment();};};

    return;}
        
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_SUN_WRITE_TEXT - write out text to the appropriate device */
 
static void _PG_sun_write_text(dev, fp, s)
   PG_device *dev;
   FILE *fp;
   char *s;
   {if (fp == stdscr)
       text(s);
    else
       io_printf(fp, "%s", s);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_SUN_NEXT_LINE - do a controlled newline */
 
static void _PG_sun_next_line(dev)
   PG_device *dev;
   {putchar('\n');

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* GET_VIEW_SURFACE - try SUN's way of finding a view surface */

get_view_surface(vsptr)
   struct vwsurf *vsptr;
   {int fd, devhaswindows;
    char *wptr, dev[DEVNAMESIZE];
    struct screen screen;
    struct fbtype fbtype;

    if (wptr = getenv("WINDOW_ME"))
       {devhaswindows = TRUE;
        if ((fd = open(wptr, O_RDWR, 0)) < 0)
           {io_printf(stderr, "GET_VIEW_SURFACE: CAN'T OPEN %s\n", wptr);
            return(FALSE);};
        win_screenget(fd, &screen);
        close(fd);
        strncpy(dev, screen.scr_fbname, DEVNAMESIZE);}
    else
       {devhaswindows = FALSE;
        strncpy(dev, "/dev/fb", DEVNAMESIZE);};

    if ((fd = open(dev, O_RDWR, 0)) < 0)
       {io_printf(stderr, "GET_VIEW_SURFACE: CAN'T OPEN %s\n", dev);
        return(FALSE);};

    if (ioctl(fd, FBIOGTYPE, &fbtype) == -1)
       {io_printf(stderr, "GET_VIEW_SURFACE: IOCTL FBIOGTYPE FAILED ON %s\n",
                  dev);
        close(fd);
        return(FALSE);};

    close(fd);

    if (devhaswindows)
       {switch (fbtype.fb_type)
           {case FBTYPE_SUN1BW    :
            case FBTYPE_SUN2BW    : vsptr->dd = pixwindd;
                                    break;
            case FBTYPE_SUN1COLOR :
            case FBTYPE_SUN2COLOR : vsptr->dd = cgpixwindd;
                                    break;
            case FBTYPE_SUN2GP    : vsptr->dd = gp1pixwindd;
                                    break;
            default               : io_printf(stderr,
					      "GET_VIEW_SURFACE: UNKNOWN %s\n",
					      dev);
                                    return(FALSE);};}
    else
       {switch (fbtype.fb_type)
           {case FBTYPE_SUN1BW    : vsptr->dd = bw1dd;
                                    break;
            case FBTYPE_SUN2BW    : vsptr->dd = bw2dd;
                                    break;
            case FBTYPE_SUN1COLOR : vsptr->dd = cg1dd;
                                    break;
            case FBTYPE_SUN2COLOR : vsptr->dd = cg2dd;
                                    break;
            case FBTYPE_SUN2GP    : vsptr->dd = gp1dd;
                                    break;
            default               : io_printf(stderr,
					      "GET_VIEW_SURFACE: UNKNOWN %s\n",
					      dev);
                                    return(FALSE);};};

    strncpy(vsptr->screenname, dev, DEVNAMESIZE);

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_SUN_QUERY_POINTER - query the pointer for location and button status */

static void _PG_sun_query_pointer(dev, px, py, pb)
   PG_device *dev;
   int *px, *py, *pb;
   {int ret;

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
