/*
 * LAGIN.H - internal header for the LAGRANGE PACKAGE
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "lag.h"
#include "global.h"
#include "mesh.h"

/*--------------------------------------------------------------------------*/

/*			       LAG CONSTANTS				    */

/*--------------------------------------------------------------------------*/

#define FIX	      1
#define XVCNST	      2
#define YVCNST	      3
#define WALL	      4

/*--------------------------------------------------------------------------*/

/*			       LAG VARIABLES				    */

/*--------------------------------------------------------------------------*/

/* LAG package variables */

extern int
 *indc,
 *idup,
 *irc;

extern double
 *ab,
 *cs,
 csmin,
 *dtvg,
 *dvxdt,
 *dvydt,
 *errad,
 etoto,
 hgamma,
 *lpm,
 *massn,
 *massz,
 *pdv,
 *tm,
 *voln,
 *volo,
 *vx,
 *vy,
 *zb;

/*--------------------------------------------------------------------------*/

/*				LAG FUNCTIONS				    */

/*--------------------------------------------------------------------------*/

/* LAG.C declarations */

extern int
 SC_DECLARE(def_lag , (PA_package *pck)),
 SC_DECLARE(cont_lag , (PA_package *pck)),
 SC_DECLARE(intern_lag , (byte)),
 SC_DECLARE(lag , (PA_package *pck)),
 SC_DECLARE(init_lag , (PA_package *pck)),
 SC_DECLARE(init_cycle , (void)),
 SC_DECLARE(cspeed , (double *cs, double *p, double *rho));

/* LAGIN.C declarations */

extern int
 SC_DECLARE(node_massw , (double *mass, double *rho, double *rx, double *ry));

