/*
 * Copyright (c) 1997-1999 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

/*
 * This is a test program for the libc socket implementation based on
 * the TCP/IP stack.
 *
 * It first does two fingers and then waits for incoming date requests.
 */
#if OSKIT
#include <oskit/dev/dev.h>
#include <oskit/dev/clock.h>
#include <oskit/dev/linux.h>
#include <oskit/dev/freebsd.h>
#include <oskit/dev/ethernet.h>
#include <oskit/net/freebsd.h>
#include <oskit/fs/memfs.h>
#include <oskit/c/fs.h>
#include <oskit/startup.h>
#include <oskit/clientos.h>
#include "bootp.h"

char GATEWAY[20];
char NETMASK[20];

#define IFNAME		"de0"

/* MST: Salt Lake City, UT */
long secondswest = 6 * 60 * 60;
#define LOCAL_TO_GMT(t) (t)->tv_sec += secondswest

#endif /* OSKIT */

char IPADDR[256];

#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <errno.h>
#include <sys/socket.h>
#include <unistd.h>
#include <string.h>
#include <assert.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

/*
 * this is a simple finger client, programmed to the libbsdnet socket interface
 */
void
fingerclient(char *name, char *host)
{
	int	so;
	int 	namelen, retval, msg_len;
	struct  sockaddr_in addr;
	char    message[256];

	if ((so = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1) {
		perror("socket");
		return;
	}

	/* fill in the sin_addr structure */
	memset(&addr, 0, namelen = sizeof(addr));
	addr.sin_addr.s_addr = inet_addr(host);
	addr.sin_family = AF_INET;
	addr.sin_port = htons(79);

	if ((-1 == connect(so, (struct sockaddr *)&addr, sizeof(addr)))) 
	{
		perror("connect");
		return;
	}

	sprintf(message, "%s\r\n", name);
	retval = write(so, message, msg_len = strlen(message));
	if (retval < 0) {
		perror("write");
		return;
	} else {
		printf("write %d out of %d bytes\n", retval, msg_len);
	}

	do {
		retval = read(so, message, sizeof(message));
		if (retval >= 0) {
			int i;
			for (i = 0; i < retval; i++)
				putchar(message[i]); 
		} else {
			perror("read");
			return;
		}
	} while (retval > 0);

	if ((-1 == close(so))) 
		perror("close");
}

volatile int stop = 0;

/* ARGSUSED */
void timeout(int signal)
{
	stop = 1;
}

/*
 * this is a simple server responding to requests on a given port (daytime)
 */
void
dateserver(short port, int seconds)
{
	int 	so, newso;
	int 	namelen;
	struct  sockaddr_in addr;
	struct  itimerval expire;
	struct  timeval time;

	if ((so = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1) {
		perror("socket");
		return;
	}

	/* fill in the sin_addr structure */
	memset(&addr, 0, namelen = sizeof(addr));
	addr.sin_addr.s_addr = htonl(INADDR_ANY);
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);

	if ((-1 == bind(so, (struct sockaddr *)&addr, sizeof(addr)))) {
		perror("bind");
		return;
	}

	if ((-1 == listen(so, 5))) {
		perror("listen");
		return;
	}

	signal(SIGALRM, timeout);
	memset(&expire, 0, sizeof expire);
	expire.it_value.tv_sec = seconds;
	setitimer(ITIMER_REAL, &expire, NULL);

	for (;!stop;) {
		char * time_message;
		int  msg_len, written;

		if ((newso = accept(so, (struct sockaddr *)&addr, 
				&namelen)) == -1) 
		{
			perror("accept");
			return;
		}

		gettimeofday(&time, 0);
		time_message = asctime(localtime(&time.tv_sec));	
		msg_len = strlen(time_message);

		written = write(newso, time_message, msg_len);
		if (written < 0)
		{
			perror("write");
			return;
		} else {
			printf("write %d out of %d bytes\n", written, msg_len);
		}

		if ((-1 == close(newso))) {
			perror("close");
			return;
		}
	}
	printf("bailing out of loop...\n");
	close(so);
}

/*
 * the initialization follows the ping_reply example...
 */
int
main(int argc, char **argv)
{
	short port = 3000;

#if OSKIT
	oskit_clientos_init();
	start_clock();
#ifndef OSKIT_UNIX
	start_fs_bmod();
	start_network();
#else
	/*
	 * Build using emulated filesystem/sockets, or real drivers.
	 * The real drivers require a second ethernet interface (you
	 * must setenv ETHERIF and ETHERADDR), and a raw disk
	 * partition (either a real one or a pseudo one created with
	 * the vnconfig tools).
	 */
/* #define REALSTUFF */
#ifdef REALSTUFF
	start_fs("/dev/oskitfs", 0);
	start_network();
#else
	start_fs_native("/tmp");
	start_network_native();
#endif
#endif
#endif
	/*
	 * if you want to test pingreply, choose the first piece of code
	 */
	fingerclient("oskit", "155.99.212.1"); /* fast.cs.utah.edu */
	fingerclient("ftp", "155.99.212.1"); 	/* fast */
	printf("responding to date requests for 1 minute\n");

	gethostname(IPADDR, sizeof IPADDR);

	printf("type 'telnet %s %d' to test\n", IPADDR, port);
	dateserver(port, 60);

	exit(0);
}
