
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: monomial.h,v 1.3 1999/07/11 16:50:53 stes Exp $
 */

#ifndef __CAMONOMIAL_HEADER__
#define __CAMONOMIAL_HEADER__

#include "cobject.h"

@interface Monomial : CAObject
{
  id scalar;
  id termOne;
  id terms;
  id _symbols;
  id _leadingTerm;
}
- check;

+ new;
- _setUpScalar:aScalar terms:aCarrier;
+ scalar:aScalar terms:aCarrier;
+ scalar:aScalar;
- scalar:aScalar symbols:aCltn;
+ scalar:aScalar symbols:aCltn;
- clone;
- scalar:aScalar terms:theTerms;
- empty;
- copy;
- deepCopy;
- invalidate;

- asNumerical;
- asModp:(unsigned short)p;
- (int) intValue;
- intValue:(int)aValue;
- (float) floatValue;
- floatValue:(float)aValue;
- (BOOL) isScalar;
- asScalar;
- scalar:aScalar;
- termsAsSymbol;
- termsSymbol:aSymbol;
- asSymbol;
- symbol:aSymbol;

- scalar;
- termOne;
- terms;
- (BOOL) isMonic;
+ classTerms;
- (BOOL) isVariableSparse;
- (BOOL) isVariableDense;
- (int) degree;
- (int) numTerms;
- (BOOL) isTerm;
- (BOOL) isEqual:aMonomial;
- (unsigned) hash;

- addSymbolsTo:aCltn;
- symbols;
- (BOOL) isOrderDegreeCompatible;
- (BOOL) isOrderReverseDegreeCompatible;
- (int) compareTerms:aMonomial;

- removeTerm;
- insertTerm:aTerm;

- eachTerm;
- leadingTerm;

- zero;
- (BOOL) isZero;
- negate;
- double;
- add:b;
- subtract:b;

- one;
- (BOOL) isOne;
- (BOOL) isMinusOne;
- square;
- multiply:b;
- multiplyScalar:s;
- divideScalar:s;
- divide:aMonomial;
- divideTerms:aMonomial;

- gcd:aMonomial;
- lcm:aMonomial;

- frobenius;
- frobeniusInverse;
- changeRepresentationTo:aPrototype;

- (BOOL) printsLeadingSign;
- (BOOL) printsSum;
- (BOOL) printsProduct;
- printTermsToFile:(FILE *)aFile;
- printOn:(IOD)aFile;
@end

#endif /* __CAMONOMIAL_HEADER__ */
 
