
/*
 * Computer Algebra Kit (c) 1993,98 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: cfloat.h,v 1.2 1999/07/06 19:48:08 stes Exp $
 */

#ifndef __CAFLOAT_HEADER__
#define __CAFLOAT_HEADER__

#include "cobject.h"

typedef float float_t;

typedef float float_c;
typedef float *floatseq_t;
typedef struct
  {
    unsigned unused;
  }
float_args;

#define float_isvalue	1
#define float_pervalue	1

@interface Float : CAObject
{
  float_t value;
}

+ new;
- _setUpFloatValue:(float)floatValue;
+ floatValue:(float)floatValue;
+ str:(STR)aString;
- empty;
- (float_t) float_value;
- float_value:(float_t)f;
- (float_t *) float_reference;
- float_reference:(float_t *)f;

- (BOOL) isFloatingPoint;

- (unsigned) hash;
- (BOOL) isEqual:b;
- (BOOL) notEqual:b;
- (float) floatValue;
- floatValue:(float)f;

- (int) sign;
- (int) compare:b;

- zero;
- (BOOL) isZero;
- (BOOL) notZero;
- (BOOL) isOpposite:b;
- (BOOL) notOpposite:b;
- negate;
- negateSelf;
- _double:(int)v;
- _doubleSelf:(int)v;
- double;
- doubleSelf;
- _add:(int)v:b:(int)w;
- _addSelf:(int)v:b:(int)w;
- add:b;
- addSelf:b;
- subtract:b;
- subtractSelf:b;

- one;
- minusOne;
- (BOOL) isOne;
- (BOOL) notOne;
- (BOOL) isMinusOne;
- (BOOL) notMinusOne;
- square;
- squareSelf;
- multiply:b;
- multiplySelf:b;
- inverse;
- inverseSelf;
- divide:b;
- divideSelf:b;
- _add:(int)v:B multiply:b:(int)w;
- _addSelf:(int)v:B multiply:b:(int)w;
- _multiply:a:(int)v add:B:(int)w;
- _multiplySelf:a:(int)v add:B:(int)w;
- _multiply:a:(int)v add:B multiply:b:(int)w;
- _multiplySelf:a:(int)v add:B multiply:b:(int)w;
- str:(STR)aString;

- (BOOL) printsLeadingSign;
- printOn:(IOD)aFile;
@end

#endif /* __CAFLOAT_HEADER__ */
 
