
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: intmodp.h,v 1.2 1999/07/06 19:47:59 stes Exp $
 */

#ifndef __CAINTEGERMODP_HEADER__
#define __CAINTEGERMODP_HEADER__

#include "cobject.h"

#define USHRT_MAX_PRIME 65521U
typedef unsigned short modp_t;

@interface IntegerModp : CAObject
{
  modp_t value;
  unsigned short modulus;
}

+ modulus:(unsigned short)aPrime;
+ int:(int)intValue modulus:(unsigned short)aPrime;

- (unsigned) hash;
- (BOOL) isEqual:b;
- (unsigned short) modulus;
- (int) intValue;
- intValue:(int)aValue;

- zero;
- (BOOL) isZero;
- (BOOL) isOpposite:b;
- negate;
- double;
- add:b;
- subtract:b;

- one;
- minusOne;
- (BOOL) isOne;
- (BOOL) isMinusOne;
- square;
- multiply:b;
- inverse;
- divide:b;

- (int) characteristic;
- frobenius;
- frobeniusInverse;

- (BOOL) printsLeadingSign;
- printOn:(IOD)aFile;
@end

#endif /* __CAINTEGERMODP_HEADER__ */
 
