/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ColorUIResource;
import com.sun.java.swing.plaf.basic.BasicArrowButton;
import com.sun.java.swing.plaf.metal.MetalLookAndFeel;
import com.sun.java.swing.plaf.metal.MetalUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class MetalScrollButton
extends BasicArrowButton {
    private static Color shadowColor;
    private static Color highlightColor;
    private boolean isFreeStanding = false;
    private int buttonWidth;

    public MetalScrollButton(int n, int n2, boolean bl) {
        super(n);
        shadowColor = UIManager.getColor("ScrollBar.shadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        this.buttonWidth = n2;
        this.isFreeStanding = bl;
    }

    public void setFreeStanding(boolean bl) {
        this.isFreeStanding = bl;
    }

    public void paint(Graphics graphics) {
        boolean bl = this.getParent().isEnabled();
        ColorUIResource colorUIResource = bl ? MetalLookAndFeel.getControlInfo() : MetalLookAndFeel.getControlDisabled();
        boolean bl2 = this.getModel().isPressed();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = n;
        int n4 = n2;
        int n5 = (n2 + 1) / 4;
        if (bl2) {
            graphics.setColor(MetalLookAndFeel.getControlShadow());
        } else {
            graphics.setColor(this.getBackground());
        }
        graphics.fillRect(0, 0, n, n2);
        if (this.getDirection() == 1) {
            if (!this.isFreeStanding) {
                n += 2;
            }
            graphics.setColor(colorUIResource);
            int n6 = (n4 + 1 - n5) / 2;
            int n7 = n3 / 2;
            int n8 = 0;
            while (n8 < n5) {
                graphics.drawLine(n7 - n8, n6 + n8, n7 + n8 + 1, n6 + n8);
                ++n8;
            }
            if (bl) {
                graphics.setColor(highlightColor);
                if (!bl2) {
                    graphics.drawLine(1, 1, n - 3, 1);
                    graphics.drawLine(1, 1, 1, n2 - 1);
                }
                graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, n - 2, 0);
                graphics.drawLine(0, 0, 0, n2 - 1);
                graphics.drawLine(n - 2, 2, n - 2, n2 - 1);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, 0, n, n2 + 1);
            }
            if (!this.isFreeStanding) {
                n -= 2;
                return;
            }
        } else if (this.getDirection() == 5) {
            if (!this.isFreeStanding) {
                n += 2;
                ++n2;
            }
            graphics.setColor(colorUIResource);
            int n9 = (n4 + 1 - n5) / 2 + n5 - 1;
            int n10 = n3 / 2;
            int n11 = 0;
            while (n11 < n5) {
                graphics.drawLine(n10 - n11, n9 - n11, n10 + n11 + 1, n9 - n11);
                ++n11;
            }
            if (bl) {
                graphics.setColor(highlightColor);
                if (!bl2) {
                    graphics.drawLine(1, 0, n - 3, 0);
                    graphics.drawLine(1, 0, 1, n2 - 3);
                }
                graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
                graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, 0, n2 - 2);
                graphics.drawLine(n - 2, 0, n - 2, n2 - 2);
                graphics.drawLine(2, n2 - 2, n - 2, n2 - 2);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, -1, n, n2 + 1);
            }
            if (!this.isFreeStanding) {
                n -= 2;
                --n2;
                return;
            }
        } else if (this.getDirection() == 3) {
            if (!this.isFreeStanding) {
                n2 += 2;
                ++n;
            }
            graphics.setColor(colorUIResource);
            int n12 = (n3 + 1 - n5) / 2 + n5 - 1;
            int n13 = n4 / 2;
            int n14 = 0;
            while (n14 < n5) {
                graphics.drawLine(n12 - n14, n13 - n14, n12 - n14, n13 + n14 + 1);
                ++n14;
            }
            if (bl) {
                graphics.setColor(highlightColor);
                if (!bl2) {
                    graphics.drawLine(0, 1, n - 3, 1);
                    graphics.drawLine(0, 1, 0, n2 - 3);
                }
                graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
                graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, n - 2, 0);
                graphics.drawLine(n - 2, 2, n - 2, n2 - 2);
                graphics.drawLine(0, n2 - 2, n - 2, n2 - 2);
            } else {
                MetalUtils.drawDisabledBorder(graphics, -1, 0, n + 1, n2);
            }
            if (!this.isFreeStanding) {
                n2 -= 2;
                --n;
                return;
            }
        } else if (this.getDirection() == 7) {
            if (!this.isFreeStanding) {
                n2 += 2;
                ++n;
                graphics.translate(-1, 0);
            }
            graphics.setColor(colorUIResource);
            int n15 = (n3 + 1 - n5) / 2;
            int n16 = n4 / 2;
            int n17 = 0;
            while (n17 < n5) {
                graphics.drawLine(n15 + n17, n16 - n17, n15 + n17, n16 + n17 + 1);
                ++n17;
            }
            if (bl) {
                graphics.setColor(highlightColor);
                if (!bl2) {
                    graphics.drawLine(1, 1, n - 1, 1);
                    graphics.drawLine(1, 1, 1, n2 - 3);
                }
                graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, n - 1, 0);
                graphics.drawLine(0, 0, 0, n2 - 2);
                graphics.drawLine(2, n2 - 2, n - 1, n2 - 2);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, 0, n + 1, n2);
            }
            if (!this.isFreeStanding) {
                n2 -= 2;
                --n;
                graphics.translate(1, 0);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.getDirection() == 1) {
            return new Dimension(this.buttonWidth, this.buttonWidth - 2);
        }
        if (this.getDirection() == 5) {
            return new Dimension(this.buttonWidth, this.buttonWidth - (this.isFreeStanding ? 1 : 2));
        }
        if (this.getDirection() == 3) {
            return new Dimension(this.buttonWidth - (this.isFreeStanding ? 1 : 2), this.buttonWidth);
        }
        if (this.getDirection() == 7) {
            return new Dimension(this.buttonWidth - 2, this.buttonWidth);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }
}

