/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.SwingUtilities;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Scrollbar;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class ProcDlg
extends JFrame
implements AdjustmentListener,
ActionListener,
ItemListener {
    private ClogDisplay parent;
    private Font dlgFont;
    private Choice procChoice;
    private Choice dprocChoice;
    private JCheckBox displayChkBox;
    private MyButton directionButton;
    private MyTextField procField;
    private Scrollbar hbar;
    private JProcess currProc;
    private JProcess selectedProc;
    private Vector procVector;
    private Vector dprocVector;
    private int tval;
    private int maxBackValue;
    private boolean direction;
    private boolean reflag;

    public ProcDlg(ClogDisplay clogDisplay) {
        super("Adjust Process");
        this.parent = clogDisplay;
        this.setup();
    }

    private void setup() {
        this.adjustDlgStuff();
        this.setupData();
        this.setuphbar();
        this.setupPanel();
        ((Window)((Object)this)).pack();
        ((Component)((Object)this)).setSize(((Container)((Object)this)).getMinimumSize());
        ((Frame)((Object)this)).setResizable(false);
        ((Window)((Object)this)).addWindowListener(new 1());
    }

    private void adjustDlgStuff() {
        this.dlgFont = this.parent.frameFont;
        ((Component)((Object)this)).setFont(this.dlgFont);
    }

    private void setupData() {
        this.reflag = true;
        this.procChoice = new Choice();
        this.procChoice.setFont(this.dlgFont);
        this.dprocChoice = new Choice();
        this.procChoice.setFont(this.dlgFont);
        this.procChoice.addItemListener(this);
        this.dprocChoice.addItemListener(this);
        this.procVector = this.parent.canvas.procVector;
        this.dprocVector = this.parent.canvas.dprocVector;
        int n = 0;
        while (n < this.procVector.size()) {
            this.procChoice.addItem(Integer.toString(((JProcess)this.procVector.elementAt((int)n)).procId));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.dprocVector.size()) {
            this.dprocChoice.addItem(Integer.toString(((JProcess)this.dprocVector.elementAt((int)n2)).procId));
            ++n2;
        }
    }

    private void setuphbar() {
        this.hbar = new Scrollbar(0, 0, 0, 0, this.parent.canvas.widthCan);
        this.hbar.addAdjustmentListener(this);
        this.directionButton = new MyButton("Forward", "Press for opposite direction", this);
        this.direction = true;
    }

    private void setupPanel() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        MyJPanel myJPanel = new MyJPanel(new GridLayout(2, 1), "Current Process");
        JPanel jPanel = new JPanel((LayoutManager)new GridBagLayout());
        jPanel.add((Component)new JLabel("Process #"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.procField = new MyTextField(3, false);
        jPanel.add((Component)((Object)this.procField), gridBagConstraints);
        this.procField.setToolTipText("Current process");
        ((Container)((Object)myJPanel)).add((Component)jPanel);
        jPanel = new JPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)((Object)this.directionButton), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.hbar, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)((Object)new MyButton("Reset", "Place current process at original time position", this)), gridBagConstraints);
        ((Container)((Object)myJPanel)).add((Component)jPanel);
        gridBagConstraints.gridx = 0;
        this.getContentPane().add((Component)((Object)myJPanel), gridBagConstraints);
        myJPanel = new MyJPanel(new GridBagLayout(), "Available Processes");
        gridBagConstraints.gridx = 0;
        ((Container)((Object)myJPanel)).add((Component)new JLabel("Available"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ((Container)((Object)myJPanel)).add(this.procChoice, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.displayChkBox = new JCheckBox("Display");
        ((Container)((Object)myJPanel)).add((Component)this.displayChkBox, gridBagConstraints);
        this.displayChkBox.addItemListener((ItemListener)this);
        this.displayChkBox.setToolTipText("Enable or disable selected available process");
        gridBagConstraints.gridx = 3;
        ((Container)((Object)myJPanel)).add((Component)((Object)new MyButton("Swap", this)), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        ((Container)((Object)myJPanel)).add((Component)((Object)new MyButton("Delete", this)), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)((Object)myJPanel), gridBagConstraints);
        myJPanel = new MyJPanel(new GridBagLayout(), "Deleted Processes");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        ((Container)((Object)myJPanel)).add((Component)new JLabel("Deleted"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ((Container)((Object)myJPanel)).add(this.dprocChoice, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        ((Container)((Object)myJPanel)).add((Component)((Object)new MyButton("Insert", this)), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)((Object)myJPanel), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 3;
        this.getContentPane().add((Component)((Object)new MyButton("Close", "Close window", this)), gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Insert")) {
            if (this.dprocVector.size() > 0) {
                String string2 = this.dprocChoice.getSelectedItem();
                int n = Integer.valueOf(string2);
                this.parent.canvas.InsertProc(this.parent.canvas.getIndex(this.dprocVector, n), this.getSelectedProc().procId);
                this.adjustChoices();
                this.parent.canvas.Refresh();
                return;
            }
        } else if (string.equals("Swap")) {
            if (this.procVector.size() > 1) {
                Integer.valueOf(this.procChoice.getSelectedItem()).intValue();
                if (this.currProc.procId != this.selectedProc.procId) {
                    int n = this.parent.canvas.getIndex(this.procVector, this.selectedProc.procId);
                    int n2 = this.parent.canvas.getIndex(this.procVector, this.currProc.procId);
                    this.procVector.setElementAt(this.currProc, n);
                    this.procVector.setElementAt(this.selectedProc, n2);
                    this.parent.canvas.Refresh();
                    return;
                }
            }
        } else if (string.equals("Delete")) {
            if (this.procVector.size() > 1) {
                String string3 = this.procChoice.getSelectedItem();
                int n = Integer.valueOf(string3);
                this.parent.canvas.DeleteProc(this.parent.canvas.getIndex(this.procVector, n));
                this.adjustChoices();
                this.parent.canvas.Refresh();
                ((Component)((Object)this)).setVisible(false);
                return;
            }
        } else {
            if (string.equals("Close")) {
                ((Component)((Object)this)).setVisible(false);
                return;
            }
            if (string.equals("Forward")) {
                this.directionButton.setText("Backward");
                this.maxBackValue = this.parent.canvas.getMaxDiff(this.currProc);
                if (this.maxBackValue > this.parent.canvas.widthCan) {
                    this.maxBackValue = this.parent.canvas.widthCan;
                }
                this.tval = 0;
                this.hbar.setMaximum(this.maxBackValue);
                this.hbar.setMinimum(0);
                this.hbar.setValue(this.maxBackValue);
                this.direction = false;
                return;
            }
            if (string.equals("Backward")) {
                this.directionButton.setText("Forward");
                this.hbar.setValue(0);
                this.tval = 0;
                this.hbar.setMinimum(0);
                this.hbar.setMaximum(this.parent.canvas.widthCan);
                this.direction = true;
                return;
            }
            if (string.equals("Reset")) {
                this.parent.canvas.resetTimeLine(this.currProc);
                this.parent.canvas.Refresh();
                this.hbar.setValue(0);
                this.tval = 0;
                this.hbar.setMaximum(this.parent.canvas.widthCan);
                this.directionButton.setText("Forward");
                this.direction = true;
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = this.hbar.getValue();
        if (!this.direction) {
            n = this.maxBackValue - n;
        }
        this.parent.canvas.pushTimeLine(this.currProc, n - this.tval, this.direction);
        this.parent.canvas.Refresh();
        this.tval = n;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.displayChkBox) {
            this.getSelectedProc().dispStatus = this.displayChkBox.isSelected();
            if (this.reflag) {
                this.parent.canvas.Refresh();
                return;
            }
            this.reflag = true;
            return;
        }
        if (itemSelectable == this.procChoice) {
            this.reflag = false;
            this.displayChkBox.setSelected(this.getSelectedProc().dispStatus);
        }
    }

    void reset(JProcess jProcess) {
        this.currProc = jProcess;
        this.procField.setText(Integer.toString(jProcess.procId));
        this.reflag = false;
        this.displayChkBox.setSelected(this.getSelectedProc().dispStatus);
        this.directionButton.setText("Forward");
        this.direction = true;
        this.hbar.setValue(0);
        this.tval = 0;
        this.hbar.setMaximum(this.parent.canvas.widthCan);
    }

    private JProcess getSelectedProc() {
        String string = this.procChoice.getSelectedItem();
        int n = Integer.valueOf(string);
        int n2 = this.parent.canvas.getIndex(this.procVector, n);
        this.selectedProc = (JProcess)this.procVector.elementAt(n2);
        return this.selectedProc;
    }

    private void adjustChoices() {
        this.procChoice.removeAll();
        this.dprocChoice.removeAll();
        int n = 0;
        while (n < this.procVector.size()) {
            this.procChoice.addItem(Integer.toString(((JProcess)this.procVector.elementAt((int)n)).procId));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.dprocVector.size()) {
            this.dprocChoice.addItem(Integer.toString(((JProcess)this.dprocVector.elementAt((int)n2)).procId));
            ++n2;
        }
        this.sort(this.procChoice);
        this.sort(this.dprocChoice);
    }

    private void sort(Choice choice) {
        int n;
        int n2 = choice.getItemCount();
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = Integer.valueOf(choice.getItem(n3));
            ++n3;
        }
        int n4 = 1;
        while (n4 < n2) {
            n = 0;
            while (n < n2 - 1) {
                int n5 = nArray[n];
                int n6 = nArray[n + 1];
                if (n5 > n6) {
                    int n7 = nArray[n];
                    nArray[n] = nArray[n + 1];
                    nArray[n + 1] = n7;
                }
                ++n;
            }
            ++n4;
        }
        choice.removeAll();
        n = 0;
        while (n < n2) {
            choice.addItem(Integer.toString(nArray[n]));
            ++n;
        }
    }

    void makeUIChanges() {
        SwingUtilities.updateComponentTreeUI((Component)((Object)this));
        ((Frame)((Object)this)).setResizable(true);
        ((Component)((Object)this)).setSize(((Container)((Object)this)).getMinimumSize());
        ((Frame)((Object)this)).setResizable(false);
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)((Object)ProcDlg.this)).setVisible(false);
        }

        /* synthetic */ 1() {
        }
    }
}

