open GtkObj
open GtkEasy.Layout

let hello_label = label_new "nothing yet..." 

let hello_button = button_new_with_label "press to dialog"

let quit_button = button_new_with_label "quit" 

let window_structure = 
  Box(Vert,
      [ Widget( hello_label :> widget ),  fill_5  ;
        Widget( hello_button :> widget ), fixed_5 ;
        Widget( quit_button :> widget ),  fixed_5 ])

let window = make_window_from_structure window_structure "Dialog demo" 
       
let _ = window #connect_delete_event( fun () -> Gtk.main_quit(); false )

(* Error message dialog *)
let okeyed dialog gtkobject = dialog#hide

let error_dialog s = 
  let dial = dialog_new () in 
  let box = dial #get_action_area in 
  let lb = label_new s in 
  lb #show;
  box #pack_start (lb :> widget) false true 0;
  let but = button_new_with_label "Ok" in 
  but #show;
  box #pack_start (but :> widget) false true 0;
  dial #show;
  let n = but #connect_clicked (okeyed dial) in
  ()

(* Get string dialog *)
let f_todo = ref None

let activate dialog gtkobject =
  let s = (gtkobject :> entry) #get_text in 
  ( match !f_todo with
    None -> 
      error_dialog "Nothing to do ..."
  | Some f ->
      f s;
      f_todo := None;
      (dialog :> dialog) #hide )
  
let get_string continuation = 
  ( match !f_todo with
    Some f' -> error_dialog "Already asking ..."
  | None ->
      f_todo := Some continuation;
      let dial = dialog_new () in 
      let box = dial #get_action_area in 
      let cn = entry_new () in 
      cn #show;
      box #pack_start (cn :> widget) false true 0;
      dial #show;
      let n = cn #connect_activate (activate dial) in
      () )

let say_hello () =
  let continuation s = hello_label #set_text ("Text is : " ^ s) in 
  get_string continuation
    
let _ = hello_button #connect_clicked say_hello

let _ = quit_button #connect_clicked Gtk.main_quit 

let _ = window #set_usize 150 250 ;;

let _ = window #show
  (* Show the window. *)

let _ = GtkThr.main ()
  (* And at last enter the event loop. *)


