open GtkObj
open GtkEasy.Layout
open GtkEasy.Menu
open Gdk.Event

let showarg (x:Gtk.Unsafe.gtkArg) = match x with
	| Gtk.Unsafe.Unit -> "Unit"
	| Gtk.Unsafe.Other -> "Other"
	| Gtk.Unsafe.Invalid -> "Invalid"
	| Gtk.Unsafe.Bool b -> "Bool : " ^ (if b then "true" else "false")
	| Gtk.Unsafe.Char c -> "Char : " ^ (Char.escaped c)
	| Gtk.Unsafe.Int n -> "Int : " ^ (string_of_int n)
	| Gtk.Unsafe.Float x -> "Float : " ^ (string_of_float x)
	| Gtk.Unsafe.String s -> "String : " ^ s
	| Gtk.Unsafe.Pointer p -> "Pointer"

let showargs (x:Gtk.Unsafe.gtkArg list) = let rec f s = function
	| [] -> s
	| a::l -> f (s ^ showarg a ^ "\n") l
	in f "" x

let soi = string_of_int

let pixmap = ref None
module M = Gdk.Event.Extract
let drawingarea = drawing_area_new ()
module DrawingInfo = struct
	type da = Gtk.Unsafe.gtkobject
	let da () = drawingarea#get_gtkobject
	let white_and_drawable da =
		let w = Gtk.Unsafe.window_of da
		and st = Gtk.Unsafe.style_of da
		in let white = st.Gtk.white_gc
		and d = Gdk.drawable_from_window w
		in (white, d)
	let black_and_drawable da =
		let w = Gtk.Unsafe.window_of da
		and st = Gtk.Unsafe.style_of da
		in let black = st.Gtk.black_gc
		and d = Gdk.drawable_from_window w
		in (black, d)
	let allocation da =
		let allocation = Gtk.Unsafe.allocation_of da
		in (allocation.Gtk.x, allocation.Gtk.y,
			allocation.Gtk.width, allocation.Gtk.height)
end
let drawingarea_configure (x:Gtk.Unsafe.gtkArg list) =
(
	let da = drawingarea#get_gtkobject in
	let w = Gtk.Unsafe.window_of da
	and black_gc = let st = Gtk.Unsafe.style_of da in st.Gtk.black_gc
	and allocation = Gtk.Unsafe.allocation_of da
	in let width = allocation.Gtk.width
	and height = allocation.Gtk.height
	in let pm = match !pixmap with
		| None ->
			let p = Gdk.pixmap_new w width height (-1)
			in pixmap := Some p; p
		| Some p -> p
	in let d = Gdk.drawable_from_pixmap pm
	in
	(
		Gdk.draw_rectangle d black_gc true 0 0 width height;
		Gtk.Unsafe.Bool true
	)
)
let drawingarea_expose (x:Gtk.Unsafe.gtkArg list) =
(
	let da = drawingarea#get_gtkobject in
	let (x, y, width, height) = (function Gtk.Unsafe.Pointer p ->
		M.expose_x p, M.expose_y p, M.expose_w p, M.expose_h p
		| _ -> (0, 0, 0, 0)) (List.hd x)
	and w = Gtk.Unsafe.window_of da
	and st = Gtk.Unsafe.style_of da
	in let fg_gc = st.Gtk.fg_gc.(Gtk.Unsafe.state_of da)
	and d = Gdk.drawable_from_window w
	and pm = match !pixmap with
		| None ->
			let p = Gdk.pixmap_new w width height (-1)
			in pixmap := Some p; p
		| Some p -> p
	in
	(
		Gdk.draw_pixmap d fg_gc pm x y x y width height;
		Gtk.Unsafe.Bool false
	)
)
let draw_point x y =
  let (white, d) = DrawingInfo.white_and_drawable (DrawingInfo.da ())
  in Gdk.draw_rectangle d white true (x-5) (y-5) 10 10

let button_pressed b x y =
(
	if b = 1 then draw_point x y
	else ()
)

let drawingarea_button_pressed (x:Gtk.Unsafe.gtkArg list) =
(
	let (b, x, y) =
	( function
	  | Gtk.Unsafe.Pointer p -> M.button_button p, M.button_x p, M.button_y p
		| _ -> (-1, 0, 0)
	) (List.hd x)
	in button_pressed b x y;
	Gtk.Unsafe.Bool true
)

let _ = drawingarea#set_events [BUTTON_PRESS_MASK; EXPOSURE_MASK]
let _ = Gtk.Unsafe.signal_connect drawingarea#get_gtkobject "button_press_event" drawingarea_button_pressed
let _ = Gtk.Unsafe.signal_connect drawingarea#get_gtkobject "configure_event" drawingarea_configure
let _ = Gtk.Unsafe.signal_connect drawingarea#get_gtkobject "expose_event" drawingarea_expose
let _ = drawingarea#size 600 400

let but_clicked s f (x:Gtk.Unsafe.gtkArg list) =
(
	f ();
	Gtk.Unsafe.Unit
)
let func () = ()
let butdef =
[
	"Bouton 1", (function () -> ());
	"Bouton 2", (function () -> ());
	"Bouton 3", (function () -> ());
	"Bouton 4", (function () -> ());
	"Sortir", Gtk.main_quit;
]
let rec butbox = function 
	| [] -> []
	| (label,func)::q -> let b = button_new_with_label label
		in match Gtk.Unsafe.signal_connect b#get_gtkobject 
			"clicked" (but_clicked label func)with _ -> ();
			(Widget (b:>widget),
		{expand=false; fill=false; padding=1})::(butbox q)

let menu =
[ 
  Submenu (GtkEasy.Label "Application",
  [
    Item (GtkEasy.Label "A propos", function () -> ());
    Item (GtkEasy.Label "Fermer", Gtk.main_quit)
  ]);
  Submenu (GtkEasy.Label "Objet",
  [
    Item (GtkEasy.Label "Nouveau", function () -> ());
  ]);
  Item (GtkEasy.Label "Aide", function () -> ());
]
let menu_bar = make_menu_bar menu

let structure =
	let menu = Widget (menu_bar:>widget),
		{expand=false; fill=false; padding=1}
	and da =  Widget (drawingarea:>widget),
		{expand=true; fill=true; padding=1}	
	in let box2 = Box (Vert, butbox butdef),
		{expand=false; fill=false; padding=1}
	in let box1 = Box (Horiz, [box2; da]),
		{expand=true; fill=true; padding=1}
	in Box (Vert, [menu; box1])

let window = make_window_from_structure structure "Toplevel Window" ;;

let main () = window #show

let _ = main ()
