/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
# ifndef interfaceNodeLIST_H
# define interfaceNodeLIST_H

typedef /*@only@*/ interfaceNode o_interfaceNode;

abst_typedef struct _interfaceNodeList
{
  int nelements;
  int nspacehigh;
  int nspacelow;
  /*@dependent@*/ /*@reldef@*/ /*@relnull@*/ o_interfaceNode *elements;
  /*@only@*/ /*@reldef@*/ /*@relnull@*/ o_interfaceNode *elementsroot;
} *interfaceNodeList ;

/*@iter interfaceNodeList_elements (sef interfaceNodeList x, yield exposed interfaceNode el); @*/
# define interfaceNodeList_elements(x, m_el) \
   { int m_ind; interfaceNode *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
         { interfaceNode m_el = *(m_elements++); 

# define end_interfaceNodeList_elements }}

extern /*@only@*/ interfaceNodeList interfaceNodeList_new(void);

extern interfaceNodeList
  interfaceNodeList_addh (/*@returned@*/ interfaceNodeList p_s, /*@only@*/ interfaceNode p_el);
extern void interfaceNodeList_addl (interfaceNodeList p_s, /*@keep@*/ interfaceNode p_el) ;

extern void interfaceNodeList_free (/*@only@*/ interfaceNodeList p_s) ;

/*@constant int interfaceNodeListGROWLOW;@*/
# define interfaceNodeListGROWLOW 4 /* addl used in abstract.c */

/*@constant int interfaceNodeListGROWHI;@*/
# define interfaceNodeListGROWHI 4

/*@constant int interfaceNodeListBASESIZE;@*/
# define interfaceNodeListBASESIZE \
  (interfaceNodeListGROWLOW + interfaceNodeListGROWHI)

# else
# error "Multiple include"
# endif




