// Copyright (c) 1995  David Engberg  All rights reserved
// $Id: DisassembleMain.C,v 1.5 1998/04/12 22:17:13 geppetto Exp $
#include "cppstring.h"
#include "JavaClassFile.h"

#ifdef __GNUG__
  #include <iostream.h>
  #include <fstream.h>
#else
  #include <iostream>
  #include <fstream>
#endif

#include "JavaConstant.h"

int
main(int argc, char** argv) {
  for (int count=1; count < argc; count++) {
    ifstream infile;
    infile.open(argv[count]);
    if (infile.is_open() == 0) {
      cerr << "File " << argv[count] << " can't be opened\n";
    } else {
      CJavaClassFile* file = CJavaClassFile::ParseFromStream(infile);
      cout << ((file != 0) ? "success" : "failure") << endl;
      if (file != 0) {
	file->DisassembleClass(cout);
      }
      delete file;
    }
  }
  return 0;
}

