// -*- C++ -*- 

/* functions.h: global functions found in Gnome.
 * 
 * Copyright (C) 1998 EMC Capital Management Inc.
 * Developed by Havoc Pennington <hp@pobox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--.h>
#include <libgnomeui/gnome-dialog-util.h>
#include "dialog.h"


// This class is simply a namespace. Don't want to use
//  namespaces since it'd break so many compilers (especially egcs)

class Gnome {
public:
  static Gnome_Dialog* ok_dialog(const gchar* message);
  static Gnome_Dialog* ok_dialog_parented(const gchar* message,Gtk_Window* parent);
  static Gnome_Dialog* error_dialog(const gchar* message);
  static Gnome_Dialog* error_dialog_parented(const gchar* message,Gtk_Window* parent);
  
  // Fixme tons more dialog functions; want to wrap 
  //  them so that the callbacks aren't annoying to
  //  use though (i.e. allow use of methods)

};
