#include "HandleBoxTest.h"
#include "ToolbarTest.h"

HandleBoxTest * HandleBoxTest::theTest = 0;

TestFixture * 
HandleBoxTest::create () 
{
  if ( theTest == 0 ) 
    {
      theTest = new HandleBoxTest ();
      return theTest;
    }
  return 0;
}


void
HandleBoxTest::childSignal ( Gtk_Widget *child, const string action ) 
{
  cout << gtk_type_name ( GTK_OBJECT_TYPE ( gtkobj () ) )
       << ": child <" << gtk_type_name ( GTK_OBJECT_TYPE ( child -> gtkobj ()  ) )
       << action << "ed" << endl;
}
			  

HandleBoxTest::HandleBoxTest () :
  handleBox ()
{

  ToolBarTestWidget *toolbar;
  Gtk_Label         *label;
  Gtk_HSeparator    *separator;

  set_border_width ( 20 );

  actionArea . pack_start ( vbox );
  vbox . show ();

  label = new Gtk_Label ( "Above" );
  vbox . pack_start ( manage ( label ) );
  label -> show ();

  separator = new Gtk_HSeparator;
  vbox . pack_start ( manage ( separator ) );
  separator -> show ();

  vbox . pack_start ( hbox );
  hbox . show ();

  separator = new Gtk_HSeparator;
  vbox . pack_start ( manage ( separator ) );
  separator -> show ();

  label = new Gtk_Label ( "Below" );
  vbox . pack_start ( manage ( label ) );
  label -> show ();

  hbox . pack_start ( handleBox );
  
  connect_to_method ( handleBox . child_attached, this, &( HandleBoxTest::childSignal ),
		      string ( "attached" ) );
  connect_to_method ( handleBox . child_detached, this, &( HandleBoxTest::childSignal ), 
		      string ( "detached" ) );
  
  handleBox . show ();

  toolbar = new ToolBarTestWidget;
  toolbar -> borders ( 0 );
  handleBox . add ( toolbar );
  toolbar -> show ();

  hbox . pack_start ( handleBox2 );
  handleBox2 . show ();

  connect_to_method ( handleBox2 . child_attached, this, &( HandleBoxTest::childSignal ), 
		      string ( "child_attached" ) );
  connect_to_method ( handleBox2 . child_detached, this, &( HandleBoxTest::childSignal ), 
		      string ( "child_detached" ) );

  handleBox2 . add ( &handleBox3 );
  handleBox3 . show ();
  
  connect_to_method ( handleBox3 . child_attached, this, &( HandleBoxTest::childSignal ), 
		      string ( "attached" ) );
  connect_to_method ( handleBox3 . child_detached, this, &( HandleBoxTest::childSignal ), 
		      string ( "detached" ) );

  label = new Gtk_Label ("Fooo!");
  handleBox3 . add ( label );
  label -> show ();

  packControlArea ();
  show_all ();
}

