/* $Header: /cvs/gnome/gIDE/src/gI_hilite.h,v 1.3 1999/11/20 02:34:45 jpr Exp $ */
/*  gIDE
 *  Copyright (C) 1998-2000 Steffen Kern
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/



#ifndef HILITE_H
#define HILITE_H

#include <config.h>
#include <gnome.h>

#ifdef HAVE_GTKTEXT_PATCH
#include <gtkeditor/gtkeditor.h>

typedef struct _gI_HilitePattern gI_HilitePattern;
struct _gI_HilitePattern
{
	gchar *name;

	gchar *comment_start;
	gchar *comment_end;
	gchar *string_start;
	gchar *string_end;
	gchar *char_start;
	gchar *char_end;

	gchar *keywords;
	gchar *types;
	gchar *funcs;

	GdkColor comment_color;
	GdkColor string_color;
	GdkColor char_color;
	GdkColor keywords_color;
	GdkColor types_color;
};


GtkWidget*gI_hilite_get_pattern_widget                   (gI_pat_dialog *pd);
void      gI_hilite_set_buffer_patterns_cb               (void);
void      gI_hilite_add_pattern_dia_cb                   (GtkWidget     *dummy,
							  gI_pat_dialog *pd);
void      gI_hilite_add_pattern_dia                      (gI_pat_dialog *pd);
void      gI_hilite_add_named_pattern                    (const gchar    *patname,
			                  		  const gI_HilitePattern *pat);
void      gI_hilite_remove_pattern_dia_cb                (GtkWidget     *dummy,
							  gI_pat_dialog *pd);
void      gI_hilite_remove_pattern_dia                   (gI_pat_dialog *pd);
void      gI_hilite_set_pattern                          (GtkWidget     *buffer,
							  gchar         *patname);
void      gI_hilite_rehilite                             (void);

gI_HilitePattern*
          gI_hilite_get_pattern_by_name                  (gchar          *name);

gint	  gI_hilite_install_pattern( GtkEditor *editor, gI_HilitePattern *pat );

gchar*	  create_keywords_pattern			(gchar *patname);


#if !HAVE_LIBGUILE
void      gI_hilite_load_patterns                        (const gchar    *filename);
#endif
void      gI_hilite_save_patterns                        (const gchar    *filename);

#endif /*HAVE_GTKTEXT_PATCH*/

#endif /*HILITE_H*/
