/* $Header: /cvs/gnome/gIDE/src/gI_ftree.c,v 1.2 1999/11/06 17:45:39 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/utsname.h>
#include <unistd.h>
#include <stdlib.h>
#include "gI_file.h"
#include "gI_compile.h"
#include "gI_ftree.h"
#include "structs.h"


/* externs */
extern gI_window *main_window;


/*
 update this stuff to use ctree, set data behind every item (at least the complete path, maybe a struct with
 stat information
 */


/* globals */
static GtkWidget *root_tree = NULL;
static GtkWidget *root_item = NULL;
static GtkWidget *mach_tree = NULL;


static void files_tree_select( GtkWidget *widget, GdkEventButton *event, gI_ftree_item_info *item_info )
{
    if (GTK_IS_TREE_ITEM( widget ) &&
        (event->type == GDK_2BUTTON_PRESS ) )
    {
        if( item_info->isdir )
        {
            /* destroy old tree and generate a new one */
            gtk_widget_destroy( root_tree );
            setup_tree( item_info->window );
            gen_files_tree( item_info->filename, item_info->window );
        }
        else
        {
            if( !check_file_open( item_info->filename ) )
            {
                file_open_by_name( main_window, item_info->filename );
            }
            else
            {
                goto_file( item_info->filename );
            }
        }
    }
}


void gen_files_tree( gchar *dirname, GtkWidget *window )
{
    DIR *dir;
    struct dirent *entry;
    struct stat f_stat;
    gchar fwp[MAXLEN];
    GtkWidget *tree_item;
    GtkWidget *sub_tree;
    gI_ftree_item_info *item_info;
    gchar cwdbak[STRLEN];

    /* correct dirname, FIXME: does somebody know a better way? */

    /* backup current directory */
    getcwd( cwdbak, STRLEN );

    /* fix dirname */
    if( chdir( dirname ) != 0 )
    {
        /* abort */
        g_error( "FUCK: error changing directory\n" );
        return;
    }
    else
    {
        dirname = realloc( dirname, STRLEN );
        getcwd( dirname, STRLEN );
    }

    /* back to old directory */
    chdir( cwdbak );
    
    
    g_print( "Processing '%s'...\n", dirname );
    tree_item = gtk_tree_item_new_with_label( dirname );
    gtk_tree_append( GTK_TREE( mach_tree ), tree_item );
    gtk_tree_item_expand( GTK_TREE_ITEM( tree_item ) );
    gtk_widget_show( tree_item );

    sub_tree = gtk_tree_new();
    gtk_tree_item_set_subtree( GTK_TREE_ITEM( tree_item ), sub_tree );
    gtk_widget_show( sub_tree );

    dir = opendir( dirname );

    while( (entry = readdir( dir )) )
    {
        g_snprintf( fwp, MAXLEN, "%s/%s", dirname, entry->d_name );
        if( stat( fwp, &f_stat ) != 0 )
        {
            g_print( "%s: %s\n", fwp, g_strerror( errno ) );
        }
        else
        {
            if( S_ISDIR( f_stat.st_mode ) )
            {
                g_snprintf( fwp, MAXLEN, "[%s]", entry->d_name );
                tree_item = gtk_tree_item_new_with_label( fwp );
                gtk_tree_append( GTK_TREE( sub_tree ), tree_item );
                item_info = g_malloc0( sizeof( gI_ftree_item_info ) );
                item_info->window = window;
                if( dirname[strlen(dirname)] != '/' )
                {
                    item_info->filename = g_strconcat( dirname, "/", entry->d_name, NULL );
                }
                else
                {
                    item_info->filename = g_strconcat( dirname, entry->d_name, NULL );
                }
                item_info->isdir = TRUE;
                gtk_signal_connect( GTK_OBJECT( tree_item ), "button_press_event",
                                    GTK_SIGNAL_FUNC( files_tree_select ), (gpointer) item_info );

                gtk_widget_show( tree_item );
            }
            else
            {
                tree_item = gtk_tree_item_new_with_label( entry->d_name );
                gtk_tree_append( GTK_TREE( sub_tree ), tree_item );
                item_info = g_malloc0( sizeof( gI_ftree_item_info ) );
                item_info->window = window;
                if( dirname[strlen(dirname)] != '/' )
                {
                    item_info->filename = g_strconcat( dirname, "/", entry->d_name, NULL );
                }
                else
                {
                    item_info->filename = g_strconcat( dirname, entry->d_name, NULL );
                }
                item_info->isdir = FALSE;
                gtk_signal_connect( GTK_OBJECT( tree_item ), "button_press_event",
                                    GTK_SIGNAL_FUNC( files_tree_select ), (gpointer) item_info );
                gtk_widget_show( tree_item );
            }
        }
    }

    closedir( dir );
}


void setup_tree( GtkWidget *window )
{
    struct utsname uts;
    
    root_tree = gtk_tree_new();
    gtk_container_add( GTK_CONTAINER( window ), root_tree );
    gtk_widget_show( root_tree );

    if( uname( &uts ) != 0 )
    {
        /* fuck up */
        g_print( "FUCK!" );
    }
    
    root_item = gtk_tree_item_new_with_label( uts.nodename );
    gtk_tree_append( GTK_TREE( root_tree ), root_item );
    gtk_tree_item_expand( GTK_TREE_ITEM( root_item ) );
    gtk_widget_show( root_item );

    mach_tree = gtk_tree_new();
    gtk_tree_item_set_subtree( GTK_TREE_ITEM( root_item ), mach_tree );
    gtk_widget_show( mach_tree );
}


GtkWidget *setup_tree_window()
{
    static GtkWidget *window;
    static GtkWidget *scrolled_win;

    window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
    gtk_window_set_title( GTK_WINDOW( window ), "D/F Tree" );
    gtk_widget_set_usize( window, 400, 400 );
    gtk_signal_connect_object( GTK_OBJECT( window ), "destroy",
                        GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ) );
    gtk_widget_show( window );

    scrolled_win = gtk_scrolled_window_new( NULL, NULL );
    gtk_container_add( GTK_CONTAINER( window ), scrolled_win );
    gtk_widget_show( scrolled_win );

    return( scrolled_win );
}


void ftree(void)
{
    GtkWidget *window;
    
    window = setup_tree_window();
    setup_tree( window );
    gen_files_tree( getcwd(NULL, STRLEN), window );
}


