/*****************************************************************************
**
** testpcl.c
**
** Mon May 31 20:28:15 1999
** mborella@stratos (Mike Borella)
**
** Main command line parsing routines
**
** Automatically created by genparse v0.3
**
** See http://www.borella.net/mike/Software/ for details
**
*****************************************************************************/


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>

char mandatory[] = "filename";
#include <sys/types.h>
#include <sys/types.h>
#include "testpcl.h"

/*----------------------------------------------------------------------------
 *
 * usage()
 *
 *----------------------------------------------------------------------------
 */

void usage(char *executable)
{
  printf("usage: %s [ -insf ] %s \n", executable, mandatory);
  printf("  [ -h ] [ --help ] Print help screen \n");
  printf("  [ -i ] ");
  printf("[ --iterations ] ");
  printf("Number of iterations to run for.");
  printf(" (default = 100)");
  printf("\n");
  printf("  [ -n ] ");
  printf("[ --name ] ");
  printf("User's name");
  printf(" (default = mike)");
  printf("\n");
  printf("  [ -s ] ");
  printf("[ --str ] ");
  printf("test string");
  printf("\n");
  printf("  [ -f ] ");
  printf("a stupid flag!");
  printf("\n");

  exit(1);
}

/*----------------------------------------------------------------------------
 *
 * free_args()
 *
 *----------------------------------------------------------------------------
 */

void free_args(struct arg_t *my_arg)
{
  if (my_arg->n != NULL) free(my_arg->n);
  if (my_arg->s != NULL) free(my_arg->s);
  free(my_arg);
}

/*----------------------------------------------------------------------------
 *
 * testpcl()
 *
 *----------------------------------------------------------------------------
 */

struct arg_t *testpcl(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int option_index = 0;
  char c;
  struct arg_t *my_arg;
  int errflg = 0;

  static struct option long_options[] =
  {
    {"help", 0, 0, 'h'},
    {"iterations", 1, 0, 'i'},
    {"name", 1, 0, 'n'},
    {"str", 1, 0, 's'},
    {"", 1, 0, 'f'},
    {0, 0, 0, 0}
  };


  my_arg = (struct arg_t *) malloc (sizeof(struct arg_t));

  my_arg->h = 0;
  my_arg->i = 100;
  my_arg->n = strdup("mike");
  my_arg->s = NULL;
  my_arg->f = 0;

  while ((c = getopt_long(argc, argv, "hi:n:s:f", long_options, &option_index)) != EOF)
    {
      switch(c)
        {
        case 'h':
          my_arg->h ++;
          break;

        case 'i':
          my_arg->i = atoi(optarg);
          if (my_arg->i < 10)
            {
              fprintf(stderr, "parameter range error: i must be >= 10\n");
              errflg ++;
            }
          if (my_arg->i > 1000)
            {
              fprintf(stderr, "parameter range error: i must be <= 1000\n");
              errflg ++;
            }
          if (!param_i_callback(my_arg->i))
            usage(argv[0]);
          break;

        case 'n':
          my_arg->n = strdup(optarg);
          if (!param_n_callback(my_arg->n))
            usage(argv[0]);
          break;

        case 's':
          my_arg->s = strdup(optarg);
          break;

        case 'f':
          my_arg->f ++;
          break;

        default:
          usage(argv[0]);

        }
    } /* while */

    if (errflg)
      usage(argv[0]);

    if (!callback(my_arg))
      usage(argv[0]);

  my_arg->optind = optind;
  return my_arg;
}
