--                            GCH COMPONENTS                                --
--                                                                          --
--                          G C H . R U L E S                               --
--                                                                          --
--                             QS_5_1_1_2                                   --
--                                                                          --
--              Copyright (c) 1999, Vitali Sh.Kaufman.                      --
--                                                                          --
--  Gch is distributed as free software; that is with full sources          --
--  and in the hope that it will be useful, but WITHOUT ANY WARRANTY;       --
--  without even the implied warranty of MERCHANTABILITY or FITNESS         --
--  FOR A PARTICULAR PURPOSE. You can freely copy, modify and redistribute  --
--  this software, provided that full sources are available for the version --
--  being distribute (original and modified), and for a modified version,   --
--  any changes that you have made are clearly indicated.                   --
--                                                                          --
--  Gch was developed by Vitali Sh. Kaufman using a prototype               --
--  and consultations by Sergey I. Rybin.                                   --
------------------------------------------------------------------------------
   -------------------------------
   -- QS_5_1_1_2                --
   -------------------------------
with Asis.Extensions.Flat_Kinds;      use Asis.Extensions.Flat_Kinds;

  separate (Gch.Rules)
   function QS_5_1_1_2 (E : Asis.Element) return Boolean is
   --  As a rule to check we use the
   --  following: "Associate names with any loop that contains
   --  an exit statement").
      E_Kind : Flat_Element_Kinds := Flat_Element_Kind (E);

      procedure Check_For_Exit
        (Element : in     Asis.Element;
         Control : in out Traverse_Control;
         State   : in out Boolean);
      --  used as Operation when traversing a loop. Checks if the component
      --  being traversed is an exit statement belonging to this loop and
      --  terminate traversing if and when such an exit statement is found;

      procedure Check_For_Exit
        (Element : in     Asis.Element;
         Control : in out Traverse_Control;
         State   : in out Boolean)
      is
         Elem_Kind : Flat_Element_Kinds := Flat_Element_Kind (Element);
      begin
         if Elem_Kind = An_Exit_Statement then
            State   := True;
            Control := Terminate_Immediately;
         elsif not (Is_Identical(Element, E)) and then
              -- to look in deep

              (Elem_Kind = An_Accept_Statement  or else
               Elem_Kind in Flat_Loop_Statement or else
               Elem_Kind not in Flat_Statement_Kinds)
         then
            Control := Abandon_Children;
         end if;
      end Check_For_Exit;

      procedure Look_For_Exit is new Simple_Traverse_Element
        (State_Information => Boolean,
         Operation     => Check_For_Exit);

      Exit_Found : Boolean := False;
      Exit_Search_Control : Traverse_Control := Continue;
      Result : Boolean := True;

   begin

      if not (E_Kind in Flat_Loop_Statement and then
              Is_Nil (Statement_Identifier (E)))
              -- loop should be unnamed

      then
         return Result; --
      end if;

      -- if E is an unnamed loop statement
      Look_For_Exit (E, Exit_Search_Control, Exit_Found);

      if Exit_Found then
         Result := False;
      end if;
      return Result;
   exception
      when ASIS_Inappropriate_Context          |
           ASIS_Inappropriate_Container        |
           ASIS_Inappropriate_Compilation_Unit |
           ASIS_Inappropriate_Element          |
           ASIS_Inappropriate_Line             |
           ASIS_Inappropriate_Line_Number      |
           ASIS_Failed
         =>
         Report_ASIS_Failure ("QS_5_1_1_2");
         return True;
   end QS_5_1_1_2;