------------------------------------------------------------------------------
--                                                                          --
--                            GCH COMPONENTS                                --
--                                                                          --
--                          G C H . D R I V E R                             --
--                                                                          --
--                               B o d y                                    --
--                                                                          --
--                                                                          --
--              Copyright (c) 1999, Vitali Sh.Kaufman.                      --
--                                                                          --
--  Gch is distributed as free software; that is with full sources          --
--  and in the hope that it will be useful, but WITHOUT ANY WARRANTY;       --
--  without even the implied warranty of MERCHANTABILITY or FITNESS         --
--  FOR A PARTICULAR PURPOSE. You can freely copy, modify and redistribute  --
--  this software, provided that full sources are available for the version --
--  being distribute (original and modified), and for a modified version,   --
--  any changes that you have made are clearly indicated.                   --
--                                                                          --
--  Gch was developed by Vitali Sh. Kaufman using a prototype               --
--  and consultations by Sergey I. Rybin.                                   --
------------------------------------------------------------------------------

with Ada.Characters.Handling; use Ada.Characters.Handling;
with Ada.Command_Line;        use Ada.Command_Line;
with Ada.Exceptions;          use Ada.Exceptions;
with Ada.Text_IO;             use Ada.Text_IO;
with Ada.Wide_Text_IO;

with Asis.Implementation;
with Asis.Ada_Environments;   use Asis.Ada_Environments;

with Gch.Init;                use Gch.Init;
with Gch.Output;              use Gch.Output;
with Gch.Options;             use Gch.Options;
with Gch.Source_Check;        use Gch.Source_Check;
with Gch.Globals;             use Gch.Globals;

procedure Gch.Driver is
begin

   Scan_Command_Line;

   Scan_Ini_File;

   Scan_Rule_Ini_File;

   if Verbose_Mode or else Show_Global_Statistics then
      Put_Line (">>> Gch - ASIS_GNAT Rule_Checker BEGIN <<<");
      Put_Gch_Version;
   end if;

   Check_Settings;

      --  Preparing ASIS to run Gch:
   Asis.Implementation.Initialize;

   Asis.Ada_Environments.Associate
        (Checking_Context,
        "Checking_Context",
        "-CA" & " -FM " & To_Wide_String (GCC_Tree_Args.all));
   Asis.Ada_Environments.Open (Checking_Context);

   for Source_File in 1 .. Source_File_Table.Last loop
      begin
         Check_Source (Source_File);
      exception
         when Ex : others =>
            New_Line;
            Put ("Gch: Check_Source: Unexpected bug in ");
            Put_Gch_Version;
            New_Line;
            Put (Exception_Name (Ex));
            Put (" was raised ");

            Put_Line (Exception_Message (Ex));

            Put_Line ("Please report to Vitali.Kaufman@iname.com");
      end;
   end loop;

   if Verbose_Mode or else Show_Global_Statistics then
      Output_Global_Statistics;
   end if;

   if Verbose_Mode or else Show_Global_Statistics then
      New_Line;
      Put (">>> Gch - ASIS_GNAT Rule_Checker END <<<");
   end if;

   begin
      if Asis.Ada_Environments.Exists (Checking_Context) and then
         Asis.Ada_Environments.Is_Open (Checking_Context)
      then
         Asis.Ada_Environments.Close (Checking_Context);
         Asis.Ada_Environments.Dissociate (Checking_Context);
      end if;
   exception
      when others =>
         New_Line;
         Put ("Gch: ASIS is failed to close the context: ");
         Ada.Wide_Text_IO.Put (Asis.Implementation.Diagnosis);
   end;

   begin
      if not Asis.Implementation.Is_Finalized then
         Asis.Implementation.Finalize;
      end if;
   exception
      when others =>
         New_Line;
         Put ("Gch: ASIS is failed to finalize: ");
         Ada.Wide_Text_IO.Put (Asis.Implementation.Diagnosis);
   end;

   Clean_Up;

exception
   --  do we really need an exception handler here?
   when Fatal_Error =>
      Set_Exit_Status (Failure);

   when Gch_Not_Implemented_Error =>
      New_Line;
      Put ("Gch: Non-implemented feature in ");
      Put_Gch_Version;
      New_Line;

      Put_Line ("Please report to Vitali.Kaufman@iname.com");

      Clean_Up;
      Set_Exit_Status (Failure);

   when Ex : others =>
      New_Line;
      Put ("Gch: Unexpected bug in ");
      Put_Gch_Version;
      New_Line;
      Put (Exception_Name (Ex));
      Put (" was raised: ");

      Put_Line (Exception_Message (Ex));
      Ada.Wide_Text_IO.Put (Asis.Implementation.Diagnosis);
      Put_Line (" Please report to Vitali.Kaufman@iname.com");

      Clean_Up;
      Set_Exit_Status (Failure);
end Gch.Driver;