#include "available-stubs.h"

#include <kstat.h>
#include "checker_api.h"

/* compiled from: . */
void stubs_chkr_check_kstat_ctl (kstat_ctl_t *kc, int right, const char *name);
void stubs_chkr_check_kstat (kstat_t *kc, int right, const char *name);

#ifdef HAVE_chkr_func
void
stubs_chkr_check_kstat_ctl (kstat_ctl_t *kc, int right, const char *name)
{
  return;
}

void
stubs_chkr_check_kstat (kstat_t *kc, int right, const char *name)
{
  return;
}
#endif /* HAVE_chkr_func */

#ifdef HAVE_kstat_open
static void
stubs_chkr_set_kstat_ctl_right (kstat_ctl_t *kc, int right)
{
  return;
}

/* From `/usr/include/kstat.h:28'.  */
kstat_ctl_t *chkr_stub_kstat_open (void) __asm__ (CHKR_PREFIX ("kstat_open"));
kstat_ctl_t *
chkr_stub_kstat_open (void)
{
  kstat_ctl_t *res;
  res = kstat_open ();
  stubs_chkr_set_kstat_ctl_right (res, CHKR_RW);
  return res;
}
#endif /* HAVE_kstat_open */

#ifdef HAVE_kstat_close
/* From `/usr/include/kstat.h:29'.  */
int chkr_stub_kstat_close (kstat_ctl_t *kc)
     __asm__ (CHKR_PREFIX ("kstat_close"));
int
chkr_stub_kstat_close (kstat_ctl_t *kc)
{
  stubs_chkr_check_kstat_ctl (kc, CHKR_RO, "kc");
  return kstat_close (kc);
}
#endif /* HAVE_kstat_close */

#ifdef HAVE_kstat_read
/* From `/usr/include/kstat.h:30'.  */
kid_t chkr_stub_kstat_read (kstat_ctl_t *kc, kstat_t *ksp, void *buf)
     __asm__ (CHKR_PREFIX ("kstat_read"));
kid_t
chkr_stub_kstat_read (kstat_ctl_t *kc, kstat_t *ksp, void *buf)
{
  kid_t res;

  stubs_chkr_check_kstat_ctl (kc, CHKR_RO, "kc");
  stubs_chkr_check_kstat (ksp, CHKR_RW, "ksp");

  res = kstat_read (kc, ksp, buf);
  return res;
}
#endif /* HAVE_kstat_read */

#ifdef HAVE_kstat_write
/* From `/usr/include/kstat.h:31'.  */
kid_t chkr_stub_kstat_write (kstat_ctl_t * arg0, kstat_t * arg1, void * arg2) __asm__ (CHKR_PREFIX ("kstat_write"));
kid_t
chkr_stub_kstat_write (kstat_ctl_t * arg0, kstat_t * arg1, void * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (kstat_ctl_t), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (kstat_t), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg2, sizeof (void), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (kstat_write);
#else
  return kstat_write (arg0, arg1, arg2);
  {
    kid_t res;
    res = kstat_write (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_kstat_write */

#ifdef HAVE_kstat_chain_update
/* From `/usr/include/kstat.h:32'.  */
kid_t chkr_stub_kstat_chain_update (kstat_ctl_t * arg0) __asm__ (CHKR_PREFIX ("kstat_chain_update"));
kid_t
chkr_stub_kstat_chain_update (kstat_ctl_t * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (kstat_ctl_t), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (kstat_chain_update);
#else
  return kstat_chain_update (arg0);
  {
    kid_t res;
    res = kstat_chain_update (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_kstat_chain_update */

#ifdef HAVE_kstat_lookup
/* From `/usr/include/kstat.h:33'.  */
kstat_t *chkr_stub_kstat_lookup (kstat_ctl_t *kc, char *ks_module,
				 int ks_instance, char *ks_name)
     __asm__ (CHKR_PREFIX ("kstat_lookup"));
kstat_t *
chkr_stub_kstat_lookup (kstat_ctl_t *kc, char *ks_module, int ks_instance,
			char *ks_name)
{
  kstat_t *res;
  stubs_chkr_check_kstat_ctl (kc, CHKR_RO, "kc");
  if (ks_module)
    stubs_chkr_check_str (ks_module, CHKR_RO, "ks_module");
  if (ks_name)
    stubs_chkr_check_str (ks_name, CHKR_RO, "ks_name");

  res = kstat_lookup (kc, ks_module, ks_instance, ks_name);
  return res;
}
#endif /* HAVE_kstat_lookup */

#ifdef HAVE_kstat_data_lookup
/* From `/usr/include/kstat.h:34'.  */
void *chkr_stub_kstat_data_lookup (kstat_t *ksp, char *name)
     __asm__ (CHKR_PREFIX ("kstat_data_lookup"));
void *
chkr_stub_kstat_data_lookup (kstat_t *ksp, char *name)
{
  void * res;

  stubs_chkr_check_kstat (ksp, CHKR_RO, "ksp");
  stubs_chkr_check_str (name, CHKR_RO, "name");

  res = kstat_data_lookup (ksp, name);
  return res;
}
#endif /* HAVE_kstat_data_lookup */

